/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.plugin.httpv;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import org.miaixz.bus.core.io.ByteString;
import org.miaixz.bus.core.lang.MediaType;
import org.miaixz.bus.http.Callback;
import org.miaixz.bus.http.Headers;
import org.miaixz.bus.http.Response;
import org.miaixz.bus.http.plugin.httpv.CoverArray;
import org.miaixz.bus.http.plugin.httpv.CoverHttp;
import org.miaixz.bus.http.plugin.httpv.CoverTasks;
import org.miaixz.bus.http.plugin.httpv.CoverWapper;
import org.miaixz.bus.http.plugin.httpv.Downloads;
import org.miaixz.bus.http.plugin.httpv.Progress;
import org.miaixz.bus.http.plugin.httpv.ResultBody;

public interface CoverResult {
    public static CoverResult of(Response response) {
        return CoverResult.of(response, null);
    }

    public static CoverResult of(Response response, CoverTasks.Executor executor) {
        if (null != response) {
            return new Real(null, response, executor);
        }
        throw new IllegalArgumentException("Response cannot be empty!");
    }

    public State getState();

    public int getStatus();

    public boolean isSuccessful();

    public Headers getHeaders();

    public List<String> getHeaders(String var1);

    public String getHeader(String var1);

    public long getContentLength();

    public Body getBody();

    public IOException getError();

    public CoverResult close();

    public static class Real
    implements CoverResult {
        private State state;
        private Response response;
        private IOException error;
        private CoverTasks.Executor executor;
        private CoverHttp<?> coverHttp;
        private Body body;

        public Real(CoverHttp<?> coverHttp, State state) {
            this.coverHttp = coverHttp;
            this.state = state;
        }

        public Real(CoverHttp<?> coverHttp, Response response, CoverTasks.Executor executor) {
            this(coverHttp, executor);
            this.response(response);
        }

        public Real(CoverHttp<?> coverHttp, CoverTasks.Executor executor) {
            this.coverHttp = coverHttp;
            this.executor = executor;
        }

        public Real(CoverHttp<?> coverHttp, State state, IOException error) {
            this.coverHttp = coverHttp;
            this.exception(state, error);
        }

        public void exception(State state, IOException error) {
            this.state = state;
            this.error = error;
        }

        public void response(Response response) {
            this.state = State.RESPONSED;
            this.response = response;
        }

        @Override
        public State getState() {
            return this.state;
        }

        @Override
        public int getStatus() {
            if (null != this.response) {
                return this.response.code();
            }
            return 0;
        }

        @Override
        public boolean isSuccessful() {
            if (null != this.response) {
                return this.response.isSuccessful();
            }
            return false;
        }

        @Override
        public Headers getHeaders() {
            if (null != this.response) {
                return this.response.headers();
            }
            return null;
        }

        @Override
        public List<String> getHeaders(String name) {
            if (null != this.response) {
                return this.response.headers(name);
            }
            return Collections.emptyList();
        }

        @Override
        public String getHeader(String name) {
            if (null != this.response) {
                return this.response.header(name);
            }
            return null;
        }

        @Override
        public long getContentLength() {
            String length = this.getHeader("Content-Length");
            if (null != length) {
                try {
                    return Long.parseLong(length);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return 0L;
        }

        @Override
        public synchronized Body getBody() {
            if (null == this.body && null != this.response) {
                this.body = new ResultBody(this.coverHttp, this.response, this.executor);
            }
            return this.body;
        }

        @Override
        public IOException getError() {
            return this.error;
        }

        public Response getResponse() {
            return this.response;
        }

        public String toString() {
            Body body = this.getBody();
            String text = "RealResult [\n  state: " + String.valueOf((Object)this.state) + ",\n  status: " + this.getStatus() + ",\n  headers: " + String.valueOf(this.getHeaders());
            if (null != body) {
                text = text + ",\n  contentType: " + String.valueOf(body.getType());
            }
            return text + ",\n  error: " + String.valueOf(this.error) + "\n]";
        }

        @Override
        public CoverResult close() {
            if (null != this.response) {
                this.response.close();
            }
            return this;
        }
    }

    public static interface Body {
        public InputStream toByteStream();

        public byte[] toBytes();

        public ByteString toByteString();

        public Reader toCharStream();

        public String toString();

        public CoverWapper toWapper();

        public CoverArray toArray();

        public <T> T toBean(Class<T> var1);

        public <T> List<T> toList(Class<T> var1);

        public MediaType getType();

        public long getLength();

        public Body nextOnIO();

        public Body setOnProcess(Callback<Progress> var1);

        public Body stepBytes(long var1);

        public Body stepRate(double var1);

        public Body setRangeIgnored();

        public Downloads toFile(String var1);

        public Downloads toFile(File var1);

        public Downloads toFolder(String var1);

        public Downloads toFolder(File var1);

        public Body cache();

        public Body close();
    }

    public static enum State {
        EXCEPTION,
        CANCELED,
        RESPONSED,
        TIMEOUT,
        NETWORK_ERROR;

    }
}

