/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.plugin.httpz;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.core.lang.MediaType;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.http.Headers;
import org.miaixz.bus.http.Request;
import org.miaixz.bus.http.bodys.FormBody;
import org.miaixz.bus.http.bodys.MultipartBody;
import org.miaixz.bus.http.bodys.RequestBody;
import org.miaixz.bus.http.plugin.httpz.HttpRequest;

public class PostRequest
extends HttpRequest {
    public PostRequest(String url, Object tag, Map<String, String> params, Map<String, String> headers, List<FileInfo> fileInfos, String postBody, MultipartBody multipartBody, String id) {
        super(url, tag, params, headers, fileInfos, postBody, multipartBody, id);
    }

    public PostRequest(String url, Object tag, Map<String, String> params, Map<String, String> encodeParams, Map<String, String> headers, List<FileInfo> fileInfos, String postBody, MultipartBody multipartBody, String id) {
        super(url, tag, params, encodeParams, headers, fileInfos, postBody, multipartBody, id);
    }

    @Override
    protected RequestBody buildRequestBody() {
        if (null != this.multipartBody) {
            return this.multipartBody;
        }
        if (null != this.fileInfos && this.fileInfos.size() > 0) {
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MediaType.MULTIPART_FORM_DATA_TYPE);
            this.addParams(builder);
            this.fileInfos.forEach(fileInfo -> {
                RequestBody fileBody = null != fileInfo.file ? RequestBody.create(MediaType.APPLICATION_OCTET_STREAM_TYPE, fileInfo.file) : (null != fileInfo.fileInputStream ? PostRequest.createRequestBody(MediaType.APPLICATION_OCTET_STREAM_TYPE, fileInfo.fileInputStream) : RequestBody.create(MediaType.valueOf((String)((String)ObjectKit.defaultIfNull((Object)FileKit.getMimeType((String)fileInfo.fileName), (Object)"application/octet-stream"))), fileInfo.fileContent));
                builder.addFormDataPart(fileInfo.partName, fileInfo.fileName, fileBody);
            });
            if (null != this.body && this.body.length() > 0) {
                builder.addPart(RequestBody.create(MediaType.MULTIPART_FORM_DATA_TYPE, this.body));
            }
            return builder.build();
        }
        if (null != this.body && this.body.length() > 0) {
            MediaType mediaType = this.headers.containsKey("Content-Type") ? MediaType.valueOf((String)((String)this.headers.get("Content-Type"))) : MediaType.TEXT_PLAIN_TYPE;
            return RequestBody.create(mediaType, this.body);
        }
        FormBody.Builder builder = new FormBody.Builder();
        this.addParams(builder);
        return builder.build();
    }

    @Override
    protected Request buildRequest(RequestBody requestBody) {
        return this.builder.post(requestBody).build();
    }

    private void addParams(FormBody.Builder builder) {
        if (null != this.params) {
            this.params.forEach((k, v) -> builder.add((String)k, (String)v));
        }
        if (null != this.encodedParams) {
            this.encodedParams.forEach((k, v) -> builder.addEncoded((String)k, (String)v));
        }
    }

    private void addParams(MultipartBody.Builder builder) {
        if (null != this.params && !this.params.isEmpty()) {
            this.params.forEach((k, v) -> builder.addPart(Headers.of("Content-Disposition", "form-data; name=\"" + k + "\""), RequestBody.create(null, v)));
        }
    }

    public static class FileInfo {
        public String partName;
        public String fileName;
        public byte[] fileContent;
        public File file;
        public InputStream fileInputStream;
    }
}

