/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.plugin.httpz;

import java.util.LinkedHashMap;
import java.util.Map;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.http.Httpd;
import org.miaixz.bus.http.plugin.httpz.RequestCall;

public abstract class RequestBuilder<T extends RequestBuilder> {
    protected Httpd httpd;
    protected String id;
    protected String url;
    protected Object tag;
    protected Map<String, String> headers;
    protected Map<String, String> params;
    protected Map<String, String> encoded;

    public RequestBuilder(Httpd httpd) {
        this.httpd = httpd;
        this.headers = new LinkedHashMap<String, String>();
        this.params = new LinkedHashMap<String, String>();
        this.encoded = new LinkedHashMap<String, String>();
    }

    public T id(String id) {
        this.id = id;
        return (T)this;
    }

    public T url(String url) {
        this.url = url;
        return (T)this;
    }

    public T tag(Object tag) {
        this.tag = tag;
        return (T)this;
    }

    public T addHeader(Map<String, String> headers) {
        this.headers = headers;
        return (T)this;
    }

    public T addHeader(String key, String val) {
        this.headers.put(key, val);
        return (T)this;
    }

    public T addParam(Map<String, String> params) {
        this.params = params;
        return (T)this;
    }

    public T addParam(String key, String val) {
        this.params.put(key, val);
        return (T)this;
    }

    public T addParam(Object object) {
        if (null != object) {
            Map map = BeanKit.beanToMap((Object)object, (String[])new String[0]);
            map.forEach((key, val) -> this.addParam((String)key, (String)val));
        }
        return (T)this;
    }

    public T addEncoded(Map<String, String> params) {
        this.encoded = params;
        return (T)this;
    }

    public T addEncoded(String key, String val) {
        this.encoded.put(key, val);
        return (T)this;
    }

    public abstract RequestCall build();
}

