/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.metric.anget;

import java.util.regex.Pattern;
import lombok.Generated;
import org.miaixz.bus.core.xyz.PatternKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.http.metric.anget.Browser;
import org.miaixz.bus.http.metric.anget.Device;
import org.miaixz.bus.http.metric.anget.Engine;
import org.miaixz.bus.http.metric.anget.NOS;

public class UserAgent {
    private boolean mobile;
    private Browser browser;
    private Device device;
    private NOS nos;
    private Engine engine;
    private String version;
    private String engineVersion;
    private String name;
    private Pattern pattern;

    public UserAgent() {
    }

    public UserAgent(String name, String regex) {
        this(name, null == regex ? null : Pattern.compile(regex, 2));
    }

    public UserAgent(String name, Pattern pattern) {
        this.name = name;
        this.pattern = pattern;
    }

    public static UserAgent parse(String text) {
        if (StringKit.isBlank((CharSequence)text)) {
            return null;
        }
        UserAgent userAgent = new UserAgent();
        Browser browser = UserAgent.parseBrowser(text);
        userAgent.setBrowser(browser);
        userAgent.setVersion(browser.getVersion(text));
        Engine engine = UserAgent.parseEngine(text);
        userAgent.setEngine(engine);
        userAgent.setEngineVersion(engine.getVersion(text));
        NOS os = UserAgent.parseNOS(text);
        userAgent.setNos(os);
        userAgent.setVersion(os.getVersion(text));
        Device device = UserAgent.parseDevice(text);
        userAgent.setDevice(device);
        if ((device.isMobile() || browser.isMobile()) && !os.isMacOS()) {
            userAgent.setMobile(true);
        }
        return userAgent;
    }

    public boolean isMatch(String content) {
        return PatternKit.contains((Pattern)this.pattern, (CharSequence)content);
    }

    public boolean isUnknown() {
        return "unknown".equals(this.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (null == this.name ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UserAgent other = (UserAgent)object;
        if (null == this.name) {
            return null == other.name;
        }
        return this.name.equals(other.name);
    }

    public String toString() {
        return this.name;
    }

    private static Browser parseBrowser(String text) {
        for (Browser browser : Browser.BROWERS) {
            if (!browser.isMatch(text)) continue;
            return browser;
        }
        return Browser.UNKNOWN;
    }

    private static Engine parseEngine(String text) {
        for (Engine engine : Engine.ENGINES) {
            if (!engine.isMatch(text)) continue;
            return engine;
        }
        return Engine.UNKNOWN;
    }

    private static NOS parseNOS(String text) {
        for (NOS os : NOS.NOS) {
            if (!os.isMatch(text)) continue;
            return os;
        }
        return NOS.UNKNOWN;
    }

    private static Device parseDevice(String text) {
        for (Device platform : Device.ALL_DEVICE) {
            if (!platform.isMatch(text)) continue;
            return platform;
        }
        return Device.UNKNOWN;
    }

    @Generated
    public boolean isMobile() {
        return this.mobile;
    }

    @Generated
    public Browser getBrowser() {
        return this.browser;
    }

    @Generated
    public Device getDevice() {
        return this.device;
    }

    @Generated
    public NOS getNos() {
        return this.nos;
    }

    @Generated
    public Engine getEngine() {
        return this.engine;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getEngineVersion() {
        return this.engineVersion;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Pattern getPattern() {
        return this.pattern;
    }

    @Generated
    public void setMobile(boolean mobile) {
        this.mobile = mobile;
    }

    @Generated
    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    @Generated
    public void setDevice(Device device) {
        this.device = device;
    }

    @Generated
    public void setNos(NOS nos) {
        this.nos = nos;
    }

    @Generated
    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }
}

