/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.bodys;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.miaixz.bus.core.io.ByteString;
import org.miaixz.bus.core.io.sink.BufferSink;
import org.miaixz.bus.core.io.source.Source;
import org.miaixz.bus.core.lang.MediaType;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.http.Builder;

public abstract class RequestBody {
    public static RequestBody create(MediaType mediaType, String content) {
        Charset charset = org.miaixz.bus.core.lang.Charset.UTF_8;
        if (mediaType != null && (charset = mediaType.charset()) == null) {
            charset = org.miaixz.bus.core.lang.Charset.UTF_8;
            mediaType = MediaType.valueOf((String)(String.valueOf(mediaType) + "; charset=utf-8"));
        }
        byte[] bytes = content.getBytes(charset);
        return RequestBody.create(mediaType, bytes);
    }

    public static RequestBody create(final MediaType mediaType, final ByteString content) {
        return new RequestBody(){

            @Override
            public MediaType mediaType() {
                return mediaType;
            }

            @Override
            public long length() {
                return content.size();
            }

            @Override
            public void writeTo(BufferSink sink) throws IOException {
                sink.write(content);
            }
        };
    }

    public static RequestBody create(MediaType mediaType, byte[] content) {
        return RequestBody.create(mediaType, content, 0, content.length);
    }

    public static RequestBody create(final MediaType mediaType, final byte[] content, final int offset, final int byteCount) {
        if (null == content) {
            throw new NullPointerException("content == null");
        }
        Builder.checkOffsetAndCount(content.length, offset, byteCount);
        return new RequestBody(){

            @Override
            public MediaType mediaType() {
                return mediaType;
            }

            @Override
            public long length() {
                return byteCount;
            }

            @Override
            public void writeTo(BufferSink sink) throws IOException {
                sink.write(content, offset, byteCount);
            }
        };
    }

    public static RequestBody create(final MediaType mediaType, final File file) {
        if (null == file) {
            throw new NullPointerException("file == null");
        }
        return new RequestBody(){

            @Override
            public MediaType mediaType() {
                return mediaType;
            }

            @Override
            public long length() {
                return file.length();
            }

            @Override
            public void writeTo(BufferSink sink) throws IOException {
                try (Source source = IoKit.source((File)file);){
                    sink.writeAll(source);
                }
            }
        };
    }

    public abstract MediaType mediaType();

    public long length() throws IOException {
        return -1L;
    }

    public abstract void writeTo(BufferSink var1) throws IOException;

    public boolean isDuplex() {
        return false;
    }

    public boolean isOneShot() {
        return false;
    }
}

