/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.plugin.httpv;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.miaixz.bus.core.io.buffer.Buffer;
import org.miaixz.bus.core.io.sink.AssignSink;
import org.miaixz.bus.core.io.sink.BufferSink;
import org.miaixz.bus.core.io.sink.Sink;
import org.miaixz.bus.core.lang.MediaType;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.http.Callback;
import org.miaixz.bus.http.bodys.RequestBody;
import org.miaixz.bus.http.plugin.httpv.Progress;

public class ProgressBody
extends RequestBody {
    private RequestBody requestBody;
    private Callback<Progress> onProcess;
    private Executor callbackExecutor;
    private long stepBytes;
    private long step = 0L;
    private Progress progress;
    private boolean doneCalled = false;
    private BufferSink bufferedSink;

    public ProgressBody(RequestBody requestBody, Callback<Progress> onProcess, Executor callbackExecutor, long contentLength, long stepBytes) {
        this.requestBody = requestBody;
        this.onProcess = onProcess;
        this.callbackExecutor = callbackExecutor;
        this.stepBytes = stepBytes;
        this.progress = new Progress(contentLength, 0L);
    }

    @Override
    public long length() {
        return this.progress.getTotalBytes();
    }

    @Override
    public MediaType mediaType() {
        return this.requestBody.mediaType();
    }

    @Override
    public void writeTo(BufferSink sink) throws IOException {
        if (null == this.bufferedSink) {
            this.bufferedSink = IoKit.buffer((Sink)new AssignSink((Sink)sink){

                public void write(Buffer source, long byteCount) throws IOException {
                    super.write(source, byteCount);
                    ProgressBody.this.progress.addDoneBytes(byteCount);
                    if (ProgressBody.this.progress.notDoneOrReached(ProgressBody.this.step * ProgressBody.this.stepBytes)) {
                        return;
                    }
                    if (ProgressBody.this.progress.isDone()) {
                        if (ProgressBody.this.doneCalled) {
                            return;
                        }
                        ProgressBody.this.doneCalled = true;
                    }
                    ++ProgressBody.this.step;
                    ProgressBody.this.callbackExecutor.execute(() -> ProgressBody.this.onProcess.on(ProgressBody.this.progress));
                }
            });
        }
        this.requestBody.writeTo(this.bufferedSink);
        this.bufferedSink.flush();
    }
}

