/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.metric.http;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.miaixz.bus.core.io.sink.Sink;
import org.miaixz.bus.core.io.source.Source;
import org.miaixz.bus.core.net.Protocol;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.http.Builder;
import org.miaixz.bus.http.Headers;
import org.miaixz.bus.http.Httpd;
import org.miaixz.bus.http.Request;
import org.miaixz.bus.http.Response;
import org.miaixz.bus.http.accord.RealConnection;
import org.miaixz.bus.http.metric.Internal;
import org.miaixz.bus.http.metric.NewChain;
import org.miaixz.bus.http.metric.http.Http2Connection;
import org.miaixz.bus.http.metric.http.Http2ErrorCode;
import org.miaixz.bus.http.metric.http.Http2Header;
import org.miaixz.bus.http.metric.http.Http2Stream;
import org.miaixz.bus.http.metric.http.HttpCodec;
import org.miaixz.bus.http.metric.http.RequestLine;
import org.miaixz.bus.http.metric.http.StatusLine;

public class Http2Codec
implements HttpCodec {
    private static final List<String> HTTP_2_SKIPPED_REQUEST_HEADERS = Builder.immutableList("Connection", "Host", "Keep-Alive", "Proxy-Connection", "te", "Transfer-Encoding", "Encoding", "Upgrade", ":method", ":path", ":scheme", ":authority");
    private static final List<String> HTTP_2_SKIPPED_RESPONSE_HEADERS = Builder.immutableList("Connection", "Host", "Keep-Alive", "Proxy-Connection", "te", "Transfer-Encoding", "Encoding", "Upgrade");
    private final NewChain chain;
    private final RealConnection realConnection;
    private final Http2Connection connection;
    private final Protocol protocol;
    private volatile Http2Stream stream;
    private volatile boolean canceled;

    public Http2Codec(Httpd client, RealConnection realConnection, NewChain chain, Http2Connection connection) {
        this.realConnection = realConnection;
        this.chain = chain;
        this.connection = connection;
        this.protocol = client.protocols().contains(Protocol.H2_PRIOR_KNOWLEDGE) ? Protocol.H2_PRIOR_KNOWLEDGE : Protocol.HTTP_2;
    }

    public static List<Http2Header> http2HeadersList(Request request) {
        Headers headers = request.headers();
        ArrayList<Http2Header> result = new ArrayList<Http2Header>(headers.size() + 4);
        result.add(new Http2Header(Http2Header.TARGET_METHOD, request.method()));
        result.add(new Http2Header(Http2Header.TARGET_PATH, RequestLine.requestPath(request.url())));
        String host = request.header("Host");
        if (host != null) {
            result.add(new Http2Header(Http2Header.TARGET_AUTHORITY, host));
        }
        result.add(new Http2Header(Http2Header.TARGET_SCHEME, request.url().scheme()));
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            String name = StringKit.upperFirst((CharSequence)headers.name(i));
            if (HTTP_2_SKIPPED_REQUEST_HEADERS.contains(name) && (!name.equals("te") || !"trailers".equals(headers.value(i)))) continue;
            result.add(new Http2Header(name, headers.value(i)));
        }
        return result;
    }

    public static Response.Builder readHttp2HeadersList(Headers headerBlock, Protocol protocol) throws IOException {
        StatusLine statusLine = null;
        Headers.Builder headersBuilder = new Headers.Builder();
        int size = headerBlock.size();
        for (int i = 0; i < size; ++i) {
            String name = headerBlock.name(i);
            String value = headerBlock.value(i);
            if (name.equals(":status")) {
                statusLine = StatusLine.parse("HTTP/1.1 " + value);
                continue;
            }
            if (HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(name)) continue;
            Internal.instance.addLenient(headersBuilder, name, value);
        }
        if (statusLine == null) {
            throw new ProtocolException("Expected ':status' header not present");
        }
        return new Response.Builder().protocol(protocol).code(statusLine.code).message(statusLine.message).headers(headersBuilder.build());
    }

    @Override
    public RealConnection connection() {
        return this.realConnection;
    }

    @Override
    public Sink createRequestBody(Request request, long contentLength) {
        return this.stream.getSink();
    }

    @Override
    public void writeRequestHeaders(Request request) throws IOException {
        if (this.stream != null) {
            return;
        }
        boolean hasRequestBody = request.body() != null;
        List<Http2Header> requestHeaders = Http2Codec.http2HeadersList(request);
        this.stream = this.connection.newStream(requestHeaders, hasRequestBody);
        if (this.canceled) {
            this.stream.closeLater(Http2ErrorCode.CANCEL);
            throw new IOException("Canceled");
        }
        this.stream.readTimeout().timeout((long)this.chain.readTimeoutMillis(), TimeUnit.MILLISECONDS);
        this.stream.writeTimeout().timeout((long)this.chain.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void flushRequest() throws IOException {
        this.connection.flush();
    }

    @Override
    public void finishRequest() throws IOException {
        this.stream.getSink().close();
    }

    @Override
    public Response.Builder readResponseHeaders(boolean expectContinue) throws IOException {
        Headers headers = this.stream.takeHeaders();
        Response.Builder responseBuilder = Http2Codec.readHttp2HeadersList(headers, this.protocol);
        if (expectContinue && Internal.instance.code(responseBuilder) == 100) {
            return null;
        }
        return responseBuilder;
    }

    @Override
    public long reportedContentLength(Response response) {
        return Headers.contentLength(response);
    }

    @Override
    public Source openResponseBodySource(Response response) {
        return this.stream.getSource();
    }

    @Override
    public Headers trailers() throws IOException {
        return this.stream.trailers();
    }

    @Override
    public void cancel() {
        this.canceled = true;
        if (this.stream != null) {
            this.stream.closeLater(Http2ErrorCode.CANCEL);
        }
    }
}

