/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.miaixz.bus.core.io.buffer.Buffer;
import org.miaixz.bus.core.lang.Normal;
import org.miaixz.bus.core.net.Protocol;

public class UnoUrl {
    public static final String USERNAME_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    public static final String PASSWORD_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    public static final String PATH_SEGMENT_ENCODE_SET = " \"<>^`{}|/\\?#";
    public static final String PATH_SEGMENT_ENCODE_SET_URI = "[]";
    public static final String QUERY_ENCODE_SET = " \"'<>#";
    public static final String QUERY_COMPONENT_REENCODE_SET = " \"'<>#&=";
    public static final String QUERY_COMPONENT_ENCODE_SET = " !\"#$&'(),/:;<=>?@[]\\^`{|}~";
    public static final String QUERY_COMPONENT_ENCODE_SET_URI = "\\^`{|}";
    public static final String FORM_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#&!$(),~";
    public static final String FRAGMENT_ENCODE_SET = "";
    public static final String FRAGMENT_ENCODE_SET_URI = " \"#<>\\^`{|}";
    final String scheme;
    final String host;
    final int port;
    private final String username;
    private final String password;
    private final List<String> pathSegments;
    private final List<String> queryNamesAndValues;
    private final String fragment;
    private final String url;

    UnoUrl(Builder builder) {
        this.scheme = builder.scheme;
        this.username = UnoUrl.percentDecode(builder.encodedUsername, false);
        this.password = UnoUrl.percentDecode(builder.encodedPassword, false);
        this.host = builder.host;
        this.port = builder.effectivePort();
        this.pathSegments = this.percentDecode(builder.encodedPathSegments, false);
        this.queryNamesAndValues = null != builder.encodedQueryNamesAndValues ? this.percentDecode(builder.encodedQueryNamesAndValues, true) : null;
        this.fragment = null != builder.encodedFragment ? UnoUrl.percentDecode(builder.encodedFragment, false) : null;
        this.url = builder.toString();
    }

    public static int defaultPort(String scheme) {
        if (Protocol.HTTP.name.equals(scheme)) {
            return 80;
        }
        if (Protocol.HTTPS.name.equals(scheme)) {
            return 443;
        }
        return -1;
    }

    static void pathSegmentsToString(StringBuilder out, List<String> pathSegments) {
        int size = pathSegments.size();
        for (int i = 0; i < size; ++i) {
            out.append('/');
            out.append(pathSegments.get(i));
        }
    }

    static void namesAndValuesToQueryString(StringBuilder out, List<String> namesAndValues) {
        int size = namesAndValues.size();
        for (int i = 0; i < size; i += 2) {
            String name = namesAndValues.get(i);
            String value = namesAndValues.get(i + 1);
            if (i > 0) {
                out.append('&');
            }
            out.append(name);
            if (null == value) continue;
            out.append('=');
            out.append(value);
        }
    }

    static List<String> queryStringToNamesAndValues(String encodedQuery) {
        ArrayList<String> result = new ArrayList<String>();
        int pos = 0;
        while (pos <= encodedQuery.length()) {
            int equalsOffset;
            int ampersandOffset = encodedQuery.indexOf(38, pos);
            if (ampersandOffset == -1) {
                ampersandOffset = encodedQuery.length();
            }
            if ((equalsOffset = encodedQuery.indexOf(61, pos)) == -1 || equalsOffset > ampersandOffset) {
                result.add(encodedQuery.substring(pos, ampersandOffset));
                result.add(null);
            } else {
                result.add(encodedQuery.substring(pos, equalsOffset));
                result.add(encodedQuery.substring(equalsOffset + 1, ampersandOffset));
            }
            pos = ampersandOffset + 1;
        }
        return result;
    }

    public static UnoUrl parse(String url) {
        try {
            return UnoUrl.get(url);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public static UnoUrl get(String url) {
        return new Builder().parse(null, url).build();
    }

    public static UnoUrl get(URL url) {
        return UnoUrl.parse(url.toString());
    }

    public static UnoUrl get(URI uri) {
        return UnoUrl.parse(uri.toString());
    }

    public static String percentDecode(String encoded, boolean plusIsSpace) {
        return UnoUrl.percentDecode(encoded, 0, encoded.length(), plusIsSpace);
    }

    public static String percentDecode(String encoded, int pos, int limit, boolean plusIsSpace) {
        for (int i = pos; i < limit; ++i) {
            char c = encoded.charAt(i);
            if (c != '%' && (c != '+' || !plusIsSpace)) continue;
            Buffer out = new Buffer();
            out.writeUtf8(encoded, pos, i);
            UnoUrl.percentDecode(out, encoded, i, limit, plusIsSpace);
            return out.readUtf8();
        }
        return encoded.substring(pos, limit);
    }

    public static void percentDecode(Buffer out, String encoded, int pos, int limit, boolean plusIsSpace) {
        int codePoint;
        for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
            codePoint = encoded.codePointAt(i);
            if (codePoint == 37 && i + 2 < limit) {
                int d1 = org.miaixz.bus.http.Builder.decodeHexDigit(encoded.charAt(i + 1));
                int d2 = org.miaixz.bus.http.Builder.decodeHexDigit(encoded.charAt(i + 2));
                if (d1 != -1 && d2 != -1) {
                    out.writeByte((d1 << 4) + d2);
                    i += 2;
                    continue;
                }
            } else if (codePoint == 43 && plusIsSpace) {
                out.writeByte(32);
                continue;
            }
            out.writeUtf8CodePoint(codePoint);
        }
    }

    public static boolean percentEncoded(String encoded, int pos, int limit) {
        return pos + 2 < limit && encoded.charAt(pos) == '%' && org.miaixz.bus.http.Builder.decodeHexDigit(encoded.charAt(pos + 1)) != -1 && org.miaixz.bus.http.Builder.decodeHexDigit(encoded.charAt(pos + 2)) != -1;
    }

    public static String canonicalize(String input, int pos, int limit, String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly, Charset charset) {
        int codePoint;
        for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
            codePoint = input.codePointAt(i);
            if (!(codePoint < 32 || codePoint == 127 || codePoint >= 128 && asciiOnly || encodeSet.indexOf(codePoint) != -1 || codePoint == 37 && (!alreadyEncoded || strict && !UnoUrl.percentEncoded(input, i, limit))) && (codePoint != 43 || !plusIsSpace)) continue;
            Buffer out = new Buffer();
            out.writeUtf8(input, pos, i);
            UnoUrl.canonicalize(out, input, i, limit, encodeSet, alreadyEncoded, strict, plusIsSpace, asciiOnly, charset);
            return out.readUtf8();
        }
        return input.substring(pos, limit);
    }

    public static void canonicalize(Buffer out, String input, int pos, int limit, String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly, Charset charset) {
        int codePoint;
        Buffer encodedCharBuffer = null;
        for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
            codePoint = input.codePointAt(i);
            if (alreadyEncoded && (codePoint == 9 || codePoint == 10 || codePoint == 12 || codePoint == 13)) continue;
            if (codePoint == 43 && plusIsSpace) {
                out.writeUtf8(alreadyEncoded ? "+" : "%2B");
                continue;
            }
            if (codePoint < 32 || codePoint == 127 || codePoint >= 128 && asciiOnly || encodeSet.indexOf(codePoint) != -1 || codePoint == 37 && (!alreadyEncoded || strict && !UnoUrl.percentEncoded(input, i, limit))) {
                if (null == encodedCharBuffer) {
                    encodedCharBuffer = new Buffer();
                }
                if (null == charset || charset.equals(org.miaixz.bus.core.lang.Charset.UTF_8)) {
                    encodedCharBuffer.writeUtf8CodePoint(codePoint);
                } else {
                    encodedCharBuffer.writeString(input, i, i + Character.charCount(codePoint), charset);
                }
                while (!encodedCharBuffer.exhausted()) {
                    int b = encodedCharBuffer.readByte() & 0xFF;
                    out.writeByte(37);
                    out.writeByte((int)Normal.DIGITS_16_UPPER[b >> 4 & 0xF]);
                    out.writeByte((int)Normal.DIGITS_16_UPPER[b & 0xF]);
                }
                continue;
            }
            out.writeUtf8CodePoint(codePoint);
        }
    }

    public static String canonicalize(String input, String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly, Charset charset) {
        return UnoUrl.canonicalize(input, 0, input.length(), encodeSet, alreadyEncoded, strict, plusIsSpace, asciiOnly, charset);
    }

    public static String canonicalize(String input, String encodeSet, boolean alreadyEncoded, boolean strict, boolean plusIsSpace, boolean asciiOnly) {
        return UnoUrl.canonicalize(input, 0, input.length(), encodeSet, alreadyEncoded, strict, plusIsSpace, asciiOnly, null);
    }

    public URL url() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public URI uri() {
        String uri = this.newBuilder().reencodeForUri().toString();
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            try {
                String stripped = uri.replaceAll("[\u0000-\u001f\u007f-\u009f\\p{javaWhitespace}]", FRAGMENT_ENCODE_SET);
                return URI.create(stripped);
            }
            catch (Exception e1) {
                throw new RuntimeException(e);
            }
        }
    }

    public String scheme() {
        return this.scheme;
    }

    public boolean isHttps() {
        return Protocol.isHttps((String)this.scheme);
    }

    public String encodedUsername() {
        if (this.username.isEmpty()) {
            return FRAGMENT_ENCODE_SET;
        }
        int usernameStart = this.scheme.length() + 3;
        int usernameEnd = org.miaixz.bus.http.Builder.delimiterOffset(this.url, usernameStart, this.url.length(), ":@");
        return this.url.substring(usernameStart, usernameEnd);
    }

    public String username() {
        return this.username;
    }

    public String encodedPassword() {
        if (this.password.isEmpty()) {
            return FRAGMENT_ENCODE_SET;
        }
        int passwordStart = this.url.indexOf(58, this.scheme.length() + 3) + 1;
        int passwordEnd = this.url.indexOf(64);
        return this.url.substring(passwordStart, passwordEnd);
    }

    public String password() {
        return this.password;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int pathSize() {
        return this.pathSegments.size();
    }

    public String encodedPath() {
        int pathStart = this.url.indexOf(47, this.scheme.length() + 3);
        int pathEnd = org.miaixz.bus.http.Builder.delimiterOffset(this.url, pathStart, this.url.length(), "?#");
        return this.url.substring(pathStart, pathEnd);
    }

    public List<String> encodedPathSegments() {
        int pathStart = this.url.indexOf(47, this.scheme.length() + 3);
        int pathEnd = org.miaixz.bus.http.Builder.delimiterOffset(this.url, pathStart, this.url.length(), "?#");
        ArrayList<String> result = new ArrayList<String>();
        int i = pathStart;
        while (i < pathEnd) {
            int segmentEnd = org.miaixz.bus.http.Builder.delimiterOffset(this.url, ++i, pathEnd, '/');
            result.add(this.url.substring(i, segmentEnd));
            i = segmentEnd;
        }
        return result;
    }

    public List<String> pathSegments() {
        return this.pathSegments;
    }

    public String encodedQuery() {
        if (null == this.queryNamesAndValues) {
            return null;
        }
        int queryStart = this.url.indexOf(63) + 1;
        int queryEnd = org.miaixz.bus.http.Builder.delimiterOffset(this.url, queryStart, this.url.length(), '#');
        return this.url.substring(queryStart, queryEnd);
    }

    public String query() {
        if (null == this.queryNamesAndValues) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        UnoUrl.namesAndValuesToQueryString(result, this.queryNamesAndValues);
        return result.toString();
    }

    public int querySize() {
        return null != this.queryNamesAndValues ? this.queryNamesAndValues.size() / 2 : 0;
    }

    public String queryParameter(String name) {
        if (null == this.queryNamesAndValues) {
            return null;
        }
        int size = this.queryNamesAndValues.size();
        for (int i = 0; i < size; i += 2) {
            if (!name.equals(this.queryNamesAndValues.get(i))) continue;
            return this.queryNamesAndValues.get(i + 1);
        }
        return null;
    }

    public Set<String> queryParameterNames() {
        if (null == this.queryNamesAndValues) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        int size = this.queryNamesAndValues.size();
        for (int i = 0; i < size; i += 2) {
            result.add(this.queryNamesAndValues.get(i));
        }
        return Collections.unmodifiableSet(result);
    }

    public List<String> queryParameterValues(String name) {
        if (null == this.queryNamesAndValues) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        int size = this.queryNamesAndValues.size();
        for (int i = 0; i < size; i += 2) {
            if (!name.equals(this.queryNamesAndValues.get(i))) continue;
            result.add(this.queryNamesAndValues.get(i + 1));
        }
        return Collections.unmodifiableList(result);
    }

    public String queryParameterName(int index) {
        if (null == this.queryNamesAndValues) {
            throw new IndexOutOfBoundsException();
        }
        return this.queryNamesAndValues.get(index * 2);
    }

    public String queryParameterValue(int index) {
        if (null == this.queryNamesAndValues) {
            throw new IndexOutOfBoundsException();
        }
        return this.queryNamesAndValues.get(index * 2 + 1);
    }

    public String encodedFragment() {
        if (null == this.fragment) {
            return null;
        }
        int fragmentStart = this.url.indexOf(35) + 1;
        return this.url.substring(fragmentStart);
    }

    public String fragment() {
        return this.fragment;
    }

    public String redact() {
        return this.newBuilder("/...").username(FRAGMENT_ENCODE_SET).password(FRAGMENT_ENCODE_SET).build().toString();
    }

    public UnoUrl resolve(String link) {
        Builder builder = this.newBuilder(link);
        return null != builder ? builder.build() : null;
    }

    public Builder newBuilder() {
        Builder result = new Builder();
        result.scheme = this.scheme;
        result.encodedUsername = this.encodedUsername();
        result.encodedPassword = this.encodedPassword();
        result.host = this.host;
        result.port = this.port != UnoUrl.defaultPort(this.scheme) ? this.port : -1;
        result.encodedPathSegments.clear();
        result.encodedPathSegments.addAll(this.encodedPathSegments());
        result.encodedQuery(this.encodedQuery());
        result.encodedFragment = this.encodedFragment();
        return result;
    }

    public Builder newBuilder(String link) {
        try {
            return new Builder().parse(this, link);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public boolean equals(Object other) {
        return other instanceof UnoUrl && ((UnoUrl)other).url.equals(this.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return this.url;
    }

    private List<String> percentDecode(List<String> list, boolean plusIsSpace) {
        int size = list.size();
        ArrayList<String> result = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            String s = list.get(i);
            result.add(null != s ? UnoUrl.percentDecode(s, plusIsSpace) : null);
        }
        return Collections.unmodifiableList(result);
    }

    public static class Builder {
        static final String INVALID_HOST = "Invalid URL host";
        final List<String> encodedPathSegments = new ArrayList<String>();
        String scheme;
        String encodedUsername = "";
        String encodedPassword = "";
        String host;
        int port = -1;
        List<String> encodedQueryNamesAndValues;
        String encodedFragment;

        public Builder() {
            this.encodedPathSegments.add(UnoUrl.FRAGMENT_ENCODE_SET);
        }

        private static int schemeDelimiterOffset(String input, int pos, int limit) {
            if (limit - pos < 2) {
                return -1;
            }
            char c0 = input.charAt(pos);
            if (!(c0 >= 'a' && c0 <= 'z' || c0 >= 'A' && c0 <= 'Z')) {
                return -1;
            }
            for (int i = pos + 1; i < limit; ++i) {
                char c = input.charAt(i);
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '+' || c == '-' || c == '.') continue;
                if (c == ':') {
                    return i;
                }
                return -1;
            }
            return -1;
        }

        private static int slashCount(String input, int pos, int limit) {
            char c;
            int slashCount = 0;
            while (pos < limit && ((c = input.charAt(pos)) == '\\' || c == '/')) {
                ++slashCount;
                ++pos;
            }
            return slashCount;
        }

        private static int portColonOffset(String input, int pos, int limit) {
            block4: for (int i = pos; i < limit; ++i) {
                switch (input.charAt(i)) {
                    case '[': {
                        while (++i < limit && input.charAt(i) != ']') {
                        }
                        continue block4;
                    }
                    case ':': {
                        return i;
                    }
                }
            }
            return limit;
        }

        private static String canonicalizeHost(String input, int pos, int limit) {
            return org.miaixz.bus.http.Builder.canonicalizeHost(UnoUrl.percentDecode(input, pos, limit, false));
        }

        private static int parsePort(String input, int pos, int limit) {
            try {
                String portString = UnoUrl.canonicalize(input, pos, limit, UnoUrl.FRAGMENT_ENCODE_SET, false, false, false, true, null);
                int i = Integer.parseInt(portString);
                if (i > 0 && i <= 65535) {
                    return i;
                }
                return -1;
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }

        public Builder scheme(String scheme) {
            if (null == scheme) {
                throw new NullPointerException("scheme == null");
            }
            if (scheme.equalsIgnoreCase(Protocol.HTTP.name)) {
                this.scheme = Protocol.HTTP.name;
            } else if (scheme.equalsIgnoreCase(Protocol.HTTPS.name)) {
                this.scheme = Protocol.HTTPS.name;
            } else {
                throw new IllegalArgumentException("unexpected scheme: " + scheme);
            }
            return this;
        }

        public Builder username(String username) {
            if (null == username) {
                throw new NullPointerException("username == null");
            }
            this.encodedUsername = UnoUrl.canonicalize(username, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
            return this;
        }

        public Builder encodedUsername(String encodedUsername) {
            if (null == encodedUsername) {
                throw new NullPointerException("encodedUsername == null");
            }
            this.encodedUsername = UnoUrl.canonicalize(encodedUsername, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
            return this;
        }

        public Builder password(String password) {
            if (null == password) {
                throw new NullPointerException("password == null");
            }
            this.encodedPassword = UnoUrl.canonicalize(password, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
            return this;
        }

        public Builder encodedPassword(String encodedPassword) {
            if (null == encodedPassword) {
                throw new NullPointerException("encodedPassword == null");
            }
            this.encodedPassword = UnoUrl.canonicalize(encodedPassword, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
            return this;
        }

        public Builder host(String host) {
            if (null == host) {
                throw new NullPointerException("host == null");
            }
            String encoded = Builder.canonicalizeHost(host, 0, host.length());
            if (null == encoded) {
                throw new IllegalArgumentException("unexpected host: " + host);
            }
            this.host = encoded;
            return this;
        }

        public Builder port(int port) {
            if (port <= 0 || port > 65535) {
                throw new IllegalArgumentException("unexpected port: " + port);
            }
            this.port = port;
            return this;
        }

        int effectivePort() {
            return this.port != -1 ? this.port : UnoUrl.defaultPort(this.scheme);
        }

        public Builder addPathSegment(String pathSegment) {
            if (null == pathSegment) {
                throw new NullPointerException("pathSegment == null");
            }
            this.push(pathSegment, 0, pathSegment.length(), false, false);
            return this;
        }

        public Builder addPathSegments(String pathSegments) {
            if (null == pathSegments) {
                throw new NullPointerException("pathSegments == null");
            }
            return this.addPathSegments(pathSegments, false);
        }

        public Builder addEncodedPathSegment(String encodedPathSegment) {
            if (null == encodedPathSegment) {
                throw new NullPointerException("encodedPathSegment == null");
            }
            this.push(encodedPathSegment, 0, encodedPathSegment.length(), false, true);
            return this;
        }

        public Builder addEncodedPathSegments(String encodedPathSegments) {
            if (null == encodedPathSegments) {
                throw new NullPointerException("encodedPathSegments == null");
            }
            return this.addPathSegments(encodedPathSegments, true);
        }

        private Builder addPathSegments(String pathSegments, boolean alreadyEncoded) {
            int segmentEnd;
            int offset = 0;
            do {
                boolean addTrailingSlash = (segmentEnd = org.miaixz.bus.http.Builder.delimiterOffset(pathSegments, offset, pathSegments.length(), "/\\")) < pathSegments.length();
                this.push(pathSegments, offset, segmentEnd, addTrailingSlash, alreadyEncoded);
            } while ((offset = segmentEnd + 1) <= pathSegments.length());
            return this;
        }

        public Builder setPathSegment(int index, String pathSegment) {
            if (null == pathSegment) {
                throw new NullPointerException("pathSegment == null");
            }
            String canonicalPathSegment = UnoUrl.canonicalize(pathSegment, 0, pathSegment.length(), UnoUrl.PATH_SEGMENT_ENCODE_SET, false, false, false, true, null);
            if (this.isDot(canonicalPathSegment) || this.isDotDot(canonicalPathSegment)) {
                throw new IllegalArgumentException("unexpected path segment: " + pathSegment);
            }
            this.encodedPathSegments.set(index, canonicalPathSegment);
            return this;
        }

        public Builder setEncodedPathSegment(int index, String encodedPathSegment) {
            if (null == encodedPathSegment) {
                throw new NullPointerException("encodedPathSegment == null");
            }
            String canonicalPathSegment = UnoUrl.canonicalize(encodedPathSegment, 0, encodedPathSegment.length(), UnoUrl.PATH_SEGMENT_ENCODE_SET, true, false, false, true, null);
            this.encodedPathSegments.set(index, canonicalPathSegment);
            if (this.isDot(canonicalPathSegment) || this.isDotDot(canonicalPathSegment)) {
                throw new IllegalArgumentException("unexpected path segment: " + encodedPathSegment);
            }
            return this;
        }

        public Builder removePathSegment(int index) {
            this.encodedPathSegments.remove(index);
            if (this.encodedPathSegments.isEmpty()) {
                this.encodedPathSegments.add(UnoUrl.FRAGMENT_ENCODE_SET);
            }
            return this;
        }

        public Builder encodedPath(String encodedPath) {
            if (null == encodedPath) {
                throw new NullPointerException("encodedPath == null");
            }
            if (!encodedPath.startsWith("/")) {
                throw new IllegalArgumentException("unexpected encodedPath: " + encodedPath);
            }
            this.resolvePath(encodedPath, 0, encodedPath.length());
            return this;
        }

        public Builder query(String query) {
            this.encodedQueryNamesAndValues = null != query ? UnoUrl.queryStringToNamesAndValues(UnoUrl.canonicalize(query, UnoUrl.QUERY_ENCODE_SET, false, false, true, true)) : null;
            return this;
        }

        public Builder encodedQuery(String encodedQuery) {
            this.encodedQueryNamesAndValues = null != encodedQuery ? UnoUrl.queryStringToNamesAndValues(UnoUrl.canonicalize(encodedQuery, UnoUrl.QUERY_ENCODE_SET, true, false, true, true)) : null;
            return this;
        }

        public Builder addQueryParameter(String name, String value) {
            if (null == name) {
                throw new NullPointerException("name == null");
            }
            if (null == this.encodedQueryNamesAndValues) {
                this.encodedQueryNamesAndValues = new ArrayList<String>();
            }
            this.encodedQueryNamesAndValues.add(UnoUrl.canonicalize(name, UnoUrl.QUERY_COMPONENT_ENCODE_SET, false, false, true, true));
            this.encodedQueryNamesAndValues.add(null != value ? UnoUrl.canonicalize(value, UnoUrl.QUERY_COMPONENT_ENCODE_SET, false, false, true, true) : null);
            return this;
        }

        public Builder addEncodedQueryParameter(String encodedName, String encodedValue) {
            if (null == encodedName) {
                throw new NullPointerException("encodedName == null");
            }
            if (null == this.encodedQueryNamesAndValues) {
                this.encodedQueryNamesAndValues = new ArrayList<String>();
            }
            this.encodedQueryNamesAndValues.add(UnoUrl.canonicalize(encodedName, UnoUrl.QUERY_COMPONENT_REENCODE_SET, true, false, true, true));
            this.encodedQueryNamesAndValues.add(null != encodedValue ? UnoUrl.canonicalize(encodedValue, UnoUrl.QUERY_COMPONENT_REENCODE_SET, true, false, true, true) : null);
            return this;
        }

        public Builder setQueryParameter(String name, String value) {
            this.removeAllQueryParameters(name);
            this.addQueryParameter(name, value);
            return this;
        }

        public Builder setEncodedQueryParameter(String encodedName, String encodedValue) {
            this.removeAllEncodedQueryParameters(encodedName);
            this.addEncodedQueryParameter(encodedName, encodedValue);
            return this;
        }

        public Builder removeAllQueryParameters(String name) {
            if (name == null) {
                throw new NullPointerException("name == null");
            }
            if (this.encodedQueryNamesAndValues == null) {
                return this;
            }
            String nameToRemove = UnoUrl.canonicalize(name, UnoUrl.QUERY_COMPONENT_ENCODE_SET, false, false, true, true);
            this.removeAllCanonicalQueryParameters(nameToRemove);
            return this;
        }

        public Builder removeAllEncodedQueryParameters(String encodedName) {
            if (null == encodedName) {
                throw new NullPointerException("encodedName == null");
            }
            if (null == this.encodedQueryNamesAndValues) {
                return this;
            }
            this.removeAllCanonicalQueryParameters(UnoUrl.canonicalize(encodedName, UnoUrl.QUERY_COMPONENT_REENCODE_SET, true, false, true, true));
            return this;
        }

        private void removeAllCanonicalQueryParameters(String canonicalName) {
            for (int i = this.encodedQueryNamesAndValues.size() - 2; i >= 0; i -= 2) {
                if (!canonicalName.equals(this.encodedQueryNamesAndValues.get(i))) continue;
                this.encodedQueryNamesAndValues.remove(i + 1);
                this.encodedQueryNamesAndValues.remove(i);
                if (!this.encodedQueryNamesAndValues.isEmpty()) continue;
                this.encodedQueryNamesAndValues = null;
                return;
            }
        }

        public Builder fragment(String fragment) {
            this.encodedFragment = null != fragment ? UnoUrl.canonicalize(fragment, UnoUrl.FRAGMENT_ENCODE_SET, false, false, false, false) : null;
            return this;
        }

        public Builder encodedFragment(String encodedFragment) {
            this.encodedFragment = null != encodedFragment ? UnoUrl.canonicalize(encodedFragment, UnoUrl.FRAGMENT_ENCODE_SET, true, false, false, false) : null;
            return this;
        }

        Builder reencodeForUri() {
            int i;
            int size = this.encodedPathSegments.size();
            for (i = 0; i < size; ++i) {
                String pathSegment = this.encodedPathSegments.get(i);
                this.encodedPathSegments.set(i, UnoUrl.canonicalize(pathSegment, UnoUrl.PATH_SEGMENT_ENCODE_SET_URI, true, true, false, true));
            }
            if (null != this.encodedQueryNamesAndValues) {
                size = this.encodedQueryNamesAndValues.size();
                for (i = 0; i < size; ++i) {
                    String component = this.encodedQueryNamesAndValues.get(i);
                    if (null == component) continue;
                    this.encodedQueryNamesAndValues.set(i, UnoUrl.canonicalize(component, UnoUrl.QUERY_COMPONENT_ENCODE_SET_URI, true, true, true, true));
                }
            }
            if (null != this.encodedFragment) {
                this.encodedFragment = UnoUrl.canonicalize(this.encodedFragment, UnoUrl.FRAGMENT_ENCODE_SET_URI, true, true, false, false);
            }
            return this;
        }

        public UnoUrl build() {
            if (null == this.scheme) {
                throw new IllegalStateException("scheme == null");
            }
            if (null == this.host) {
                throw new IllegalStateException("host == null");
            }
            return new UnoUrl(this);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            if (null != this.scheme) {
                result.append(this.scheme);
                result.append("://");
            } else {
                result.append("//");
            }
            if (!this.encodedUsername.isEmpty() || !this.encodedPassword.isEmpty()) {
                result.append(this.encodedUsername);
                if (!this.encodedPassword.isEmpty()) {
                    result.append(':');
                    result.append(this.encodedPassword);
                }
                result.append('@');
            }
            if (null != this.host) {
                if (this.host.indexOf(58) != -1) {
                    result.append('[');
                    result.append(this.host);
                    result.append(']');
                } else {
                    result.append(this.host);
                }
            }
            if (this.port != -1 || null != this.scheme) {
                int effectivePort = this.effectivePort();
                if (null == this.scheme || effectivePort != UnoUrl.defaultPort(this.scheme)) {
                    result.append(':');
                    result.append(effectivePort);
                }
            }
            UnoUrl.pathSegmentsToString(result, this.encodedPathSegments);
            if (null != this.encodedQueryNamesAndValues) {
                result.append('?');
                UnoUrl.namesAndValuesToQueryString(result, this.encodedQueryNamesAndValues);
            }
            if (null != this.encodedFragment) {
                result.append('#');
                result.append(this.encodedFragment);
            }
            return result.toString();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Builder parse(UnoUrl base, String input) {
            int limit;
            int pos;
            block19: {
                pos = org.miaixz.bus.http.Builder.skipLeadingAsciiWhitespace(input, 0, input.length());
                int schemeDelimiterOffset = Builder.schemeDelimiterOffset(input, pos, limit = org.miaixz.bus.http.Builder.skipTrailingAsciiWhitespace(input, pos, input.length()));
                if (schemeDelimiterOffset != -1) {
                    if (input.regionMatches(true, pos, Protocol.HTTPS.name + ":", 0, 6)) {
                        this.scheme = Protocol.HTTPS.name;
                        pos += (Protocol.HTTPS.name + ":").length();
                    } else {
                        if (!input.regionMatches(true, pos, Protocol.HTTP.name + ":", 0, 5)) throw new IllegalArgumentException("Expected URL scheme 'http' or 'https' but was '" + input.substring(0, schemeDelimiterOffset) + "'");
                        this.scheme = Protocol.HTTP.name;
                        pos += (Protocol.HTTP.name + ":").length();
                    }
                } else {
                    if (null == base) throw new IllegalArgumentException("Expected URL scheme 'http' or 'https' but no colon was found");
                    this.scheme = base.scheme;
                }
                boolean hasUsername = false;
                boolean hasPassword = false;
                int slashCount = Builder.slashCount(input, pos, limit);
                if (slashCount >= 2 || base == null || !base.scheme.equals(this.scheme)) {
                    pos += slashCount;
                    while (true) {
                        int componentDelimiterOffset;
                        int c = (componentDelimiterOffset = org.miaixz.bus.http.Builder.delimiterOffset(input, pos, limit, "@/\\?#")) != limit ? (int)input.charAt(componentDelimiterOffset) : -1;
                        switch (c) {
                            case 64: {
                                if (!hasPassword) {
                                    int passwordColonOffset = org.miaixz.bus.http.Builder.delimiterOffset(input, pos, componentDelimiterOffset, ':');
                                    String canonicalUsername = UnoUrl.canonicalize(input, pos, passwordColonOffset, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                    String string = this.encodedUsername = hasUsername ? this.encodedUsername + "%40" + canonicalUsername : canonicalUsername;
                                    if (passwordColonOffset != componentDelimiterOffset) {
                                        hasPassword = true;
                                        this.encodedPassword = UnoUrl.canonicalize(input, passwordColonOffset + 1, componentDelimiterOffset, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                    }
                                    hasUsername = true;
                                } else {
                                    this.encodedPassword = this.encodedPassword + "%40" + UnoUrl.canonicalize(input, pos, componentDelimiterOffset, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                }
                                pos = componentDelimiterOffset + 1;
                                break;
                            }
                            case -1: 
                            case 35: 
                            case 47: 
                            case 63: 
                            case 92: {
                                int portColonOffset = Builder.portColonOffset(input, pos, componentDelimiterOffset);
                                if (portColonOffset + 1 < componentDelimiterOffset) {
                                    this.host = Builder.canonicalizeHost(input, pos, portColonOffset);
                                    this.port = Builder.parsePort(input, portColonOffset + 1, componentDelimiterOffset);
                                    if (this.port == -1) {
                                        throw new IllegalArgumentException("Invalid URL port: " + input.substring(portColonOffset + 1, componentDelimiterOffset));
                                    }
                                } else {
                                    this.host = Builder.canonicalizeHost(input, pos, portColonOffset);
                                    this.port = UnoUrl.defaultPort(this.scheme);
                                }
                                if (null == this.host) {
                                    throw new IllegalArgumentException("Invalid URL host: " + input.substring(pos, portColonOffset) + "\"");
                                }
                                pos = componentDelimiterOffset;
                                break block19;
                            }
                        }
                    }
                }
                this.encodedUsername = base.encodedUsername();
                this.encodedPassword = base.encodedPassword();
                this.host = base.host;
                this.port = base.port;
                this.encodedPathSegments.clear();
                this.encodedPathSegments.addAll(base.encodedPathSegments());
                if (pos == limit || input.charAt(pos) == '#') {
                    this.encodedQuery(base.encodedQuery());
                }
            }
            int pathDelimiterOffset = org.miaixz.bus.http.Builder.delimiterOffset(input, pos, limit, "?#");
            this.resolvePath(input, pos, pathDelimiterOffset);
            pos = pathDelimiterOffset;
            if (pos < limit && input.charAt(pos) == '?') {
                int queryDelimiterOffset = org.miaixz.bus.http.Builder.delimiterOffset(input, pos, limit, '#');
                this.encodedQueryNamesAndValues = UnoUrl.queryStringToNamesAndValues(UnoUrl.canonicalize(input, pos + 1, queryDelimiterOffset, UnoUrl.QUERY_ENCODE_SET, true, false, true, true, null));
                pos = queryDelimiterOffset;
            }
            if (pos >= limit || input.charAt(pos) != '#') return this;
            this.encodedFragment = UnoUrl.canonicalize(input, pos + 1, limit, UnoUrl.FRAGMENT_ENCODE_SET, true, false, false, false, null);
            return this;
        }

        private void resolvePath(String input, int pos, int limit) {
            if (pos == limit) {
                return;
            }
            char c = input.charAt(pos);
            if (c == '/' || c == '\\') {
                this.encodedPathSegments.clear();
                this.encodedPathSegments.add(UnoUrl.FRAGMENT_ENCODE_SET);
                ++pos;
            } else {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, UnoUrl.FRAGMENT_ENCODE_SET);
            }
            int i = pos;
            while (i < limit) {
                int pathSegmentDelimiterOffset = org.miaixz.bus.http.Builder.delimiterOffset(input, i, limit, "/\\");
                boolean segmentHasTrailingSlash = pathSegmentDelimiterOffset < limit;
                this.push(input, i, pathSegmentDelimiterOffset, segmentHasTrailingSlash, true);
                i = pathSegmentDelimiterOffset;
                if (!segmentHasTrailingSlash) continue;
                ++i;
            }
        }

        private void push(String input, int pos, int limit, boolean addTrailingSlash, boolean alreadyEncoded) {
            String segment = UnoUrl.canonicalize(input, pos, limit, UnoUrl.PATH_SEGMENT_ENCODE_SET, alreadyEncoded, false, false, true, null);
            if (this.isDot(segment)) {
                return;
            }
            if (this.isDotDot(segment)) {
                this.pop();
                return;
            }
            if (this.encodedPathSegments.get(this.encodedPathSegments.size() - 1).isEmpty()) {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, segment);
            } else {
                this.encodedPathSegments.add(segment);
            }
            if (addTrailingSlash) {
                this.encodedPathSegments.add(UnoUrl.FRAGMENT_ENCODE_SET);
            }
        }

        private boolean isDot(String input) {
            return input.equals(".") || input.equalsIgnoreCase("%2e");
        }

        private boolean isDotDot(String input) {
            return input.equals("..") || input.equalsIgnoreCase("%2e.") || input.equalsIgnoreCase(".%2e") || input.equalsIgnoreCase("%2e%2e");
        }

        private void pop() {
            String removed = this.encodedPathSegments.remove(this.encodedPathSegments.size() - 1);
            if (removed.isEmpty() && !this.encodedPathSegments.isEmpty()) {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, UnoUrl.FRAGMENT_ENCODE_SET);
            } else {
                this.encodedPathSegments.add(UnoUrl.FRAGMENT_ENCODE_SET);
            }
        }
    }
}

