/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.cache;

import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.miaixz.bus.core.io.ByteString;
import org.miaixz.bus.core.io.buffer.Buffer;
import org.miaixz.bus.core.io.sink.AssignSink;
import org.miaixz.bus.core.io.sink.BufferSink;
import org.miaixz.bus.core.io.sink.Sink;
import org.miaixz.bus.core.io.source.AssignSource;
import org.miaixz.bus.core.io.source.BufferSource;
import org.miaixz.bus.core.io.source.Source;
import org.miaixz.bus.core.lang.MediaType;
import org.miaixz.bus.core.net.HTTP;
import org.miaixz.bus.core.net.Protocol;
import org.miaixz.bus.core.net.tls.TlsVersion;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.http.Headers;
import org.miaixz.bus.http.Request;
import org.miaixz.bus.http.Response;
import org.miaixz.bus.http.UnoUrl;
import org.miaixz.bus.http.accord.platform.Platform;
import org.miaixz.bus.http.bodys.ResponseBody;
import org.miaixz.bus.http.cache.CacheRequest;
import org.miaixz.bus.http.cache.CacheStrategy;
import org.miaixz.bus.http.cache.DiskLruCache;
import org.miaixz.bus.http.cache.InternalCache;
import org.miaixz.bus.http.metric.http.StatusLine;
import org.miaixz.bus.http.secure.CipherSuite;
import org.miaixz.bus.http.socket.Handshake;

public class Cache
implements Closeable,
Flushable {
    private static final int VERSION = 201105;
    private static final int ENTRY_METADATA = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;
    final DiskLruCache cache;
    int writeSuccessCount;
    int writeAbortCount;
    private int networkCount;
    private int hitCount;
    private int requestCount;
    public final InternalCache internalCache = new InternalCache(){

        @Override
        public Response get(Request request) {
            return Cache.this.get(request);
        }

        @Override
        public CacheRequest put(Response response) {
            return Cache.this.put(response);
        }

        @Override
        public void remove(Request request) throws IOException {
            Cache.this.remove(request);
        }

        @Override
        public void update(Response cached, Response network) {
            Cache.this.update(cached, network);
        }

        @Override
        public void trackConditionalCacheHit() {
            Cache.this.trackConditionalCacheHit();
        }

        @Override
        public void trackResponse(CacheStrategy cacheStrategy) {
            Cache.this.trackResponse(cacheStrategy);
        }
    };

    public Cache(File directory, long maxSize) {
        this(directory, maxSize, DiskLruCache.DiskFile.SYSTEM);
    }

    public Cache(File directory, long maxSize, DiskLruCache.DiskFile diskFile) {
        this.cache = DiskLruCache.create(diskFile, directory, 201105, 2, maxSize);
    }

    public static String key(UnoUrl url) {
        return ByteString.encodeUtf8((String)url.toString()).md5().hex();
    }

    static int readInt(BufferSource source) throws IOException {
        try {
            long result = source.readDecimalLong();
            String line = source.readUtf8LineStrict();
            if (result < 0L || result > Integer.MAX_VALUE || !line.isEmpty()) {
                throw new IOException("expected an int but was \"" + result + line + "\"");
            }
            return (int)result;
        }
        catch (NumberFormatException e) {
            throw new IOException(e.getMessage());
        }
    }

    Response get(Request request) {
        Entry entry;
        DiskLruCache.Snapshot snapshot;
        String key = Cache.key(request.url());
        try {
            snapshot = this.cache.get(key);
            if (null == snapshot) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        try {
            entry = new Entry(snapshot.getSource(0));
        }
        catch (IOException e) {
            IoKit.close((Closeable)snapshot);
            return null;
        }
        Response response = entry.response(snapshot);
        if (!entry.matches(request, response)) {
            IoKit.close((Closeable)response.body());
            return null;
        }
        return response;
    }

    CacheRequest put(Response response) {
        String requestMethod = response.request().method();
        if (HTTP.invalidatesCache((String)response.request().method())) {
            try {
                this.remove(response.request());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        if (!"GET".equals(requestMethod)) {
            return null;
        }
        if (Headers.hasVaryAll(response)) {
            return null;
        }
        Entry entry = new Entry(response);
        DiskLruCache.Editor editor = null;
        try {
            editor = this.cache.edit(Cache.key(response.request().url()));
            if (null == editor) {
                return null;
            }
            entry.writeTo(editor);
            return new CacheRequestImpl(editor);
        }
        catch (IOException e) {
            this.abortQuietly(editor);
            return null;
        }
    }

    void remove(Request request) throws IOException {
        this.cache.remove(Cache.key(request.url()));
    }

    void update(Response cached, Response network) {
        Entry entry = new Entry(network);
        DiskLruCache.Snapshot snapshot = ((CacheResponseBody)cached.body()).snapshot;
        DiskLruCache.Editor editor = null;
        try {
            editor = snapshot.edit();
            if (editor != null) {
                entry.writeTo(editor);
                editor.commit();
            }
        }
        catch (IOException e) {
            this.abortQuietly(editor);
        }
    }

    private void abortQuietly(DiskLruCache.Editor editor) {
        try {
            if (null != editor) {
                editor.abort();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void initialize() throws IOException {
        this.cache.initialize();
    }

    public void delete() throws IOException {
        this.cache.delete();
    }

    public void evictAll() throws IOException {
        this.cache.evictAll();
    }

    public Iterator<String> urls() throws IOException {
        return new Iterator<String>(){
            final Iterator<DiskLruCache.Snapshot> delegate;
            String nextUrl;
            boolean canRemove;
            {
                this.delegate = Cache.this.cache.snapshots();
            }

            @Override
            public boolean hasNext() {
                if (null != this.nextUrl) {
                    return true;
                }
                this.canRemove = false;
                while (this.delegate.hasNext()) {
                    DiskLruCache.Snapshot snapshot = this.delegate.next();
                    try {
                        BufferSource metadata = IoKit.buffer((Source)snapshot.getSource(0));
                        this.nextUrl = metadata.readUtf8LineStrict();
                        boolean bl = true;
                        if (snapshot != null) {
                            snapshot.close();
                        }
                        return bl;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (snapshot != null) {
                                try {
                                    snapshot.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                    }
                }
                return false;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String result = this.nextUrl;
                this.nextUrl = null;
                this.canRemove = true;
                return result;
            }

            @Override
            public void remove() {
                if (!this.canRemove) {
                    throw new IllegalStateException("remove() before next()");
                }
                this.delegate.remove();
            }
        };
    }

    public synchronized int writeAbortCount() {
        return this.writeAbortCount;
    }

    public synchronized int writeSuccessCount() {
        return this.writeSuccessCount;
    }

    public long size() throws IOException {
        return this.cache.size();
    }

    public long maxSize() {
        return this.cache.getMaxSize();
    }

    @Override
    public void flush() throws IOException {
        this.cache.flush();
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
    }

    public File directory() {
        return this.cache.getDirectory();
    }

    public boolean isClosed() {
        return this.cache.isClosed();
    }

    synchronized void trackResponse(CacheStrategy cacheStrategy) {
        ++this.requestCount;
        if (null != cacheStrategy.networkRequest) {
            ++this.networkCount;
        } else if (null != cacheStrategy.cacheResponse) {
            ++this.hitCount;
        }
    }

    synchronized void trackConditionalCacheHit() {
        ++this.hitCount;
    }

    public synchronized int networkCount() {
        return this.networkCount;
    }

    public synchronized int hitCount() {
        return this.hitCount;
    }

    public synchronized int requestCount() {
        return this.requestCount;
    }

    private static class Entry {
        private static final String SENT_MILLIS = Platform.get().getPrefix() + "-Sent-Millis";
        private static final String RECEIVED_MILLIS = Platform.get().getPrefix() + "-Received-Millis";
        private final String url;
        private final Headers varyHeaders;
        private final String requestMethod;
        private final Protocol protocol;
        private final int code;
        private final String message;
        private final Headers responseHeaders;
        private final Handshake handshake;
        private final long sentRequestMillis;
        private final long receivedResponseMillis;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Entry(Source in) throws IOException {
            try {
                BufferSource source = IoKit.buffer((Source)in);
                this.url = source.readUtf8LineStrict();
                this.requestMethod = source.readUtf8LineStrict();
                Headers.Builder varyHeadersBuilder = new Headers.Builder();
                int varyRequestHeaderLineCount = Cache.readInt(source);
                for (int i = 0; i < varyRequestHeaderLineCount; ++i) {
                    varyHeadersBuilder.addLenient(source.readUtf8LineStrict());
                }
                this.varyHeaders = varyHeadersBuilder.build();
                StatusLine statusLine = StatusLine.parse(source.readUtf8LineStrict());
                this.protocol = statusLine.protocol;
                this.code = statusLine.code;
                this.message = statusLine.message;
                Headers.Builder responseHeadersBuilder = new Headers.Builder();
                int responseHeaderLineCount = Cache.readInt(source);
                for (int i = 0; i < responseHeaderLineCount; ++i) {
                    responseHeadersBuilder.addLenient(source.readUtf8LineStrict());
                }
                String sendRequestMillisString = responseHeadersBuilder.get(SENT_MILLIS);
                String receivedResponseMillisString = responseHeadersBuilder.get(RECEIVED_MILLIS);
                responseHeadersBuilder.removeAll(SENT_MILLIS);
                responseHeadersBuilder.removeAll(RECEIVED_MILLIS);
                this.sentRequestMillis = null != sendRequestMillisString ? Long.parseLong(sendRequestMillisString) : 0L;
                this.receivedResponseMillis = null != receivedResponseMillisString ? Long.parseLong(receivedResponseMillisString) : 0L;
                this.responseHeaders = responseHeadersBuilder.build();
                if (this.isHttps()) {
                    String blank = source.readUtf8LineStrict();
                    if (blank.length() > 0) {
                        throw new IOException("expected \"\" but was \"" + blank + "\"");
                    }
                    String cipherSuiteString = source.readUtf8LineStrict();
                    CipherSuite cipherSuite = CipherSuite.forJavaName(cipherSuiteString);
                    List<Certificate> peerCertificates = this.readCertificateList(source);
                    List<Certificate> localCertificates = this.readCertificateList(source);
                    TlsVersion tlsVersion = !source.exhausted() ? TlsVersion.forJavaName((String)source.readUtf8LineStrict()) : TlsVersion.SSLv3;
                    this.handshake = Handshake.get(tlsVersion, cipherSuite, peerCertificates, localCertificates);
                } else {
                    this.handshake = null;
                }
            }
            finally {
                in.close();
            }
        }

        Entry(Response response) {
            this.url = response.request().url().toString();
            this.varyHeaders = Headers.varyHeaders(response);
            this.requestMethod = response.request().method();
            this.protocol = response.protocol();
            this.code = response.code();
            this.message = response.message();
            this.responseHeaders = response.headers();
            this.handshake = response.handshake();
            this.sentRequestMillis = response.sentRequestAtMillis();
            this.receivedResponseMillis = response.receivedResponseAtMillis();
        }

        public void writeTo(DiskLruCache.Editor editor) throws IOException {
            int i;
            BufferSink sink = IoKit.buffer((Sink)editor.newSink(0));
            sink.writeUtf8(this.url).writeByte(10);
            sink.writeUtf8(this.requestMethod).writeByte(10);
            sink.writeDecimalLong((long)this.varyHeaders.size()).writeByte(10);
            int size = this.varyHeaders.size();
            for (i = 0; i < size; ++i) {
                sink.writeUtf8(this.varyHeaders.name(i)).writeUtf8(": ").writeUtf8(this.varyHeaders.value(i)).writeByte(10);
            }
            sink.writeUtf8(new StatusLine(this.protocol, this.code, this.message).toString()).writeByte(10);
            sink.writeDecimalLong((long)(this.responseHeaders.size() + 2)).writeByte(10);
            size = this.responseHeaders.size();
            for (i = 0; i < size; ++i) {
                sink.writeUtf8(this.responseHeaders.name(i)).writeUtf8(": ").writeUtf8(this.responseHeaders.value(i)).writeByte(10);
            }
            sink.writeUtf8(SENT_MILLIS).writeUtf8(": ").writeDecimalLong(this.sentRequestMillis).writeByte(10);
            sink.writeUtf8(RECEIVED_MILLIS).writeUtf8(": ").writeDecimalLong(this.receivedResponseMillis).writeByte(10);
            if (this.isHttps()) {
                sink.writeByte(10);
                sink.writeUtf8(this.handshake.cipherSuite().javaName()).writeByte(10);
                this.writeCertList(sink, this.handshake.peerCertificates());
                this.writeCertList(sink, this.handshake.localCertificates());
                sink.writeUtf8(this.handshake.tlsVersion().javaName()).writeByte(10);
            }
            sink.close();
        }

        private boolean isHttps() {
            return this.url.startsWith(Protocol.HTTPS_PREFIX);
        }

        private List<Certificate> readCertificateList(BufferSource source) throws IOException {
            int length = Cache.readInt(source);
            if (length == -1) {
                return Collections.emptyList();
            }
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ArrayList<Certificate> result = new ArrayList<Certificate>(length);
                for (int i = 0; i < length; ++i) {
                    String line = source.readUtf8LineStrict();
                    Buffer bytes = new Buffer();
                    bytes.write(ByteString.decodeBase64((String)line));
                    result.add(certificateFactory.generateCertificate(bytes.inputStream()));
                }
                return result;
            }
            catch (CertificateException e) {
                throw new IOException(e.getMessage());
            }
        }

        private void writeCertList(BufferSink sink, List<Certificate> certificates) throws IOException {
            try {
                sink.writeDecimalLong((long)certificates.size()).writeByte(10);
                int size = certificates.size();
                for (int i = 0; i < size; ++i) {
                    byte[] bytes = certificates.get(i).getEncoded();
                    String line = ByteString.of((byte[])bytes).base64();
                    sink.writeUtf8(line).writeByte(10);
                }
            }
            catch (CertificateEncodingException e) {
                throw new IOException(e.getMessage());
            }
        }

        public boolean matches(Request request, Response response) {
            return this.url.equals(request.url().toString()) && this.requestMethod.equals(request.method()) && Headers.varyMatches(response, this.varyHeaders, request);
        }

        public Response response(DiskLruCache.Snapshot snapshot) {
            String mediaType = this.responseHeaders.get("Content-Type");
            String length = this.responseHeaders.get("Content-Length");
            Request request = new Request.Builder().url(this.url).method(this.requestMethod, null).headers(this.varyHeaders).build();
            return new Response.Builder().request(request).protocol(this.protocol).code(this.code).message(this.message).headers(this.responseHeaders).body(new CacheResponseBody(snapshot, mediaType, length)).handshake(this.handshake).sentRequestAtMillis(this.sentRequestMillis).receivedResponseAtMillis(this.receivedResponseMillis).build();
        }
    }

    private class CacheRequestImpl
    implements CacheRequest {
        private final DiskLruCache.Editor editor;
        boolean done;
        private Sink cacheOut;
        private Sink body;

        CacheRequestImpl(final DiskLruCache.Editor editor) {
            this.editor = editor;
            this.cacheOut = editor.newSink(1);
            this.body = new AssignSink(this.cacheOut){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() throws IOException {
                    Cache cache = Cache.this;
                    synchronized (cache) {
                        if (CacheRequestImpl.this.done) {
                            return;
                        }
                        CacheRequestImpl.this.done = true;
                        ++Cache.this.writeSuccessCount;
                    }
                    super.close();
                    editor.commit();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abort() {
            Cache cache = Cache.this;
            synchronized (cache) {
                if (this.done) {
                    return;
                }
                this.done = true;
                ++Cache.this.writeAbortCount;
            }
            IoKit.close((Closeable)this.cacheOut);
            try {
                this.editor.abort();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public Sink body() {
            return this.body;
        }
    }

    private static class CacheResponseBody
    extends ResponseBody {
        final DiskLruCache.Snapshot snapshot;
        private final BufferSource bodySource;
        private final String mediaType;
        private final String length;

        CacheResponseBody(final DiskLruCache.Snapshot snapshot, String mediaType, String length) {
            this.snapshot = snapshot;
            this.mediaType = mediaType;
            this.length = length;
            Source source = snapshot.getSource(1);
            this.bodySource = IoKit.buffer((Source)new AssignSource(this, source){

                public void close() throws IOException {
                    snapshot.close();
                    super.close();
                }
            });
        }

        @Override
        public MediaType mediaType() {
            return null != this.mediaType ? MediaType.valueOf((String)this.mediaType) : null;
        }

        @Override
        public long length() {
            try {
                return null != this.length ? Long.parseLong(this.length) : -1L;
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }

        @Override
        public BufferSource source() {
            return this.bodySource;
        }
    }
}

