/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.plugin.httpv;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.http.Callback;
import org.miaixz.bus.http.plugin.httpv.Convertor;
import org.miaixz.bus.http.plugin.httpv.CoverHttp;
import org.miaixz.bus.http.plugin.httpv.CoverResult;
import org.miaixz.bus.http.plugin.httpv.Downloads;

public class CoverTasks {

    public static class Executor {
        private java.util.concurrent.Executor ioExecutor;
        private java.util.concurrent.Executor mainExecutor;
        private Downloads.Listener downloadListener;
        private Listener<CoverResult> responseListener;
        private Listener<IOException> exceptionListener;
        private Listener<CoverResult.State> completeListener;
        private Convertor[] convertors;

        public Executor(java.util.concurrent.Executor ioExecutor, java.util.concurrent.Executor mainExecutor, Downloads.Listener downloadListener, Listener<CoverResult> responseListener, Listener<IOException> exceptionListener, Listener<CoverResult.State> completeListener, Convertor[] convertors) {
            this.ioExecutor = ioExecutor;
            this.mainExecutor = mainExecutor;
            this.downloadListener = downloadListener;
            this.responseListener = responseListener;
            this.exceptionListener = exceptionListener;
            this.completeListener = completeListener;
            this.convertors = convertors;
        }

        public java.util.concurrent.Executor getExecutor(boolean onIo) {
            if (onIo || null == this.mainExecutor) {
                return this.ioExecutor;
            }
            return this.mainExecutor;
        }

        public Downloads download(CoverHttp<?> coverHttp, File file, InputStream input, long skipBytes) {
            Downloads downloads = new Downloads(file, input, this, skipBytes);
            if (null != coverHttp && null != this.downloadListener) {
                this.downloadListener.listen(coverHttp, downloads);
            }
            return downloads;
        }

        public void execute(Runnable command, boolean onIo) {
            java.util.concurrent.Executor executor = this.ioExecutor;
            if (null != this.mainExecutor && !onIo) {
                executor = this.mainExecutor;
            }
            executor.execute(command);
        }

        public void executeOnResponse(CoverHttp<?> task, Callback<CoverResult> onResponse, CoverResult result, boolean onIo) {
            if (null != this.responseListener) {
                if (this.responseListener.listen(task, result) && null != onResponse) {
                    this.execute(() -> onResponse.on(result), onIo);
                }
            } else if (null != onResponse) {
                this.execute(() -> onResponse.on(result), onIo);
            }
        }

        public boolean executeOnException(CoverHttp<?> task, Callback<IOException> onException, IOException error, boolean onIo) {
            if (null != this.exceptionListener) {
                if (this.exceptionListener.listen(task, error) && null != onException) {
                    this.execute(() -> onException.on(error), onIo);
                }
            } else if (null != onException) {
                this.execute(() -> onException.on(error), onIo);
            } else {
                return false;
            }
            return true;
        }

        public void executeOnComplete(CoverHttp<?> task, Callback<CoverResult.State> onComplete, CoverResult.State state, boolean onIo) {
            if (null != this.completeListener) {
                if (this.completeListener.listen(task, state) && null != onComplete) {
                    this.execute(() -> onComplete.on(state), onIo);
                }
            } else if (null != onComplete) {
                this.execute(() -> onComplete.on(state), onIo);
            }
        }

        public <V> V doMsgConvert(ConvertFunc<V> callable) {
            return (V)this.doMsgConvert(null, callable).data;
        }

        public <V> Data<V> doMsgConvert(String type, ConvertFunc<V> callable) {
            Exception cause = null;
            for (int i = this.convertors.length - 1; i >= 0; --i) {
                Convertor convertor = this.convertors[i];
                String mediaType = convertor.mediaType();
                if (null != type && (null == mediaType || !mediaType.contains(type))) continue;
                if (null == callable && null != mediaType) {
                    return new Data<Object>(null, mediaType);
                }
                try {
                    assert (null != callable);
                    return new Data<V>(callable.apply(convertor), mediaType);
                }
                catch (Exception e) {
                    if (null != cause) {
                        this.initRootCause(e, cause);
                    }
                    cause = e;
                }
            }
            if (null == callable) {
                return new Data<Object>(null, this.toMediaType(type));
            }
            if (null != cause) {
                throw new InternalException("Conversion failed", cause);
            }
            throw new InternalException("No match[" + type + "]Type converter\uff01");
        }

        private String toMediaType(String type) {
            if (type != null) {
                String lower = type.toLowerCase();
                if (lower.contains("json")) {
                    return "application/json";
                }
                if (lower.contains("xml")) {
                    return "application/xml";
                }
                if (lower.contains("protobuf")) {
                    return "application/x-protobuf";
                }
            }
            return "application/x-www-form-urlencoded";
        }

        private void initRootCause(Throwable throwable, Throwable cause) {
            Throwable lastCause = throwable.getCause();
            if (null != lastCause) {
                this.initRootCause(lastCause, cause);
            } else {
                throwable.initCause(cause);
            }
        }

        public void shutdown() {
            if (null != this.ioExecutor && this.ioExecutor instanceof ExecutorService) {
                ((ExecutorService)this.ioExecutor).shutdown();
            }
            if (null != this.mainExecutor && this.mainExecutor instanceof ExecutorService) {
                ((ExecutorService)this.mainExecutor).shutdown();
            }
        }

        public java.util.concurrent.Executor getIoExecutor() {
            return this.ioExecutor;
        }

        public java.util.concurrent.Executor getMainExecutor() {
            return this.mainExecutor;
        }

        public Downloads.Listener getDownloadListener() {
            return this.downloadListener;
        }

        public Listener<CoverResult> getResponseListener() {
            return this.responseListener;
        }

        public Listener<IOException> getExceptionListener() {
            return this.exceptionListener;
        }

        public Listener<CoverResult.State> getCompleteListener() {
            return this.completeListener;
        }

        public Convertor[] getConvertors() {
            return this.convertors;
        }

        public static interface ConvertFunc<T> {
            public T apply(Convertor var1);
        }

        public static class Data<T> {
            public T data;
            public String mediaType;

            public Data(T data, String mediaType) {
                this.data = data;
                this.mediaType = mediaType;
            }
        }
    }

    public static interface Listener<T> {
        public boolean listen(CoverHttp<?> var1, T var2);
    }
}

