/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.metric.http;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.miaixz.bus.core.io.ByteString;
import org.miaixz.bus.core.io.buffer.Buffer;
import org.miaixz.bus.core.io.source.BufferSource;
import org.miaixz.bus.core.io.source.Source;
import org.miaixz.bus.core.io.timout.Timeout;
import org.miaixz.bus.http.metric.http.Hpack;
import org.miaixz.bus.http.metric.http.Http2;
import org.miaixz.bus.http.metric.http.Http2ErrorCode;
import org.miaixz.bus.http.metric.http.Http2Header;
import org.miaixz.bus.http.metric.http.Http2Settings;
import org.miaixz.bus.logger.Logger;

public class Http2Reader
implements Closeable {
    public final Hpack.Reader hpackReader;
    public final BufferSource source;
    public final ContinuationSource continuation;
    public final boolean client;

    Http2Reader(BufferSource source, boolean client) {
        this.source = source;
        this.client = client;
        this.continuation = new ContinuationSource(this.source);
        this.hpackReader = new Hpack.Reader(4096, this.continuation);
    }

    static int readMedium(BufferSource source) throws IOException {
        return (source.readByte() & 0xFF) << 16 | (source.readByte() & 0xFF) << 8 | source.readByte() & 0xFF;
    }

    static int lengthWithoutPadding(int length, byte flags, short padding) throws IOException {
        if ((flags & 8) != 0) {
            --length;
        }
        if (padding > length) {
            throw Http2.ioException("PROTOCOL_ERROR padding %s > remaining length %s", padding, length);
        }
        return (short)(length - padding);
    }

    public void readConnectionPreface(Handler handler) throws IOException {
        if (this.client) {
            if (!this.nextFrame(true, handler)) {
                throw Http2.ioException("Required SETTINGS preface not received", new Object[0]);
            }
        } else {
            ByteString connectionPreface = this.source.readByteString((long)Http2.CONNECTION_PREFACE.size());
            if (Logger.isDebugEnabled()) {
                Logger.debug((String)String.format("<< CONNECTION %s" + connectionPreface.hex(), new Object[0]), (Object[])new Object[0]);
            }
            if (!Http2.CONNECTION_PREFACE.equals((Object)connectionPreface)) {
                throw Http2.ioException("Expected a connection header but was %s", connectionPreface.utf8());
            }
        }
    }

    public boolean nextFrame(boolean requireSettings, Handler handler) throws IOException {
        try {
            this.source.require(9L);
        }
        catch (IOException e) {
            return false;
        }
        int length = Http2Reader.readMedium(this.source);
        if (length < 0 || length > 16384) {
            throw Http2.ioException("FRAME_SIZE_ERROR: %s", length);
        }
        byte type = (byte)(this.source.readByte() & 0xFF);
        if (requireSettings && type != 4) {
            throw Http2.ioException("Expected a SETTINGS frame but was %s", type);
        }
        byte flags = (byte)(this.source.readByte() & 0xFF);
        int streamId = this.source.readInt() & Integer.MAX_VALUE;
        if (Logger.isDebugEnabled()) {
            Logger.warn((String)Http2.frameLog(true, streamId, length, type, flags), (Object[])new Object[0]);
        }
        switch (type) {
            case 0: {
                this.readData(handler, length, flags, streamId);
                break;
            }
            case 1: {
                this.readHeaders(handler, length, flags, streamId);
                break;
            }
            case 2: {
                this.readPriority(handler, length, flags, streamId);
                break;
            }
            case 3: {
                this.readRstStream(handler, length, flags, streamId);
                break;
            }
            case 4: {
                this.readSettings(handler, length, flags, streamId);
                break;
            }
            case 5: {
                this.readPushPromise(handler, length, flags, streamId);
                break;
            }
            case 6: {
                this.readPing(handler, length, flags, streamId);
                break;
            }
            case 7: {
                this.readGoAway(handler, length, flags, streamId);
                break;
            }
            case 8: {
                this.readWindowUpdate(handler, length, flags, streamId);
                break;
            }
            default: {
                this.source.skip((long)length);
            }
        }
        return true;
    }

    private void readHeaders(Handler handler, int length, byte flags, int streamId) throws IOException {
        short padding;
        if (streamId == 0) {
            throw Http2.ioException("PROTOCOL_ERROR: TYPE_HEADERS streamId == 0", new Object[0]);
        }
        boolean endStream = (flags & 1) != 0;
        short s = padding = (flags & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
        if ((flags & 0x20) != 0) {
            this.readPriority(handler, streamId);
            length -= 5;
        }
        length = Http2Reader.lengthWithoutPadding(length, flags, padding);
        List<Http2Header> headerBlock = this.readHeaderBlock(length, padding, flags, streamId);
        handler.headers(endStream, streamId, -1, headerBlock);
    }

    private List<Http2Header> readHeaderBlock(int length, short padding, byte flags, int streamId) throws IOException {
        this.continuation.length = this.continuation.left = length;
        this.continuation.padding = padding;
        this.continuation.flags = flags;
        this.continuation.streamId = streamId;
        this.hpackReader.readHeaders();
        return this.hpackReader.getAndResetHeaderList();
    }

    private void readData(Handler handler, int length, byte flags, int streamId) throws IOException {
        boolean gzipped;
        if (streamId == 0) {
            throw Http2.ioException("PROTOCOL_ERROR: TYPE_DATA streamId == 0", new Object[0]);
        }
        boolean inFinished = (flags & 1) != 0;
        boolean bl = gzipped = (flags & 0x20) != 0;
        if (gzipped) {
            throw Http2.ioException("PROTOCOL_ERROR: FLAG_COMPRESSED without SETTINGS_COMPRESS_DATA", new Object[0]);
        }
        short padding = (flags & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
        length = Http2Reader.lengthWithoutPadding(length, flags, padding);
        handler.data(inFinished, streamId, this.source, length);
        this.source.skip((long)padding);
    }

    private void readPriority(Handler handler, int length, byte flags, int streamId) throws IOException {
        if (length != 5) {
            throw Http2.ioException("TYPE_PRIORITY length: %d != 5", length);
        }
        if (streamId == 0) {
            throw Http2.ioException("TYPE_PRIORITY streamId == 0", new Object[0]);
        }
        this.readPriority(handler, streamId);
    }

    private void readPriority(Handler handler, int streamId) throws IOException {
        int w1 = this.source.readInt();
        boolean exclusive = (w1 & Integer.MIN_VALUE) != 0;
        int streamDependency = w1 & Integer.MAX_VALUE;
        int weight = (this.source.readByte() & 0xFF) + 1;
        handler.priority(streamId, streamDependency, weight, exclusive);
    }

    private void readRstStream(Handler handler, int length, byte flags, int streamId) throws IOException {
        if (length != 4) {
            throw Http2.ioException("TYPE_RST_STREAM length: %d != 4", length);
        }
        if (streamId == 0) {
            throw Http2.ioException("TYPE_RST_STREAM streamId == 0", new Object[0]);
        }
        int errorCodeInt = this.source.readInt();
        Http2ErrorCode errorCode = Http2ErrorCode.fromHttp2(errorCodeInt);
        if (null == errorCode) {
            throw Http2.ioException("TYPE_RST_STREAM unexpected error code: %d", errorCodeInt);
        }
        handler.rstStream(streamId, errorCode);
    }

    private void readSettings(Handler handler, int length, byte flags, int streamId) throws IOException {
        if (streamId != 0) {
            throw Http2.ioException("TYPE_SETTINGS streamId != 0", new Object[0]);
        }
        if ((flags & 1) != 0) {
            if (length != 0) {
                throw Http2.ioException("FRAME_SIZE_ERROR ack frame should be empty!", new Object[0]);
            }
            handler.ackSettings();
            return;
        }
        if (length % 6 != 0) {
            throw Http2.ioException("TYPE_SETTINGS length %% 6 != 0: %s", length);
        }
        Http2Settings settings = new Http2Settings();
        for (int i = 0; i < length; i += 6) {
            int id = this.source.readShort() & 0xFFFF;
            int value = this.source.readInt();
            switch (id) {
                case 1: {
                    break;
                }
                case 2: {
                    if (value == 0 || value == 1) break;
                    throw Http2.ioException("PROTOCOL_ERROR SETTINGS_ENABLE_PUSH != 0 or 1", new Object[0]);
                }
                case 3: {
                    id = 4;
                    break;
                }
                case 4: {
                    id = 7;
                    if (value >= 0) break;
                    throw Http2.ioException("PROTOCOL_ERROR SETTINGS_INITIAL_WINDOW_SIZE > 2^31 - 1", new Object[0]);
                }
                case 5: {
                    if (value >= 16384 && value <= 0xFFFFFF) break;
                    throw Http2.ioException("PROTOCOL_ERROR SETTINGS_MAX_FRAME_SIZE: %s", value);
                }
                case 6: {
                    break;
                }
            }
            settings.set(id, value);
        }
        handler.settings(false, settings);
    }

    private void readPushPromise(Handler handler, int length, byte flags, int streamId) throws IOException {
        if (streamId == 0) {
            throw Http2.ioException("PROTOCOL_ERROR: TYPE_PUSH_PROMISE streamId == 0", new Object[0]);
        }
        short padding = (flags & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
        int promisedStreamId = this.source.readInt() & Integer.MAX_VALUE;
        length -= 4;
        length = Http2Reader.lengthWithoutPadding(length, flags, padding);
        List<Http2Header> headerBlock = this.readHeaderBlock(length, padding, flags, streamId);
        handler.pushPromise(streamId, promisedStreamId, headerBlock);
    }

    private void readPing(Handler handler, int length, byte flags, int streamId) throws IOException {
        if (length != 8) {
            throw Http2.ioException("TYPE_PING length != 8: %s", length);
        }
        if (streamId != 0) {
            throw Http2.ioException("TYPE_PING streamId != 0", new Object[0]);
        }
        int payload1 = this.source.readInt();
        int payload2 = this.source.readInt();
        boolean ack = (flags & 1) != 0;
        handler.ping(ack, payload1, payload2);
    }

    private void readGoAway(Handler handler, int length, byte flags, int streamId) throws IOException {
        if (length < 8) {
            throw Http2.ioException("TYPE_GOAWAY length < 8: %s", length);
        }
        if (streamId != 0) {
            throw Http2.ioException("TYPE_GOAWAY streamId != 0", new Object[0]);
        }
        int lastStreamId = this.source.readInt();
        int errorCodeInt = this.source.readInt();
        int opaqueDataLength = length - 8;
        Http2ErrorCode errorCode = Http2ErrorCode.fromHttp2(errorCodeInt);
        if (null == errorCode) {
            throw Http2.ioException("TYPE_GOAWAY unexpected error code: %d", errorCodeInt);
        }
        ByteString debugData = ByteString.EMPTY;
        if (opaqueDataLength > 0) {
            debugData = this.source.readByteString((long)opaqueDataLength);
        }
        handler.goAway(lastStreamId, errorCode, debugData);
    }

    private void readWindowUpdate(Handler handler, int length, byte flags, int streamId) throws IOException {
        if (length != 4) {
            throw Http2.ioException("TYPE_WINDOW_UPDATE length !=4: %s", length);
        }
        long increment = (long)this.source.readInt() & Integer.MAX_VALUE;
        if (increment == 0L) {
            throw Http2.ioException("windowSizeIncrement was 0", increment);
        }
        handler.windowUpdate(streamId, increment);
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    static class ContinuationSource
    implements Source {
        private final BufferSource source;
        int length;
        byte flags;
        int streamId;
        int left;
        short padding;

        ContinuationSource(BufferSource source) {
            this.source = source;
        }

        public long read(Buffer sink, long byteCount) throws IOException {
            while (this.left == 0) {
                this.source.skip((long)this.padding);
                this.padding = 0;
                if ((this.flags & 4) != 0) {
                    return -1L;
                }
                this.readContinuationHeader();
            }
            long read = this.source.read(sink, Math.min(byteCount, (long)this.left));
            if (read == -1L) {
                return -1L;
            }
            this.left = (int)((long)this.left - read);
            return read;
        }

        public Timeout timeout() {
            return this.source.timeout();
        }

        public void close() {
        }

        private void readContinuationHeader() throws IOException {
            int previousStreamId = this.streamId;
            this.length = this.left = Http2Reader.readMedium(this.source);
            byte type = (byte)(this.source.readByte() & 0xFF);
            this.flags = (byte)(this.source.readByte() & 0xFF);
            if (Logger.isDebugEnabled()) {
                Logger.warn((String)Http2.frameLog(true, this.streamId, this.length, type, this.flags), (Object[])new Object[0]);
            }
            this.streamId = this.source.readInt() & Integer.MAX_VALUE;
            if (type != 9) {
                throw Http2.ioException("%s != TYPE_CONTINUATION", type);
            }
            if (this.streamId != previousStreamId) {
                throw Http2.ioException("TYPE_CONTINUATION streamId changed", new Object[0]);
            }
        }
    }

    static interface Handler {
        public void data(boolean var1, int var2, BufferSource var3, int var4) throws IOException;

        public void headers(boolean var1, int var2, int var3, List<Http2Header> var4);

        public void rstStream(int var1, Http2ErrorCode var2);

        public void settings(boolean var1, Http2Settings var2);

        public void ackSettings();

        public void ping(boolean var1, int var2, int var3);

        public void goAway(int var1, Http2ErrorCode var2, ByteString var3);

        public void windowUpdate(int var1, long var2);

        public void priority(int var1, int var2, int var3, boolean var4);

        public void pushPromise(int var1, int var2, List<Http2Header> var3) throws IOException;

        public void alternateService(int var1, String var2, ByteString var3, String var4, int var5, long var6);
    }
}

