/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.miaixz.bus.core.io.timout.Timeout;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.http.Callback;
import org.miaixz.bus.http.Httpd;
import org.miaixz.bus.http.NewCall;
import org.miaixz.bus.http.Request;
import org.miaixz.bus.http.Response;
import org.miaixz.bus.http.accord.ConnectInterceptor;
import org.miaixz.bus.http.accord.Transmitter;
import org.miaixz.bus.http.cache.CacheInterceptor;
import org.miaixz.bus.http.metric.Interceptor;
import org.miaixz.bus.http.metric.NamedRunnable;
import org.miaixz.bus.http.metric.http.BridgeInterceptor;
import org.miaixz.bus.http.metric.http.CallServerInterceptor;
import org.miaixz.bus.http.metric.http.RealInterceptorChain;
import org.miaixz.bus.http.metric.http.RetryAndFollowUp;
import org.miaixz.bus.logger.Logger;

public class RealCall
implements NewCall {
    public final Httpd client;
    public final Request originalRequest;
    public final boolean forWebSocket;
    public Transmitter transmitter;
    public boolean executed;
    private boolean timeoutEarlyExit;

    private RealCall(Httpd client, Request originalRequest, boolean forWebSocket) {
        this.client = client;
        this.originalRequest = originalRequest;
        this.forWebSocket = forWebSocket;
        this.timeoutEarlyExit = false;
    }

    static RealCall newRealCall(Httpd client, Request originalRequest, boolean forWebSocket) {
        RealCall call = new RealCall(client, originalRequest, forWebSocket);
        call.transmitter = new Transmitter(client, call);
        return call;
    }

    @Override
    public Request request() {
        return this.originalRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response execute() throws IOException {
        Object object = this;
        synchronized (object) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        this.transmitter.timeoutEnter();
        this.transmitter.callStart();
        try {
            this.client.dispatcher().executed(this);
            object = this.getResponseWithInterceptorChain();
            return object;
        }
        finally {
            this.client.dispatcher().finished(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(Callback responseCallback) {
        RealCall realCall = this;
        synchronized (realCall) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        this.transmitter.callStart();
        this.client.dispatcher().enqueue(new AsyncCall(responseCallback));
    }

    @Override
    public void cancel() {
        this.transmitter.cancel();
    }

    @Override
    public Timeout timeout() {
        return this.transmitter.timeout();
    }

    public void timeoutEarlyExit() {
        this.timeoutEarlyExit = true;
    }

    @Override
    public synchronized boolean isExecuted() {
        return this.executed;
    }

    @Override
    public boolean isCanceled() {
        return this.transmitter.isCanceled();
    }

    @Override
    public RealCall clone() {
        return RealCall.newRealCall(this.client, this.originalRequest, this.forWebSocket);
    }

    public String toLoggableString() {
        return (this.isCanceled() ? "canceled " : "") + (this.forWebSocket ? "web socket" : "call") + " to " + this.redactedUrl();
    }

    public String redactedUrl() {
        return this.originalRequest.url().redact();
    }

    public Response getResponseWithInterceptorChain() throws IOException {
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        interceptors.addAll(this.client.interceptors());
        interceptors.add(new RetryAndFollowUp(this.client));
        interceptors.add(new BridgeInterceptor(this.client.cookieJar()));
        interceptors.add(new CacheInterceptor(this.client.internalCache()));
        interceptors.add(new ConnectInterceptor(this.client));
        if (!this.forWebSocket) {
            interceptors.addAll(this.client.networkInterceptors());
        }
        interceptors.add(new CallServerInterceptor(this.forWebSocket));
        RealInterceptorChain chain = new RealInterceptorChain(interceptors, this.transmitter, null, 0, this.originalRequest, this, this.client.connectTimeoutMillis(), this.client.readTimeoutMillis(), this.client.writeTimeoutMillis());
        boolean calledNoMoreExchanges = false;
        try {
            Response response = chain.proceed(this.originalRequest);
            if (this.transmitter.isCanceled()) {
                IoKit.close((Closeable)response);
                throw new IOException("Canceled");
            }
            Response response2 = response;
            return response2;
        }
        catch (IOException e) {
            calledNoMoreExchanges = true;
            throw this.transmitter.noMoreExchanges(e);
        }
        finally {
            if (!calledNoMoreExchanges) {
                this.transmitter.noMoreExchanges(null);
            }
        }
    }

    public class AsyncCall
    extends NamedRunnable {
        private final Callback responseCallback;
        private volatile AtomicInteger callsPerHost;

        AsyncCall(Callback responseCallback) {
            super("Http %s", RealCall.this.redactedUrl());
            this.callsPerHost = new AtomicInteger(0);
            this.responseCallback = responseCallback;
        }

        public AtomicInteger callsPerHost() {
            return this.callsPerHost;
        }

        public void reuseCallsPerHostFrom(AsyncCall other) {
            this.callsPerHost = other.callsPerHost;
        }

        public String host() {
            return RealCall.this.originalRequest.url().host();
        }

        Request request() {
            return RealCall.this.originalRequest;
        }

        public RealCall get() {
            return RealCall.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeOn(ExecutorService executorService) {
            assert (!Thread.holdsLock(RealCall.this.client.dispatcher()));
            boolean success = false;
            try {
                executorService.execute(this);
                success = true;
            }
            catch (RejectedExecutionException e) {
                InterruptedIOException ioException = new InterruptedIOException("executor rejected");
                ioException.initCause(e);
                RealCall.this.transmitter.noMoreExchanges(ioException);
                this.responseCallback.onFailure(RealCall.this, ioException);
            }
            finally {
                if (!success) {
                    RealCall.this.client.dispatcher().finished(RealCall.this);
                }
            }
        }

        @Override
        protected void execute() {
            boolean signalledCallback = false;
            RealCall.this.transmitter.timeoutEnter();
            try {
                Response response = RealCall.this.getResponseWithInterceptorChain();
                signalledCallback = true;
                this.responseCallback.onResponse(RealCall.this, response);
            }
            catch (IOException e) {
                if (signalledCallback) {
                    Logger.info((String)("Callback failure for " + RealCall.this.toLoggableString()), (Object[])new Object[]{e});
                } else {
                    this.responseCallback.onFailure(RealCall.this, e);
                }
            }
            catch (Throwable t) {
                RealCall.this.cancel();
                if (!signalledCallback) {
                    IOException canceledException = new IOException("canceled due to " + String.valueOf(t));
                    canceledException.addSuppressed(t);
                    this.responseCallback.onFailure(RealCall.this, canceledException);
                }
                throw t;
            }
            finally {
                RealCall.this.client.dispatcher().finished(RealCall.this);
            }
        }
    }
}

