/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.bodys;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.miaixz.bus.core.io.ByteString;
import org.miaixz.bus.core.io.sink.BufferSink;
import org.miaixz.bus.core.io.source.Source;
import org.miaixz.bus.core.lang.MediaType;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.http.Builder;

public abstract class RequestBody {
    public static RequestBody create(MediaType contentType, String content) {
        Charset charset = org.miaixz.bus.core.lang.Charset.UTF_8;
        if (contentType != null && (charset = contentType.charset()) == null) {
            charset = org.miaixz.bus.core.lang.Charset.UTF_8;
            contentType = MediaType.valueOf((String)(String.valueOf(contentType) + "; charset=utf-8"));
        }
        byte[] bytes = content.getBytes(charset);
        return RequestBody.create(contentType, bytes);
    }

    public static RequestBody create(final MediaType contentType, final ByteString content) {
        return new RequestBody(){

            @Override
            public MediaType contentType() {
                return contentType;
            }

            @Override
            public long length() {
                return content.size();
            }

            @Override
            public void writeTo(BufferSink sink) throws IOException {
                sink.write(content);
            }
        };
    }

    public static RequestBody create(MediaType contentType, byte[] content) {
        return RequestBody.create(contentType, content, 0, content.length);
    }

    public static RequestBody create(final MediaType contentType, final byte[] content, final int offset, final int byteCount) {
        if (null == content) {
            throw new NullPointerException("content == null");
        }
        Builder.checkOffsetAndCount(content.length, offset, byteCount);
        return new RequestBody(){

            @Override
            public MediaType contentType() {
                return contentType;
            }

            @Override
            public long length() {
                return byteCount;
            }

            @Override
            public void writeTo(BufferSink sink) throws IOException {
                sink.write(content, offset, byteCount);
            }
        };
    }

    public static RequestBody create(final MediaType contentType, final File file) {
        if (null == file) {
            throw new NullPointerException("file == null");
        }
        return new RequestBody(){

            @Override
            public MediaType contentType() {
                return contentType;
            }

            @Override
            public long length() {
                return file.length();
            }

            @Override
            public void writeTo(BufferSink sink) throws IOException {
                try (Source source = IoKit.source((File)file);){
                    sink.writeAll(source);
                }
            }
        };
    }

    public abstract MediaType contentType();

    public long length() throws IOException {
        return -1L;
    }

    public abstract void writeTo(BufferSink var1) throws IOException;

    public boolean isDuplex() {
        return false;
    }

    public boolean isOneShot() {
        return false;
    }
}

