/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.metric.http;

import java.io.IOException;
import java.util.List;
import org.miaixz.bus.core.Version;
import org.miaixz.bus.core.io.source.GzipSource;
import org.miaixz.bus.core.io.source.Source;
import org.miaixz.bus.core.lang.MediaType;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.http.Builder;
import org.miaixz.bus.http.Cookie;
import org.miaixz.bus.http.Headers;
import org.miaixz.bus.http.Request;
import org.miaixz.bus.http.Response;
import org.miaixz.bus.http.bodys.RealResponseBody;
import org.miaixz.bus.http.bodys.RequestBody;
import org.miaixz.bus.http.metric.CookieJar;
import org.miaixz.bus.http.metric.Interceptor;
import org.miaixz.bus.http.metric.NewChain;

public class BridgeInterceptor
implements Interceptor {
    private final CookieJar cookieJar;

    public BridgeInterceptor(CookieJar cookieJar) {
        this.cookieJar = cookieJar;
    }

    @Override
    public Response intercept(NewChain chain) throws IOException {
        List<Cookie> cookies;
        Request request = chain.request();
        Request.Builder requestBuilder = request.newBuilder();
        RequestBody body = request.body();
        if (null != body) {
            long length;
            MediaType contentType = body.contentType();
            if (null != contentType) {
                requestBuilder.header("Content-Type", contentType.toString());
            }
            if ((length = body.length()) != -1L) {
                requestBuilder.header("Content-Length", Long.toString(length));
                requestBuilder.removeHeader("Transfer-Encoding");
            } else {
                requestBuilder.header("Transfer-Encoding", "chunked");
                requestBuilder.removeHeader("Content-Length");
            }
        }
        if (null == request.header("Host")) {
            requestBuilder.header("Host", Builder.hostHeader(request.url(), false));
        }
        if (null == request.header("Connection")) {
            requestBuilder.header("Connection", "Keep-Alive");
        }
        boolean transparentGzip = false;
        if (null == request.header("Accept-Encoding") && null == request.header("Range")) {
            transparentGzip = true;
            requestBuilder.header("Accept-Encoding", "gzip");
        }
        if (!(cookies = this.cookieJar.loadForRequest(request.url())).isEmpty()) {
            requestBuilder.header("Cookie", this.cookieHeader(cookies));
        }
        if (null == request.header("User-Agent")) {
            requestBuilder.header("User-Agent", "Httpd/" + Version.all());
        }
        Response networkResponse = chain.proceed(requestBuilder.build());
        Headers.receiveHeaders(this.cookieJar, request.url(), networkResponse.headers());
        Response.Builder responseBuilder = networkResponse.newBuilder().request(request);
        if (transparentGzip && "gzip".equalsIgnoreCase(networkResponse.header("Content-Encoding")) && Headers.hasBody(networkResponse)) {
            GzipSource responseBody = new GzipSource((Source)networkResponse.body().source());
            Headers strippedHeaders = networkResponse.headers().newBuilder().removeAll("Content-Encoding").removeAll("Content-Length").build();
            responseBuilder.headers(strippedHeaders);
            responseBuilder.body(new RealResponseBody(networkResponse.header("Content-Type"), -1L, IoKit.buffer((Source)responseBody)));
        }
        return responseBuilder.build();
    }

    private String cookieHeader(List<Cookie> cookies) {
        StringBuilder cookieHeader = new StringBuilder();
        int size = cookies.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                cookieHeader.append("; ");
            }
            Cookie cookie = cookies.get(i);
            cookieHeader.append(cookie.name()).append('=').append(cookie.value());
        }
        return cookieHeader.toString();
    }
}

