/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.metric.sse;

import java.io.IOException;
import org.miaixz.bus.http.Builder;
import org.miaixz.bus.http.Callback;
import org.miaixz.bus.http.NewCall;
import org.miaixz.bus.http.RealCall;
import org.miaixz.bus.http.Request;
import org.miaixz.bus.http.Response;
import org.miaixz.bus.http.bodys.ResponseBody;
import org.miaixz.bus.http.metric.sse.ServerSentEventReader;
import org.miaixz.bus.http.plugin.sse.EventSource;
import org.miaixz.bus.http.plugin.sse.EventSourceListener;

public final class RealEventSource
implements EventSource,
ServerSentEventReader.Callback,
Callback {
    private final Request request;
    private final EventSourceListener listener;
    private NewCall call;
    private boolean canceled;

    public RealEventSource(Request request, EventSourceListener listener) {
        this.request = request;
        this.listener = listener;
        this.call = null;
        this.canceled = false;
    }

    public void connect(NewCall.Factory callFactory) {
        this.call = callFactory.newCall(this.request);
        this.call.enqueue(this);
    }

    @Override
    public void onResponse(NewCall call, Response response) {
        this.processResponse(response);
    }

    public void processResponse(Response response) {
        try (Response ignored = response;){
            if (!response.isSuccessful()) {
                this.listener.onFailure(this, null, response);
                return;
            }
            ResponseBody body = response.body();
            if (body == null) {
                this.listener.onFailure(this, new IllegalStateException("Response body is null"), response);
                return;
            }
            if (!this.isEventStream(body)) {
                this.listener.onFailure(this, new IllegalStateException("Invalid content-type: " + String.valueOf(body.contentType())), response);
                return;
            }
            if (this.call instanceof RealCall) {
                ((RealCall)this.call).timeoutEarlyExit();
            }
            Response modifiedResponse = response.newBuilder().body(Builder.EMPTY_RESPONSE).build();
            ServerSentEventReader reader = new ServerSentEventReader(body.source(), this);
            try {
                this.listener.onOpen(this, modifiedResponse);
                while (reader.processNextEvent()) {
                }
            }
            catch (Exception e) {
                this.listener.onFailure(this, e, modifiedResponse);
                if (ignored != null) {
                    ignored.close();
                }
                return;
            }
            this.listener.onClosed(this);
        }
    }

    private boolean isEventStream(ResponseBody body) {
        if (body.contentType() == null) {
            return false;
        }
        return "text".equals(body.contentType().type()) && "event-stream".equals(body.contentType().subtype());
    }

    @Override
    public void onFailure(NewCall call, IOException e) {
        this.listener.onFailure(this, e, null);
    }

    @Override
    public Request request() {
        return this.request;
    }

    @Override
    public void cancel() {
        if (this.call != null && !this.canceled) {
            this.canceled = true;
            this.call.cancel();
        }
    }

    @Override
    public void onEvent(String id, String type, String data) {
        this.listener.onEvent(this, id, type, data);
    }

    @Override
    public void onRetryChange(long timeMs) {
    }
}

