/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.plugin.sse;

import org.miaixz.bus.http.Builder;
import org.miaixz.bus.http.NewCall;
import org.miaixz.bus.http.Request;
import org.miaixz.bus.http.Response;
import org.miaixz.bus.http.bodys.ResponseBody;
import org.miaixz.bus.http.metric.sse.RealEventSource;
import org.miaixz.bus.http.metric.sse.ServerSentEventReader;
import org.miaixz.bus.http.plugin.sse.EventSource;
import org.miaixz.bus.http.plugin.sse.EventSourceListener;

public final class EventSources {
    public static EventSource.Factory createFactory(NewCall.Factory callFactory) {
        return new FactoryImpl(callFactory);
    }

    public static void processResponse(Response response, final EventSourceListener listener) {
        try (Response ignored = response;){
            if (!response.isSuccessful()) {
                listener.onFailure(null, null, response);
                return;
            }
            ResponseBody body = response.body();
            if (body == null) {
                listener.onFailure(null, new IllegalStateException("Response body is null"), response);
                return;
            }
            if (!EventSources.isEventStream(body)) {
                listener.onFailure(null, new IllegalStateException("Invalid content-type: " + String.valueOf(body.contentType())), response);
                return;
            }
            Response modifiedResponse = response.newBuilder().body(Builder.EMPTY_RESPONSE).build();
            ServerSentEventReader reader = new ServerSentEventReader(body.source(), new ServerSentEventReader.Callback(){

                @Override
                public void onEvent(String id, String type, String data) {
                    listener.onEvent(null, id, type, data);
                }

                @Override
                public void onRetryChange(long timeMs) {
                }
            });
            try {
                listener.onOpen(null, modifiedResponse);
                while (reader.processNextEvent()) {
                }
            }
            catch (Exception e) {
                listener.onFailure(null, e, modifiedResponse);
                if (ignored != null) {
                    ignored.close();
                }
                return;
            }
            listener.onClosed(null);
        }
    }

    private static boolean isEventStream(ResponseBody body) {
        if (body.contentType() == null) {
            return false;
        }
        return "text".equals(body.contentType().type()) && "event-stream".equals(body.contentType().subtype());
    }

    private static class FactoryImpl
    implements EventSource.Factory {
        private final NewCall.Factory callFactory;

        FactoryImpl(NewCall.Factory callFactory) {
            this.callFactory = callFactory;
        }

        @Override
        public EventSource newEventSource(Request request, EventSourceListener listener) {
            RealEventSource eventSource = new RealEventSource(request, listener);
            eventSource.connect(this.callFactory);
            return eventSource;
        }
    }
}

