/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.metric.anget;

import java.util.Collection;
import java.util.List;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.http.metric.anget.UserAgent;

public class Device
extends UserAgent {
    public static final Device UNKNOWN = new Device("unknown", null);
    public static final Device IPHONE = new Device("iPhone", "iphone");
    public static final Device IPOD = new Device("iPod", "ipod");
    public static final Device IPAD = new Device("iPad", "ipad");
    public static final Device ANDROID = new Device("Android", "android");
    public static final Device HARMONY = new Device("Harmony", "OpenHarmony");
    public static final Device GOOGLE_TV = new Device("GoogleTV", "googletv");
    public static final Device WINDOWS_PHONE = new Device("Windows Phone", "windows (ce|phone|mobile)( os)?");
    public static final List<Device> MOBILE_DEVICE = ListKit.of((Object[])new Device[]{WINDOWS_PHONE, IPAD, IPOD, IPHONE, new Device("Android", "XiaoMi|MI\\s+"), ANDROID, HARMONY, GOOGLE_TV, new Device("htcFlyer", "htc_flyer"), new Device("Symbian", "symbian(os)?"), new Device("Blackberry", "blackberry")});
    public static final List<Device> DESKTOP_DEVICE = ListKit.of((Object[])new Device[]{new Device("Windows", "windows"), new Device("Mac", "(macintosh|darwin)"), new Device("Linux", "linux"), new Device("Wii", "wii"), new Device("Playstation", "playstation"), new Device("Java", "java")});
    public static final List<Device> ALL_DEVICE = (List)CollKit.union((Collection[])new Collection[]{MOBILE_DEVICE, DESKTOP_DEVICE});

    public Device(String name, String rule) {
        super(name, rule);
    }

    @Override
    public boolean isMobile() {
        return MOBILE_DEVICE.contains(this);
    }

    public boolean isIPhoneOrIPod() {
        return this.equals(IPHONE) || this.equals(IPOD);
    }

    public boolean isIPad() {
        return this.equals(IPAD);
    }

    public boolean isIos() {
        return this.isIPhoneOrIPod() || this.isIPad();
    }

    public boolean isAndroid() {
        return this.equals(ANDROID) || this.equals(GOOGLE_TV);
    }

    public boolean isHarmony() {
        return this.equals(HARMONY);
    }
}

