/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.bodys;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.miaixz.bus.core.io.ByteString;
import org.miaixz.bus.core.io.buffer.Buffer;
import org.miaixz.bus.core.io.source.BufferSource;
import org.miaixz.bus.core.lang.MediaType;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.http.Builder;

public abstract class ResponseBody
implements Closeable {
    private Reader reader;

    public static ResponseBody create(MediaType contentType, String content) {
        Charset charset = org.miaixz.bus.core.lang.Charset.UTF_8;
        if (contentType != null && (charset = contentType.charset()) == null) {
            charset = org.miaixz.bus.core.lang.Charset.UTF_8;
            contentType = MediaType.valueOf((String)(String.valueOf(contentType) + "; charset=utf-8"));
        }
        Buffer buffer = new Buffer().writeString(content, charset);
        return ResponseBody.create(contentType, buffer.size(), (BufferSource)buffer);
    }

    public static ResponseBody create(MediaType contentType, byte[] content) {
        Buffer buffer = new Buffer().write(content);
        return ResponseBody.create(contentType, content.length, (BufferSource)buffer);
    }

    public static ResponseBody create(MediaType contentType, ByteString content) {
        Buffer buffer = new Buffer().write(content);
        return ResponseBody.create(contentType, content.size(), (BufferSource)buffer);
    }

    public static ResponseBody create(final MediaType contentType, final long length, final BufferSource content) {
        if (null == content) {
            throw new NullPointerException("source == null");
        }
        return new ResponseBody(){

            @Override
            public MediaType contentType() {
                return contentType;
            }

            @Override
            public long length() {
                return length;
            }

            @Override
            public BufferSource source() {
                return content;
            }
        };
    }

    public abstract MediaType contentType();

    public abstract long length();

    public final InputStream byteStream() {
        return this.source().inputStream();
    }

    public abstract BufferSource source();

    public final byte[] bytes() throws IOException {
        byte[] bytes;
        long contentLength = this.length();
        if (contentLength > Integer.MAX_VALUE) {
            throw new IOException("Cannot buffer entire body for content length: " + contentLength);
        }
        try (BufferSource source = this.source();){
            bytes = source.readByteArray();
        }
        if (contentLength != -1L && contentLength != (long)bytes.length) {
            throw new IOException("Content-Length (" + contentLength + ") and stream length (" + bytes.length + ") disagree");
        }
        return bytes;
    }

    public final Reader charStream() {
        Reader r = this.reader;
        return null != r ? r : (this.reader = new BomAwareReader(this.source(), this.charset()));
    }

    public final String string() throws IOException {
        try (BufferSource source = this.source();){
            Charset charset = Builder.bomAwareCharset(source, this.charset());
            String string = source.readString(charset);
            return string;
        }
    }

    private Charset charset() {
        MediaType contentType = this.contentType();
        return null != contentType ? contentType.charset(org.miaixz.bus.core.lang.Charset.UTF_8) : org.miaixz.bus.core.lang.Charset.UTF_8;
    }

    @Override
    public void close() {
        IoKit.close((Closeable)this.source());
    }

    static class BomAwareReader
    extends Reader {
        private final BufferSource source;
        private final Charset charset;
        private boolean closed;
        private Reader delegate;

        BomAwareReader(BufferSource source, Charset charset) {
            this.source = source;
            this.charset = charset;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            Reader delegate = this.delegate;
            if (null == delegate) {
                Charset charset = Builder.bomAwareCharset(this.source, this.charset);
                delegate = this.delegate = new InputStreamReader(this.source.inputStream(), charset);
            }
            return delegate.read(cbuf, off, len);
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            if (null != this.delegate) {
                this.delegate.close();
            } else {
                this.source.close();
            }
        }
    }
}

