/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import org.miaixz.bus.core.lang.MediaType;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.net.tls.SSLContextBuilder;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.http.Callback;
import org.miaixz.bus.http.DnsX;
import org.miaixz.bus.http.Httpd;
import org.miaixz.bus.http.NewCall;
import org.miaixz.bus.http.Request;
import org.miaixz.bus.http.Response;
import org.miaixz.bus.http.accord.ConnectionPool;
import org.miaixz.bus.http.bodys.FormBody;
import org.miaixz.bus.http.bodys.MultipartBody;
import org.miaixz.bus.http.bodys.RequestBody;
import org.miaixz.bus.http.metric.Dispatcher;
import org.miaixz.bus.http.plugin.httpx.HttpProxy;
import org.miaixz.bus.logger.Logger;

public class Httpx {
    private static Httpd httpd;

    public Httpx() {
        this(30, 30, 30);
    }

    public Httpx(X509TrustManager x509TrustManager) {
        this(null, null, 30, 30, 30, 64, 5, 5, 5, SSLContextBuilder.newSslSocketFactory((X509TrustManager)x509TrustManager), x509TrustManager, (hostname, session) -> true);
    }

    public Httpx(int connTimeout, int readTimeout, int writeTimeout) {
        this(null, null, connTimeout, readTimeout, writeTimeout, 128, 5, 5, 5);
    }

    public Httpx(int connTimeout, int readTimeout, int writeTimeout, int maxRequests, int maxRequestsPerHost, int maxIdleConnections, int keepAliveDuration) {
        this(null, null, connTimeout, readTimeout, writeTimeout, maxRequests, maxRequestsPerHost, maxIdleConnections, keepAliveDuration);
    }

    public Httpx(DnsX dns, HttpProxy httpProxy, int connTimeout, int readTimeout, int writeTimeout, int maxRequests, int maxRequestsPerHost, int maxIdleConnections, int keepAliveDuration) {
        this(dns, httpProxy, connTimeout, readTimeout, writeTimeout, maxRequests, maxRequestsPerHost, maxIdleConnections, keepAliveDuration, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Httpx(DnsX dns, HttpProxy httpProxy, int connTimeout, int readTimeout, int writeTimeout, int maxRequests, int maxRequestsPerHost, int maxIdleConnections, int keepAliveDuration, SSLSocketFactory sslSocketFactory, X509TrustManager x509TrustManager, HostnameVerifier hostnameVerifier) {
        Class<Httpx> clazz = Httpx.class;
        synchronized (Httpx.class) {
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.setMaxRequests(maxRequests);
            dispatcher.setMaxRequestsPerHost(maxRequestsPerHost);
            ConnectionPool connectPool = new ConnectionPool(maxIdleConnections, keepAliveDuration, TimeUnit.MINUTES);
            Httpd.Builder builder = new Httpd.Builder();
            builder.dispatcher(dispatcher);
            builder.connectionPool(connectPool);
            builder.addNetworkInterceptor(chain -> {
                Request request = chain.request();
                return chain.proceed(request);
            });
            if (ObjectKit.isNotEmpty((Object)dns)) {
                builder.dns(hostname -> {
                    try {
                        return dns.lookup(hostname);
                    }
                    catch (Exception e) {
                        Logger.error((String)"DNS lookup failed: {}", (Object[])new Object[]{e.getMessage()});
                        return DnsX.SYSTEM.lookup(hostname);
                    }
                });
            }
            if (ObjectKit.isNotEmpty((Object)httpProxy)) {
                builder.proxy(httpProxy.proxy());
                if (null != httpProxy.user && null != httpProxy.password) {
                    builder.proxyAuthenticator(httpProxy.authenticator());
                }
            }
            builder.connectTimeout(connTimeout, TimeUnit.SECONDS);
            builder.readTimeout(readTimeout, TimeUnit.SECONDS);
            builder.writeTimeout(writeTimeout, TimeUnit.SECONDS);
            if (ObjectKit.isNotEmpty((Object)sslSocketFactory)) {
                builder.sslSocketFactory(sslSocketFactory, x509TrustManager);
            }
            if (ObjectKit.isNotEmpty((Object)hostnameVerifier)) {
                builder.hostnameVerifier(hostnameVerifier);
            }
            httpd = builder.build();
            // ** MonitorExit[var13_13] (shouldn't be in output)
            return;
        }
    }

    public static String get(String url) {
        return Httpx.get(url, "UTF-8");
    }

    public static String get(String url, String charset) {
        return Httpx.execute(Builder.builder().url(url).requestCharset(charset).responseCharset(charset).build());
    }

    public static String get(String url, boolean isAsync) {
        if (isAsync) {
            return Httpx.enqueue(Builder.builder().url(url).method("GET").build());
        }
        return Httpx.get(url);
    }

    public static String get(String url, Map<String, String> formMap) {
        return Httpx.get(url, formMap, null, "UTF-8");
    }

    public static void get(String url, Callback callback) {
        Request request = new Request.Builder().url(url).get().build();
        NewCall call = httpd.newCall(request);
        call.enqueue(callback);
    }

    public static String get(String url, Map<String, String> formMap, Map<String, String> headerMap) {
        return Httpx.get(url, formMap, headerMap, "UTF-8");
    }

    public static String get(String url, Map<String, String> formMap, Map<String, String> headerMap, String charset) {
        return Httpx.execute(Builder.builder().url(url).headerMap(headerMap).formMap(formMap).requestCharset(charset).responseCharset(charset).build());
    }

    public static void post(String url, Map<String, String> formMap, Callback callback) {
        StringBuilder data = new StringBuilder();
        if (MapKit.isNotEmpty(formMap)) {
            Set<String> keys = formMap.keySet();
            for (String key : keys) {
                data.append(key).append("=").append(formMap.get(key)).append("&");
            }
        }
        RequestBody requestBody = RequestBody.create(MediaType.TEXT_HTML_TYPE, data.toString());
        Request request = new Request.Builder().url(url).post(requestBody).build();
        NewCall call = httpd.newCall(request);
        call.enqueue(callback);
    }

    public static String post(String url) {
        return Httpx.post(url, null);
    }

    public static String post(String url, Map<String, String> formMap) {
        String data = "";
        if (MapKit.isNotEmpty(formMap)) {
            data = formMap.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
        }
        return Httpx.post(url, data, "application/x-www-form-urlencoded");
    }

    public static String post(String url, String data, String contentType) {
        return Httpx.post(url, data, contentType, "UTF-8");
    }

    public static String post(String url, Map<String, String> formMap, String contentType) {
        return Httpx.post(url, formMap, contentType, "UTF-8");
    }

    public static String post(String url, Map<String, String> formMap, Map<String, String> headerMap) {
        return Httpx.post(url, formMap, headerMap, "application/x-www-form-urlencoded");
    }

    public static String post(String url, String data, String contentType, String charset) {
        return Httpx.execute(Builder.builder().url(url).method("POST").data(data).contentType(contentType).requestCharset(charset).responseCharset(charset).build());
    }

    public static String post(String url, String data, Map<String, String> headerMap, String contentType) {
        return Httpx.execute(Builder.builder().url(url).method("POST").data(data).headerMap(headerMap).contentType(contentType).requestCharset("UTF-8").responseCharset("UTF-8").build());
    }

    public static String post(String url, Map<String, String> formMap, String contentType, String charset) {
        return Httpx.execute(Builder.builder().url(url).method("POST").formMap(formMap).contentType(contentType).requestCharset(charset).responseCharset(charset).build());
    }

    public static String post(String url, Map<String, String> formMap, Map<String, String> headerMap, String contentType) {
        return Httpx.post(url, formMap, headerMap, contentType, "UTF-8");
    }

    public static String post(String url, Map<String, String> formMap, Map<String, String> headerMap, String contentType, String charset) {
        return Httpx.execute(Builder.builder().url(url).method("POST").headerMap(headerMap).formMap(formMap).contentType(contentType).requestCharset(charset).responseCharset(charset).build());
    }

    public static String put(String url) {
        return Httpx.put(url, (String)null, "UTF-8");
    }

    public static String put(String url, Map<String, String> formMap) {
        return Httpx.put(url, formMap, "application/x-www-form-urlencoded", "UTF-8");
    }

    public static String put(String url, String data, String contentType) {
        return Httpx.put(url, data, contentType, "UTF-8");
    }

    public static String put(String url, Map<String, String> formMap, String contentType) {
        return Httpx.put(url, formMap, contentType, "UTF-8");
    }

    public static String put(String url, Map<String, String> formMap, Map<String, String> headerMap) {
        return Httpx.put(url, formMap, headerMap, "application/x-www-form-urlencoded");
    }

    public static String put(String url, String data, String contentType, String charset) {
        return Httpx.execute(Builder.builder().url(url).method("PUT").data(data).contentType(contentType).requestCharset(charset).responseCharset(charset).build());
    }

    public static String put(String url, String data, Map<String, String> headerMap, String contentType) {
        return Httpx.execute(Builder.builder().url(url).method("PUT").data(data).headerMap(headerMap).contentType(contentType).requestCharset("UTF-8").responseCharset("UTF-8").build());
    }

    public static String put(String url, Map<String, String> formMap, String contentType, String charset) {
        return Httpx.execute(Builder.builder().url(url).method("PUT").formMap(formMap).contentType(contentType).requestCharset(charset).responseCharset(charset).build());
    }

    public static String put(String url, Map<String, String> formMap, Map<String, String> headerMap, String contentType) {
        return Httpx.put(url, formMap, headerMap, contentType, "UTF-8");
    }

    public static String put(String url, Map<String, String> formMap, Map<String, String> headerMap, String contentType, String charset) {
        return Httpx.execute(Builder.builder().url(url).method("PUT").headerMap(headerMap).formMap(formMap).contentType(contentType).requestCharset(charset).responseCharset(charset).build());
    }

    public static String delete(String url) {
        return Httpx.delete(url, null, "UTF-8");
    }

    public static String delete(String url, Map<String, String> formMap) {
        return Httpx.delete(url, formMap, "UTF-8");
    }

    public static String delete(String url, Map<String, String> formMap, String charset) {
        return Httpx.execute(Builder.builder().url(url).method("DELETE").formMap(formMap).requestCharset(charset).responseCharset(charset).build());
    }

    public static String delete(String url, Map<String, String> formMap, Map<String, String> headerMap) {
        return Httpx.delete(url, formMap, headerMap, "UTF-8");
    }

    public static String delete(String url, Map<String, String> formMap, Map<String, String> headerMap, String charset) {
        return Httpx.execute(Builder.builder().url(url).method("DELETE").headerMap(headerMap).formMap(formMap).requestCharset(charset).responseCharset(charset).build());
    }

    public static String head(String url) {
        return Httpx.head(url, "UTF-8");
    }

    public static String head(String url, String charset) {
        return Httpx.head(url, null, charset);
    }

    public static String head(String url, Map<String, String> headerMap, String charset) {
        StringBuilder result = new StringBuilder();
        try {
            Request request = Httpx.builder(Builder.builder().url(url).method("HEAD").headerMap(headerMap).requestCharset(charset).responseCharset(charset).build()).url(url).build();
            Response response = httpd.newCall(request).execute();
            if (response.headers() != null) {
                response.headers().toMultimap().forEach((key, values) -> result.append((String)key).append(": ").append(String.join((CharSequence)", ", values)).append("\n"));
            }
            response.close();
        }
        catch (Exception e) {
            Logger.error((String)"HEAD request failed for URL [{}]: {}", (Object[])new Object[]{url, e.getMessage()});
        }
        return result.toString();
    }

    public static String post(String url, Map<String, String> formMap, List<String> list) {
        MediaType contentType = MediaType.valueOf((String)"application/x-www-form-urlencoded;UTF-8");
        RequestBody bodyParams = RequestBody.create(contentType, MapKit.isNotEmpty(formMap) ? formMap.toString() : "");
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MediaType.MULTIPART_FORM_DATA_TYPE).addFormDataPart("params", "", bodyParams);
        for (String path : list) {
            File file = new File(path);
            if (file.exists()) {
                requestBodyBuilder.addFormDataPart("file", file.getName(), RequestBody.create(contentType, file));
                continue;
            }
            Logger.warn((String)"File not found: {}", (Object[])new Object[]{path});
        }
        MultipartBody requestBody = requestBodyBuilder.build();
        Request request = new Request.Builder().url(url).post(requestBody).build();
        String result = "";
        try {
            Response response = httpd.newCall(request).execute();
            if (response.body() != null) {
                byte[] bytes = response.body().bytes();
                result = new String(bytes, "UTF-8");
            }
            response.close();
        }
        catch (Exception e) {
            Logger.error((String)"Requesting HTTP Error for URL [{}]: {}", (Object[])new Object[]{url, e.getMessage()});
        }
        return result;
    }

    private static Request.Builder builder(Builder builder) {
        if (StringKit.isBlank((CharSequence)builder.requestCharset)) {
            builder.requestCharset = "UTF-8";
        }
        if (StringKit.isBlank((CharSequence)builder.responseCharset)) {
            builder.responseCharset = "UTF-8";
        }
        if (StringKit.isBlank((CharSequence)builder.method)) {
            builder.method = "GET";
        }
        if (StringKit.isBlank((CharSequence)builder.contentType)) {
            builder.contentType = "application/x-www-form-urlencoded";
        }
        if (builder.tracer) {
            Logger.info((String)"Request Builder: {}", (Object[])new Object[]{builder});
        }
        Request.Builder request = new Request.Builder();
        if (MapKit.isNotEmpty(builder.headerMap)) {
            builder.headerMap.forEach(request::addHeader);
        }
        String method = builder.method.toUpperCase();
        String contentType = String.format("%s;charset=%s", builder.contentType, builder.requestCharset);
        if (StringKit.equals((CharSequence)method, (CharSequence)"GET")) {
            if (MapKit.isNotEmpty(builder.formMap)) {
                String form = builder.formMap.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
                builder.url = String.format("%s%s%s", builder.url, builder.url.contains("?") ? "&" : "?", form);
            }
            request.get();
        } else if (StringKit.equals((CharSequence)method, (CharSequence)"HEAD")) {
            request.head();
        } else if (ArrayKit.contains((Object[])new String[]{"POST", "PUT", "DELETE", "PATCH"}, (Object)method)) {
            RequestBody requestBody = null;
            if (StringKit.isNotEmpty((CharSequence)builder.data)) {
                requestBody = RequestBody.create(MediaType.valueOf((String)contentType), builder.data);
            } else if (MapKit.isNotEmpty(builder.formMap)) {
                FormBody.Builder form = new FormBody.Builder(Charset.forName("UTF-8"));
                builder.formMap.forEach((key, value) -> form.add((String)key, StringKit.toString((Object)value)));
                requestBody = form.build();
            }
            request.method(method, requestBody);
        } else {
            throw new InternalException("Unsupported request method: " + method);
        }
        return request;
    }

    private static String execute(Builder builder) {
        String result = "";
        try {
            Request request = Httpx.builder(builder).url(builder.url).build();
            Response response = httpd.newCall(request).execute();
            if (response.body() != null) {
                byte[] bytes = response.body().bytes();
                result = new String(bytes, builder.responseCharset);
            }
            if (builder.tracer) {
                Logger.info((String)"Response for URL [{}]: {}", (Object[])new Object[]{builder.url, result});
            }
            response.close();
        }
        catch (Exception e) {
            Logger.error((String)"Request failed for URL [{}]: {}", (Object[])new Object[]{builder.url, e.getMessage()});
        }
        return result;
    }

    private static String enqueue(final Builder builder) {
        Request request = Httpx.builder(builder).url(builder.url).build();
        NewCall call = httpd.newCall(request);
        final String[] result = new String[]{""};
        call.enqueue(new Callback(){

            @Override
            public void onFailure(NewCall call, IOException e) {
                Logger.error((String)"Async request failed for URL [{}]: {}", (Object[])new Object[]{builder.url, e.getMessage()});
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(NewCall call, Response response) throws IOException {
                try {
                    if (response.body() != null) {
                        byte[] bytes = response.body().bytes();
                        result[0] = new String(bytes, builder.responseCharset);
                        if (builder.tracer) {
                            Logger.info((String)"Async response for URL [{}]: {}", (Object[])new Object[]{builder.url, result[0]});
                        }
                    }
                }
                finally {
                    response.close();
                }
            }
        });
        return result[0];
    }

    static {
        new Httpx(SSLContextBuilder.newTrustManager());
    }

    private static class Builder {
        private String url;
        private String method;
        private String data;
        private String contentType;
        private Map<String, String> formMap;
        private Map<String, String> headerMap;
        private String requestCharset;
        private String responseCharset;
        private boolean tracer;

        @Generated
        Builder(String url, String method, String data, String contentType, Map<String, String> formMap, Map<String, String> headerMap, String requestCharset, String responseCharset, boolean tracer) {
            this.url = url;
            this.method = method;
            this.data = data;
            this.contentType = contentType;
            this.formMap = formMap;
            this.headerMap = headerMap;
            this.requestCharset = requestCharset;
            this.responseCharset = responseCharset;
            this.tracer = tracer;
        }

        @Generated
        public static BuilderBuilder builder() {
            return new BuilderBuilder();
        }

        @Generated
        public String toString() {
            return "Httpx.Builder(url=" + this.url + ", method=" + this.method + ", data=" + this.data + ", contentType=" + this.contentType + ", formMap=" + String.valueOf(this.formMap) + ", headerMap=" + String.valueOf(this.headerMap) + ", requestCharset=" + this.requestCharset + ", responseCharset=" + this.responseCharset + ", tracer=" + this.tracer + ")";
        }

        @Generated
        public static class BuilderBuilder {
            @Generated
            private String url;
            @Generated
            private String method;
            @Generated
            private String data;
            @Generated
            private String contentType;
            @Generated
            private Map<String, String> formMap;
            @Generated
            private Map<String, String> headerMap;
            @Generated
            private String requestCharset;
            @Generated
            private String responseCharset;
            @Generated
            private boolean tracer;

            @Generated
            BuilderBuilder() {
            }

            @Generated
            public BuilderBuilder url(String url) {
                this.url = url;
                return this;
            }

            @Generated
            public BuilderBuilder method(String method) {
                this.method = method;
                return this;
            }

            @Generated
            public BuilderBuilder data(String data) {
                this.data = data;
                return this;
            }

            @Generated
            public BuilderBuilder contentType(String contentType) {
                this.contentType = contentType;
                return this;
            }

            @Generated
            public BuilderBuilder formMap(Map<String, String> formMap) {
                this.formMap = formMap;
                return this;
            }

            @Generated
            public BuilderBuilder headerMap(Map<String, String> headerMap) {
                this.headerMap = headerMap;
                return this;
            }

            @Generated
            public BuilderBuilder requestCharset(String requestCharset) {
                this.requestCharset = requestCharset;
                return this;
            }

            @Generated
            public BuilderBuilder responseCharset(String responseCharset) {
                this.responseCharset = responseCharset;
                return this;
            }

            @Generated
            public BuilderBuilder tracer(boolean tracer) {
                this.tracer = tracer;
                return this;
            }

            @Generated
            public Builder build() {
                return new Builder(this.url, this.method, this.data, this.contentType, this.formMap, this.headerMap, this.requestCharset, this.responseCharset, this.tracer);
            }

            @Generated
            public String toString() {
                return "Httpx.Builder.BuilderBuilder(url=" + this.url + ", method=" + this.method + ", data=" + this.data + ", contentType=" + this.contentType + ", formMap=" + String.valueOf(this.formMap) + ", headerMap=" + String.valueOf(this.headerMap) + ", requestCharset=" + this.requestCharset + ", responseCharset=" + this.responseCharset + ", tracer=" + this.tracer + ")";
            }
        }
    }
}

