/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http;

import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.net.Protocol;
import org.miaixz.bus.core.xyz.XmlKit;
import org.miaixz.bus.http.plugin.soap.SoapBuilder;

public class SoapX {
    public static SoapBuilder create(String url) {
        return SoapBuilder.of(url);
    }

    public static SoapBuilder create(String url, Protocol protocol) {
        return SoapBuilder.of(url, protocol);
    }

    public static SoapBuilder create(String url, Protocol protocol, String namespaceURI) {
        return SoapBuilder.of(url, protocol, namespaceURI);
    }

    public static String toString(SOAPMessage message, boolean pretty) {
        return SoapX.toString(message, pretty, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static String toString(SOAPMessage message, boolean pretty, Charset charset) {
        String messageToString;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            message.writeTo((OutputStream)out);
        }
        catch (SOAPException | IOException e) {
            throw new InternalException(e);
        }
        try {
            messageToString = out.toString(charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalException((Throwable)e);
        }
        return pretty ? XmlKit.format((String)messageToString) : messageToString;
    }
}

