/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.accord;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.UnknownServiceException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import org.miaixz.bus.http.accord.ConnectionSuite;
import org.miaixz.bus.http.metric.Internal;

public final class ConnectionSelector {
    private final List<ConnectionSuite> connectionSuites;
    private int nextModeIndex = 0;
    private boolean isFallbackPossible;
    private boolean isFallback;

    public ConnectionSelector(List<ConnectionSuite> connectionSuites) {
        this.connectionSuites = connectionSuites;
    }

    public ConnectionSuite configureSecureSocket(SSLSocket sslSocket) throws IOException {
        ConnectionSuite tlsConfiguration = null;
        int size = this.connectionSuites.size();
        for (int i = this.nextModeIndex; i < size; ++i) {
            ConnectionSuite connectionSuite = this.connectionSuites.get(i);
            if (!connectionSuite.isCompatible(sslSocket)) continue;
            tlsConfiguration = connectionSuite;
            this.nextModeIndex = i + 1;
            break;
        }
        if (null == tlsConfiguration) {
            throw new UnknownServiceException("Unable to find acceptable protocols. isFallback=" + this.isFallback + ", modes=" + String.valueOf(this.connectionSuites) + ", supported protocols=" + Arrays.toString(sslSocket.getEnabledProtocols()));
        }
        this.isFallbackPossible = this.isFallbackPossible(sslSocket);
        Internal.instance.apply(tlsConfiguration, sslSocket, this.isFallback);
        return tlsConfiguration;
    }

    public boolean connectionFailed(IOException ex) {
        this.isFallback = true;
        if (!this.isFallbackPossible) {
            return false;
        }
        if (ex instanceof ProtocolException) {
            return false;
        }
        if (ex instanceof InterruptedIOException) {
            return false;
        }
        if (ex instanceof SSLHandshakeException && ex.getCause() instanceof CertificateException) {
            return false;
        }
        if (ex instanceof SSLPeerUnverifiedException) {
            return false;
        }
        return ex instanceof SSLException;
    }

    private boolean isFallbackPossible(SSLSocket socket) {
        for (int i = this.nextModeIndex; i < this.connectionSuites.size(); ++i) {
            if (!this.connectionSuites.get(i).isCompatible(socket)) continue;
            return true;
        }
        return false;
    }
}

