/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.metric.http;

import java.util.Arrays;

public final class Http2Settings {
    public static final int COUNT = 10;
    private final int[] values = new int[10];
    private int set;

    public void clear() {
        this.set = 0;
        Arrays.fill(this.values, 0);
    }

    public Http2Settings set(int id, int value) {
        if (id < 0 || id >= this.values.length) {
            return this;
        }
        int bit = 1 << id;
        this.set |= bit;
        this.values[id] = value;
        return this;
    }

    public boolean isSet(int id) {
        int bit = 1 << id;
        return (this.set & bit) != 0;
    }

    public int get(int id) {
        return this.values[id];
    }

    public int size() {
        return Integer.bitCount(this.set);
    }

    public int getHeaderTableSize() {
        int bit = 2;
        return (bit & this.set) != 0 ? this.values[1] : -1;
    }

    public boolean getEnablePush(boolean defaultValue) {
        int bit = 4;
        return ((bit & this.set) != 0 ? this.values[2] : (defaultValue ? 1 : 0)) == 1;
    }

    public int getMaxConcurrentStreams(int defaultValue) {
        int bit = 16;
        return (bit & this.set) != 0 ? this.values[4] : defaultValue;
    }

    public int getMaxFrameSize(int defaultValue) {
        int bit = 32;
        return (bit & this.set) != 0 ? this.values[5] : defaultValue;
    }

    public int getMaxHeaderListSize(int defaultValue) {
        int bit = 64;
        return (bit & this.set) != 0 ? this.values[6] : defaultValue;
    }

    public int getInitialWindowSize() {
        int bit = 128;
        return (bit & this.set) != 0 ? this.values[7] : 65535;
    }

    public void merge(Http2Settings other) {
        for (int i = 0; i < 10; ++i) {
            if (!other.isSet(i)) continue;
            this.set(i, other.get(i));
        }
    }
}

