/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.metric.sse;

import java.io.IOException;
import org.miaixz.bus.core.io.ByteString;
import org.miaixz.bus.core.io.SegmentBuffer;
import org.miaixz.bus.core.io.buffer.Buffer;
import org.miaixz.bus.core.io.source.BufferSource;

public final class ServerSentEventReader {
    private final BufferSource source;
    private final Callback callback;
    private String lastId;
    private static final SegmentBuffer options = SegmentBuffer.of((ByteString[])new ByteString[]{ByteString.encodeUtf8((String)"\r\n"), ByteString.encodeUtf8((String)"\r"), ByteString.encodeUtf8((String)"\n"), ByteString.encodeUtf8((String)"data: "), ByteString.encodeUtf8((String)"data:"), ByteString.encodeUtf8((String)"data\r\n"), ByteString.encodeUtf8((String)"data\r"), ByteString.encodeUtf8((String)"data\n"), ByteString.encodeUtf8((String)"id: "), ByteString.encodeUtf8((String)"id:"), ByteString.encodeUtf8((String)"id\r\n"), ByteString.encodeUtf8((String)"id\r"), ByteString.encodeUtf8((String)"id\n"), ByteString.encodeUtf8((String)"event: "), ByteString.encodeUtf8((String)"event:"), ByteString.encodeUtf8((String)"event\r\n"), ByteString.encodeUtf8((String)"event\r"), ByteString.encodeUtf8((String)"event\n"), ByteString.encodeUtf8((String)"retry: "), ByteString.encodeUtf8((String)"retry:")});
    private static final ByteString CRLF = ByteString.encodeUtf8((String)"\r\n");

    public ServerSentEventReader(BufferSource source, Callback callback) {
        this.source = source;
        this.callback = callback;
        this.lastId = null;
    }

    public boolean processNextEvent() throws IOException {
        String id = this.lastId;
        String type = null;
        Buffer data = new Buffer();
        block11: while (true) {
            int option = this.source.select(options);
            switch (option) {
                case 0: 
                case 1: 
                case 2: {
                    this.completeEvent(id, type, data);
                    return true;
                }
                case 3: 
                case 4: {
                    ServerSentEventReader.readData(this.source, data);
                    continue block11;
                }
                case 5: 
                case 6: 
                case 7: {
                    data.writeByte(10);
                    continue block11;
                }
                case 8: 
                case 9: {
                    String idValue = this.source.readUtf8LineStrict();
                    id = idValue.isEmpty() ? null : idValue;
                    continue block11;
                }
                case 10: 
                case 11: 
                case 12: {
                    id = null;
                    continue block11;
                }
                case 13: 
                case 14: {
                    String typeValue = this.source.readUtf8LineStrict();
                    type = typeValue.isEmpty() ? null : typeValue;
                    continue block11;
                }
                case 15: 
                case 16: 
                case 17: {
                    type = null;
                    continue block11;
                }
                case 18: 
                case 19: {
                    long retryMs = ServerSentEventReader.readRetryMs(this.source);
                    if (retryMs == -1L) continue block11;
                    this.callback.onRetryChange(retryMs);
                    continue block11;
                }
                case -1: {
                    long lineEnd = this.source.indexOfElement(CRLF);
                    if (lineEnd != -1L) {
                        this.source.skip(lineEnd);
                        this.source.select(options);
                        continue block11;
                    }
                    return false;
                }
            }
            break;
        }
        throw new AssertionError();
    }

    private void completeEvent(String id, String type, Buffer data) throws IOException {
        if (data.size() != 0L) {
            this.lastId = id;
            data.skip(1L);
            this.callback.onEvent(id, type, data.readUtf8());
        }
    }

    private static void readData(BufferSource source, Buffer data) throws IOException {
        data.writeByte(10);
        source.readFully(data, source.indexOfElement(CRLF));
        source.select(options);
    }

    private static long readRetryMs(BufferSource source) throws IOException {
        String retryString = source.readUtf8LineStrict();
        try {
            return Long.parseLong(retryString);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static interface Callback {
        public void onEvent(String var1, String var2, String var3);

        public void onRetryChange(long var1);
    }
}

