/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.plugin.httpv;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.miaixz.bus.http.plugin.httpv.CoverArray;
import org.miaixz.bus.http.plugin.httpv.CoverWapper;

public interface Convertor {
    public String contentType();

    public CoverWapper toMapper(InputStream var1, Charset var2);

    public CoverArray toArray(InputStream var1, Charset var2);

    public byte[] serialize(Object var1, Charset var2);

    public byte[] serialize(Object var1, String var2, Charset var3);

    public <T> T toBean(Class<T> var1, InputStream var2, Charset var3);

    public <T> List<T> toList(Class<T> var1, InputStream var2, Charset var3);

    public static class FormConvertor
    implements Convertor {
        private final Convertor convertor;

        public FormConvertor(Convertor convertor) {
            this.convertor = convertor;
        }

        @Override
        public String contentType() {
            return "application/x-www-form-urlencoded";
        }

        @Override
        public CoverWapper toMapper(InputStream in, Charset charset) {
            return this.convertor.toMapper(in, charset);
        }

        @Override
        public CoverArray toArray(InputStream in, Charset charset) {
            return this.convertor.toArray(in, charset);
        }

        @Override
        public byte[] serialize(Object object, Charset charset) {
            return this.serialize(object, null, charset);
        }

        @Override
        public byte[] serialize(Object object, String dateFormat, Charset charset) {
            byte[] data = this.convertor.serialize(object, dateFormat, charset);
            CoverWapper coverWapper = this.convertor.toMapper(new ByteArrayInputStream(data), charset);
            StringBuilder sb = new StringBuilder();
            for (String key : coverWapper.keySet()) {
                sb.append(key).append('=').append(coverWapper.getString(key)).append('&');
            }
            if (sb.length() > 1) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString().getBytes(charset);
        }

        @Override
        public <T> T toBean(Class<T> type, InputStream in, Charset charset) {
            return this.convertor.toBean(type, in, charset);
        }

        @Override
        public <T> List<T> toList(Class<T> type, InputStream in, Charset charset) {
            return this.convertor.toList(type, in, charset);
        }
    }
}

