/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.plugin.httpv;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.miaixz.bus.core.io.ByteString;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.http.Httpv;
import org.miaixz.bus.http.Request;
import org.miaixz.bus.http.Response;
import org.miaixz.bus.http.plugin.httpv.Cancelable;
import org.miaixz.bus.http.plugin.httpv.Convertor;
import org.miaixz.bus.http.plugin.httpv.CoverHttp;
import org.miaixz.bus.http.plugin.httpv.CoverResult;
import org.miaixz.bus.http.plugin.httpv.CoverTasks;
import org.miaixz.bus.http.socket.WebSocket;
import org.miaixz.bus.http.socket.WebSocketListener;

public class CoverCall
implements Cancelable {
    private final List<Object> queues = new ArrayList<Object>();
    private final CoverTasks.Executor executor;
    private boolean cancelOrClosed;
    private WebSocket webSocket;
    private Charset charset;
    private String msgType;

    public CoverCall(CoverTasks.Executor executor, String msgType) {
        this.executor = executor;
        this.msgType = msgType;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public synchronized boolean cancel() {
        if (null != this.webSocket) {
            this.webSocket.cancel();
        }
        this.cancelOrClosed = true;
        return true;
    }

    public synchronized boolean close(int code, String reason) {
        if (null != this.webSocket) {
            this.webSocket.close(code, reason);
        }
        this.cancelOrClosed = true;
        return true;
    }

    public void msgType(String type) {
        if (null == type || type.equalsIgnoreCase("form")) {
            throw new IllegalArgumentException("msgType cannot be null or form");
        }
        this.msgType = type;
    }

    public long queueSize() {
        if (null != this.webSocket) {
            return this.webSocket.queueSize();
        }
        return this.queues.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(Object msg) {
        if (null == msg) {
            return false;
        }
        List<Object> list = this.queues;
        synchronized (list) {
            if (null != this.webSocket) {
                return this.send(this.webSocket, msg);
            }
            this.queues.add(msg);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWebSocket(WebSocket webSocket) {
        List<Object> list = this.queues;
        synchronized (list) {
            for (Object msg : this.queues) {
                this.send(webSocket, msg);
            }
            this.webSocket = webSocket;
            this.queues.clear();
        }
    }

    boolean send(WebSocket webSocket, Object msg) {
        if (null == msg) {
            return false;
        }
        if (msg instanceof String) {
            return webSocket.send((String)msg);
        }
        if (msg instanceof ByteString) {
            return webSocket.send((ByteString)msg);
        }
        if (msg instanceof byte[]) {
            return webSocket.send(ByteString.of((byte[])((byte[])msg)));
        }
        byte[] bytes = (byte[])this.executor.doMsgConvert((String)this.msgType, (CoverTasks.Executor.ConvertFunc<byte[]>)LambdaMetafactory.metafactory(null, null, null, (Lorg/miaixz/bus/http/plugin/httpv/Convertor;)Ljava/lang/Object;, lambda$send$0(java.lang.Object org.miaixz.bus.http.plugin.httpv.Convertor ), (Lorg/miaixz/bus/http/plugin/httpv/Convertor;)[B)((CoverCall)this, (Object)msg)).data;
        return webSocket.send(new String(bytes, this.charset));
    }

    private /* synthetic */ byte[] lambda$send$0(Object msg, Convertor c) {
        return c.serialize(msg, this.charset);
    }

    public static class Message {
        private String text;
        private ByteString bytes;

        public Message(String text) {
            this.text = text;
        }

        public Message(ByteString bytes) {
            this.bytes = bytes;
        }

        public boolean isText() {
            return null != this.text;
        }

        public byte[] toBytes() {
            if (null != this.text) {
                return this.text.getBytes(org.miaixz.bus.core.lang.Charset.UTF_8);
            }
            if (null != this.bytes) {
                return this.bytes.toByteArray();
            }
            return null;
        }

        public String toString() {
            if (null != this.text) {
                return this.text;
            }
            if (null != this.bytes) {
                return this.bytes.utf8();
            }
            return null;
        }

        public ByteString toByteString() {
            if (null != this.text) {
                return ByteString.encodeUtf8((String)this.text);
            }
            return this.bytes;
        }

        public Reader toCharStream() {
            return new InputStreamReader(this.toByteStream());
        }

        public InputStream toByteStream() {
            if (null != this.text) {
                return new ByteArrayInputStream(this.text.getBytes(org.miaixz.bus.core.lang.Charset.UTF_8));
            }
            if (null != this.bytes) {
                final ByteBuffer buffer = this.bytes.asByteBuffer();
                return new InputStream(this){

                    @Override
                    public int read() {
                        if (buffer.hasRemaining()) {
                            return buffer.get();
                        }
                        return -1;
                    }
                };
            }
            return null;
        }
    }

    public static class Client
    extends CoverHttp<Client> {
        private Register<CoverResult> onOpen;
        private Register<Throwable> onException;
        private Register<Message> onMessage;
        private Register<Close> onClosing;
        private Register<Close> onClosed;
        private boolean openOnIO;
        private boolean exceptionOnIO;
        private boolean messageOnIO;
        private boolean closingOnIO;
        private boolean closedOnIO;
        private int pingSeconds = -1;
        private int pongSeconds = -1;

        public Client(Httpv client, String url) {
            super(client, url);
        }

        public Client heatbeat(int pingSeconds, int pongSeconds) {
            if (pingSeconds < 0 || pongSeconds < 0) {
                throw new IllegalArgumentException("pingSeconds and pongSeconds must be greater than or equal to 0!");
            }
            this.pingSeconds = pingSeconds;
            this.pongSeconds = pongSeconds;
            return this;
        }

        public CoverCall listen() {
            String bodyType = this.getBodyType();
            String msgType = "form".equalsIgnoreCase(bodyType) ? "json" : bodyType;
            CoverCall socket = new CoverCall(this.httpv.executor(), msgType);
            this.registeTagTask(socket);
            this.httpv.preprocess(this, () -> {
                CoverCall coverCall = socket;
                synchronized (coverCall) {
                    if (socket.cancelOrClosed) {
                        this.removeTagTask();
                    } else {
                        Request request = this.prepareRequest("GET");
                        this.httpv.webSocket(request, new Listener(this, socket));
                    }
                }
            }, this.skipPreproc, this.skipSerialPreproc);
            return socket;
        }

        private void execute(Runnable command, boolean onIo) {
            this.httpv.executor().execute(command, onIo);
        }

        public Client setOnOpen(Register<CoverResult> onOpen) {
            this.onOpen = onOpen;
            this.openOnIO = this.nextOnIO;
            this.nextOnIO = false;
            return this;
        }

        public Client setOnException(Register<Throwable> onException) {
            this.onException = onException;
            this.exceptionOnIO = this.nextOnIO;
            this.nextOnIO = false;
            return this;
        }

        public Client setOnMessage(Register<Message> onMessage) {
            this.onMessage = onMessage;
            this.messageOnIO = this.nextOnIO;
            this.nextOnIO = false;
            return this;
        }

        public Client setOnClosing(Register<Close> onClosing) {
            this.onClosing = onClosing;
            this.closingOnIO = this.nextOnIO;
            this.nextOnIO = false;
            return this;
        }

        public Client setOnClosed(Register<Close> onClosed) {
            this.onClosed = onClosed;
            this.closedOnIO = this.nextOnIO;
            this.nextOnIO = false;
            return this;
        }

        public int pingSeconds() {
            return this.pingSeconds;
        }

        public int pongSeconds() {
            return this.pongSeconds;
        }
    }

    public static class Listener
    extends WebSocketListener {
        private final Client client;
        CoverCall webSocket;
        Charset charset;

        public Listener(Client client, CoverCall webSocket) {
            this.client = client;
            this.webSocket = webSocket;
        }

        @Override
        public void onOpen(WebSocket webSocket, Response response) {
            this.charset = this.client.charset(response);
            this.webSocket.setCharset(this.charset);
            this.webSocket.setWebSocket(webSocket);
            CoverTasks.Listener<CoverResult> listener = this.client.httpv.executor().getResponseListener();
            CoverResult.Real result = new CoverResult.Real(this.client, response, this.client.httpv.executor());
            if (null != listener) {
                if (listener.listen(this.client, result) && null != this.client.onOpen) {
                    this.client.execute(() -> this.client.onOpen.on(this.webSocket, result), this.client.openOnIO);
                }
            } else if (null != this.client.onOpen) {
                this.client.execute(() -> this.client.onOpen.on(this.webSocket, result), this.client.openOnIO);
            }
        }

        @Override
        public void onMessage(WebSocket webSocket, String text) {
            if (null != this.client.onMessage) {
                this.client.execute(() -> this.client.onMessage.on(this.webSocket, new Message(text)), this.client.messageOnIO);
            }
        }

        @Override
        public void onMessage(WebSocket webSocket, ByteString bytes) {
            if (null != this.client.onMessage) {
                this.client.execute(() -> this.client.onMessage.on(this.webSocket, new Message(bytes)), this.client.messageOnIO);
            }
        }

        @Override
        public void onClosing(WebSocket webSocket, int code, String reason) {
            if (null != this.client.onClosing) {
                this.client.execute(() -> this.client.onClosing.on(this.webSocket, new Close(code, reason)), this.client.closingOnIO);
            }
        }

        @Override
        public void onClosed(WebSocket webSocket, int code, String reason) {
            this.doOnClose(CoverResult.State.RESPONSED, code, reason);
        }

        private void doOnClose(CoverResult.State state, int code, String reason) {
            CoverTasks.Listener<CoverResult.State> listener = this.client.httpv.executor().getCompleteListener();
            if (null != listener) {
                if (listener.listen(this.client, state) && null != this.client.onClosed) {
                    this.client.execute(() -> this.client.onClosed.on(this.webSocket, this.toClose(state, code, reason)), this.client.closedOnIO);
                }
            } else if (null != this.client.onClosed) {
                this.client.execute(() -> this.client.onClosed.on(this.webSocket, this.toClose(state, code, reason)), this.client.closedOnIO);
            }
        }

        private Close toClose(CoverResult.State state, int code, String reason) {
            if (state == CoverResult.State.CANCELED) {
                return new Close(0, "Canceled");
            }
            if (state == CoverResult.State.EXCEPTION) {
                return new Close(-1, reason);
            }
            if (state == CoverResult.State.NETWORK_ERROR) {
                return new Close(-2, reason);
            }
            if (state == CoverResult.State.TIMEOUT) {
                return new Close(-3, reason);
            }
            return new Close(code, reason);
        }

        @Override
        public void onFailure(WebSocket webSocket, Throwable t, Response response) {
            IOException e = t instanceof IOException ? (IOException)t : new IOException(t.getMessage(), t);
            this.doOnClose(this.client.toState(e), 0, t.getMessage());
            CoverTasks.Listener<IOException> listener = this.client.httpv.executor().getExceptionListener();
            if (null != listener) {
                if (listener.listen(this.client, e) && null != this.client.onException) {
                    this.client.execute(() -> this.client.onException.on(this.webSocket, t), this.client.exceptionOnIO);
                }
            } else if (null != this.client.onException) {
                this.client.execute(() -> this.client.onException.on(this.webSocket, t), this.client.exceptionOnIO);
            } else if (!this.client.nothrow) {
                throw new InternalException("WebSocket exception", t);
            }
        }
    }

    public static class Close {
        public static final int CANCELED = 0;
        public static final int EXCEPTION = -1;
        public static final int NETWORK_ERROR = -2;
        public static final int TIMEOUT = -3;
        private final int code;
        private final String reason;

        public Close(int code, String reason) {
            this.code = code;
            this.reason = reason;
        }

        public int getCode() {
            return this.code;
        }

        public String getReason() {
            return this.reason;
        }

        public boolean isCanceled() {
            return this.code == 0;
        }

        public boolean isException() {
            return this.code == -1;
        }

        public boolean isNetworkError() {
            return this.code == -2;
        }

        public boolean isTimeout() {
            return this.code == -3;
        }

        public String toString() {
            return "Close [code=" + this.code + ", reason=" + this.reason + "]";
        }
    }

    public static interface Register<T> {
        public void on(CoverCall var1, T var2);
    }
}

