/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.plugin.httpv;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.miaixz.bus.core.lang.MediaType;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.net.HTTP;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.http.Callback;
import org.miaixz.bus.http.Httpv;
import org.miaixz.bus.http.NewCall;
import org.miaixz.bus.http.Request;
import org.miaixz.bus.http.Response;
import org.miaixz.bus.http.bodys.FormBody;
import org.miaixz.bus.http.bodys.MultipartBody;
import org.miaixz.bus.http.bodys.RequestBody;
import org.miaixz.bus.http.bodys.ResponseBody;
import org.miaixz.bus.http.plugin.httpv.Cancelable;
import org.miaixz.bus.http.plugin.httpv.CoverResult;
import org.miaixz.bus.http.plugin.httpv.CoverTasks;
import org.miaixz.bus.http.plugin.httpv.GiveCall;
import org.miaixz.bus.http.plugin.httpv.Progress;
import org.miaixz.bus.http.plugin.httpv.ProgressBody;

public abstract class CoverHttp<C extends CoverHttp<?>>
implements Cancelable {
    private static final String PATH_PARAM_REGEX = "[A-Za-z0-9_\\-/]*\\{[A-Za-z0-9_\\-]+\\}[A-Za-z0-9_\\-/]*";
    public Httpv httpv;
    public boolean nothrow;
    public boolean nextOnIO = false;
    public boolean skipPreproc = false;
    public boolean skipSerialPreproc = false;
    private String urlPath;
    private String tag;
    private Map<String, String> headers;
    private Map<String, String> pathParams;
    private Map<String, String> urlParams;
    private Map<String, String> bodyParams;
    private Map<String, FilePara> files;
    private Object requestBody;
    private String dateFormat;
    private String bodyType;
    private Callback<Progress> onProcess;
    private boolean processOnIO;
    private long stepBytes = 0L;
    private double stepRate = -1.0;
    private Object object;
    private Httpv.TagTask tagTask;
    private Cancelable canceler;
    private Charset charset;

    public CoverHttp(Httpv httpv, String url) {
        this.urlPath = url;
        this.httpv = httpv;
        this.charset = httpv.charset();
        this.bodyType = httpv.bodyType();
    }

    public String getUrl() {
        return this.urlPath;
    }

    public String getTag() {
        return this.tag;
    }

    public String getBodyType() {
        return this.bodyType;
    }

    public boolean isTagged(String tag) {
        if (null != this.tag && null != tag) {
            return this.tag.contains(tag);
        }
        return false;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Object getBound() {
        return this.object;
    }

    public C nothrow() {
        this.nothrow = true;
        return (C)this;
    }

    public C skipPreproc() {
        this.skipPreproc = true;
        return (C)this;
    }

    public C skipSerialPreproc() {
        this.skipSerialPreproc = true;
        return (C)this;
    }

    public C tag(String tag) {
        if (null != tag) {
            this.tag = null != this.tag ? this.tag + "." + tag : tag;
            this.updateTagTask();
        }
        return (C)this;
    }

    public C charset(Charset charset) {
        if (null != charset) {
            this.charset = charset;
        }
        return (C)this;
    }

    public C bodyType(String type) {
        if (null != type) {
            this.bodyType = type;
        }
        return (C)this;
    }

    public C nextOnIO() {
        this.nextOnIO = true;
        return (C)this;
    }

    public C bind(Object object) {
        this.object = object;
        return (C)this;
    }

    public C addHeader(String name, String value) {
        if (null != name && null != value) {
            if (null == this.headers) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put(name, value);
        }
        return (C)this;
    }

    public C addHeader(Map<String, String> headers) {
        if (null != headers) {
            if (null == this.headers) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.putAll(headers);
        }
        return (C)this;
    }

    public C setRange(long rangeStart) {
        return this.addHeader("Range", "bytes=" + rangeStart + "-");
    }

    public C setRange(long rangeStart, long rangeEnd) {
        return this.addHeader("Range", "bytes=" + rangeStart + "-" + rangeEnd);
    }

    public C setOnProcess(Callback<Progress> onProcess) {
        this.onProcess = onProcess;
        this.processOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return (C)this;
    }

    public C stepBytes(long stepBytes) {
        this.stepBytes = stepBytes;
        return (C)this;
    }

    public C stepRate(double stepRate) {
        this.stepRate = stepRate;
        return (C)this;
    }

    public C addPathPara(String name, Object value) {
        if (null != name && null != value) {
            if (null == this.pathParams) {
                this.pathParams = new HashMap<String, String>();
            }
            this.pathParams.put(name, value.toString());
        }
        return (C)this;
    }

    public C addPathPara(Map<String, ?> params) {
        if (null == this.pathParams) {
            this.pathParams = new HashMap<String, String>();
        }
        this.doAddParams(this.pathParams, params);
        return (C)this;
    }

    public C addUrlPara(String name, Object value) {
        if (null != name && null != value) {
            if (null == this.urlParams) {
                this.urlParams = new HashMap<String, String>();
            }
            this.urlParams.put(name, value.toString());
        }
        return (C)this;
    }

    public C addUrlPara(Map<String, ?> params) {
        if (null == this.urlParams) {
            this.urlParams = new HashMap<String, String>();
        }
        this.doAddParams(this.urlParams, params);
        return (C)this;
    }

    public C addBodyPara(String name, Object value) {
        if (null != name && null != value) {
            if (null == this.bodyParams) {
                this.bodyParams = new HashMap<String, String>();
            }
            this.bodyParams.put(name, value.toString());
        }
        return (C)this;
    }

    public C addBodyPara(Map<String, ?> params) {
        if (null == this.bodyParams) {
            this.bodyParams = new HashMap<String, String>();
        }
        this.doAddParams(this.bodyParams, params);
        return (C)this;
    }

    private void doAddParams(Map<String, String> taskParams, Map<String, ?> params) {
        if (null != params) {
            for (String name : params.keySet()) {
                Object value = params.get(name);
                if (null == name || null == value) continue;
                taskParams.put(name, value.toString());
            }
        }
    }

    public C setBodyPara(Object body) {
        this.requestBody = body;
        return (C)this;
    }

    public C addFilePara(String name, String filePath) {
        return this.addFilePara(name, new File(filePath));
    }

    public C addFilePara(String name, File file) {
        if (null != name && null != file && file.exists()) {
            String fileName = file.getName();
            String type = fileName.substring(fileName.lastIndexOf(".") + 1);
            if (null == this.files) {
                this.files = new HashMap<String, FilePara>();
            }
            this.files.put(name, new FilePara(type, fileName, file));
        }
        return (C)this;
    }

    public C addFilePara(String name, String type, byte[] content) {
        return this.addFilePara(name, type, null, content);
    }

    public C addFilePara(String name, String type, String fileName, byte[] content) {
        if (null != name && null != content) {
            if (null == this.files) {
                this.files = new HashMap<String, FilePara>();
            }
            this.files.put(name, new FilePara(type, fileName, content));
        }
        return (C)this;
    }

    @Override
    public boolean cancel() {
        if (null != this.canceler) {
            return this.canceler.cancel();
        }
        return false;
    }

    protected void registeTagTask(Cancelable canceler) {
        if (null != this.tag && null == this.tagTask) {
            this.tagTask = this.httpv.addTagTask(this.tag, canceler, this);
        }
        this.canceler = canceler;
    }

    private void updateTagTask() {
        if (null != this.tagTask) {
            this.tagTask.setTag(this.tag);
        } else if (null != this.canceler) {
            this.registeTagTask(this.canceler);
        }
    }

    protected void removeTagTask() {
        if (null != this.tag) {
            this.httpv.removeTagTask(this);
        }
    }

    protected NewCall prepareCall(String method) {
        Request request = this.prepareRequest(method);
        return this.httpv.request(request);
    }

    protected Request prepareRequest(String method) {
        boolean bodyCanUsed = HTTP.permitsRequestBody((String)method);
        this.assertNotConflict(!bodyCanUsed);
        Request.Builder builder = new Request.Builder().url(this.buildUrlPath());
        this.buildHeaders(builder);
        if (bodyCanUsed) {
            RequestBody reqBody = this.buildRequestBody();
            if (null != this.onProcess) {
                long contentLength = this.contentLength(reqBody);
                if (this.stepRate > 0.0 && this.stepRate <= 1.0) {
                    this.stepBytes = (long)((double)contentLength * this.stepRate);
                }
                if (this.stepBytes <= 0L) {
                    this.stepBytes = 8192L;
                }
                reqBody = new ProgressBody(reqBody, this.onProcess, this.httpv.executor().getExecutor(this.processOnIO), contentLength, this.stepBytes);
            }
            builder.method(method, reqBody);
        } else {
            builder.method(method, null);
        }
        if (null != this.tag) {
            builder.tag(String.class, this.tag);
        }
        return builder.build();
    }

    private long contentLength(RequestBody reqBody) {
        try {
            return reqBody.contentLength();
        }
        catch (IOException e) {
            throw new InternalException("Cannot get the length of the request body", (Throwable)e);
        }
    }

    private void buildHeaders(Request.Builder builder) {
        if (null != this.headers) {
            for (String name : this.headers.keySet()) {
                String value = this.headers.get(name);
                if (null == value) continue;
                builder.addHeader(name, value);
            }
        }
    }

    public CoverResult.State toState(IOException e) {
        if (e instanceof SocketTimeoutException) {
            return CoverResult.State.TIMEOUT;
        }
        if (e instanceof UnknownHostException || e instanceof ConnectException) {
            return CoverResult.State.NETWORK_ERROR;
        }
        String msg = e.getMessage();
        if (null != msg && ("Canceled".equals(msg) || e instanceof SocketException && (msg.startsWith("Socket operation on nonsocket") || "Socket closed".equals(msg)))) {
            return CoverResult.State.CANCELED;
        }
        return CoverResult.State.EXCEPTION;
    }

    private RequestBody buildRequestBody() {
        if (null != this.files) {
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
            if (null != this.bodyParams) {
                for (String name : this.bodyParams.keySet()) {
                    byte[] value = this.bodyParams.get(name).getBytes(this.charset);
                    RequestBody body = RequestBody.create(null, value);
                    builder.addPart(MultipartBody.Part.createFormData(name, null, body));
                }
            }
            for (String name : this.files.keySet()) {
                FilePara file = this.files.get(name);
                MediaType type = this.httpv.contentType(file.type);
                RequestBody bodyPart = null != file.file ? RequestBody.create(type, file.file) : RequestBody.create(type, file.content);
                builder.addFormDataPart(name, file.fileName, bodyPart);
            }
            return builder.build();
        }
        if (null != this.requestBody) {
            return this.toRequestBody(this.requestBody);
        }
        if (null == this.bodyParams) {
            return new FormBody.Builder(this.charset).build();
        }
        if ("form".equalsIgnoreCase(this.bodyType)) {
            FormBody.Builder builder = new FormBody.Builder(this.charset);
            for (String name : this.bodyParams.keySet()) {
                String value = this.bodyParams.get(name);
                builder.add(name, value);
            }
            return builder.build();
        }
        return this.toRequestBody(this.bodyParams);
    }

    private RequestBody toRequestBody(Object object) {
        if (object instanceof byte[] || object instanceof String) {
            byte[] body = object instanceof byte[] ? (byte[])object : ((String)object).getBytes(this.charset);
            return RequestBody.create(MediaType.valueOf((String)(this.httpv.executor().doMsgConvert((String)this.bodyType, null).contentType + "; charset=" + this.charset.name())), body);
        }
        CoverTasks.Executor.Data<byte[]> data = this.httpv.executor().doMsgConvert(this.bodyType, c -> c.serialize(object, this.dateFormat, this.charset));
        return RequestBody.create(MediaType.valueOf((String)(data.contentType + "; charset=" + this.charset.name())), (byte[])data.data);
    }

    private String buildUrlPath() {
        String url = this.urlPath;
        if (null == url || url.trim().isEmpty()) {
            throw new InternalException("Url cannot be empty!");
        }
        if (null != this.pathParams) {
            for (String name : this.pathParams.keySet()) {
                String target = "{" + name + "}";
                if (url.contains(target)) {
                    url = url.replace(target, this.pathParams.get(name));
                    continue;
                }
                throw new InternalException("pathParameter [ " + name + " ] Does not exist in url [ " + this.urlPath + " ]");
            }
        }
        if (url.matches(PATH_PARAM_REGEX)) {
            throw new InternalException("There is no setting for pathParameter in url, you must first call addPathParam to set it!");
        }
        if (null != this.urlParams) {
            url = this.buildUrl(url.trim());
        }
        return url;
    }

    private String buildUrl(String url) {
        StringBuilder sb = new StringBuilder(url);
        if (url.contains("?")) {
            if (!url.endsWith("?")) {
                if (url.lastIndexOf("=") < url.lastIndexOf("?") + 2) {
                    throw new InternalException("URL format error, '?' Not found after '='");
                }
                if (!url.endsWith("&")) {
                    sb.append('&');
                }
            }
        } else {
            sb.append('?');
        }
        for (String name : this.urlParams.keySet()) {
            sb.append(name).append('=').append(this.urlParams.get(name)).append('&');
        }
        sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }

    protected void assertNotConflict(boolean bodyCantUsed) {
        if (bodyCantUsed) {
            if (ObjectKit.isNotEmpty((Object)this.requestBody)) {
                throw new InternalException("GET | HEAD request The setBodyPara method cannot be called!");
            }
            if (MapKit.isNotEmpty(this.bodyParams)) {
                throw new InternalException("GET | HEAD request The addBodyPara method cannot be called!");
            }
            if (MapKit.isNotEmpty(this.files)) {
                throw new InternalException("GET | HEAD request The addFilePara method cannot be called!");
            }
        }
        if (ObjectKit.isNotEmpty((Object)this.requestBody)) {
            if (MapKit.isNotEmpty(this.bodyParams)) {
                throw new InternalException("The methods addBodyPara and setBodyPara cannot be called at the same time!");
            }
            if (MapKit.isNotEmpty(this.files)) {
                throw new InternalException("The methods addFilePara and setBodyPara cannot be called at the same time!");
            }
        }
    }

    protected boolean timeoutAwait(CountDownLatch latch) {
        try {
            return latch.await(this.httpv.preprocTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InternalException("TimeOut " + String.valueOf((Object)CoverResult.State.TIMEOUT), (Throwable)e);
        }
    }

    protected CoverResult timeoutResult() {
        if (this.nothrow) {
            return new CoverResult.Real(this, CoverResult.State.TIMEOUT);
        }
        throw new InternalException("Execution timeout " + String.valueOf((Object)CoverResult.State.TIMEOUT));
    }

    public Charset charset(Response response) {
        ResponseBody b = response.body();
        MediaType contentType = null != b ? b.contentType() : null;
        return null != contentType ? contentType.charset(this.charset) : this.charset;
    }

    static class FilePara {
        String type;
        String fileName;
        byte[] content;
        File file;

        FilePara(String type, String fileName, byte[] content) {
            this.type = type;
            this.fileName = fileName;
            this.content = content;
        }

        FilePara(String type, String fileName, File file) {
            this.type = type;
            this.fileName = fileName;
            this.file = file;
        }
    }

    public static class Async
    extends CoverHttp<Async> {
        private Callback<CoverResult> onResponse;
        private Callback<IOException> onException;
        private Callback<CoverResult.State> onComplete;
        private boolean rOnIO;
        private boolean eOnIO;
        private boolean cOnIO;

        public Async(Httpv htttpv, String url) {
            super(htttpv, url);
        }

        public Async setOnException(Callback<IOException> onException) {
            this.onException = onException;
            this.eOnIO = this.nextOnIO;
            this.nextOnIO = false;
            return this;
        }

        public Async setOnComplete(Callback<CoverResult.State> onComplete) {
            this.onComplete = onComplete;
            this.cOnIO = this.nextOnIO;
            this.nextOnIO = false;
            return this;
        }

        public Async setOnResponse(Callback<CoverResult> onResponse) {
            this.onResponse = onResponse;
            this.rOnIO = this.nextOnIO;
            this.nextOnIO = false;
            return this;
        }

        public GiveCall get() {
            return this.request("GET");
        }

        public GiveCall head() {
            return this.request("HEAD");
        }

        public GiveCall post() {
            return this.request("POST");
        }

        public GiveCall put() {
            return this.request("PUT");
        }

        public GiveCall patch() {
            return this.request("PATCH");
        }

        public GiveCall delete() {
            return this.request("DELETE");
        }

        public GiveCall request(String method) {
            if (null == method || method.isEmpty()) {
                throw new IllegalArgumentException("Request method method cannot be empty!");
            }
            PreGiveCall call = new PreGiveCall();
            this.registeTagTask(call);
            this.httpv.preprocess(this, () -> {
                PreGiveCall preGiveCall = call;
                synchronized (preGiveCall) {
                    if (call.canceled) {
                        this.removeTagTask();
                    } else {
                        call.setCall(this.executeCall(this.prepareCall(method)));
                    }
                }
            }, this.skipPreproc, this.skipSerialPreproc);
            return call;
        }

        private GiveCall executeCall(NewCall call) {
            final OkGiveCall httpCall = new OkGiveCall(call);
            call.enqueue(new Callback<Response>(){

                @Override
                public void onFailure(NewCall call, IOException error) {
                    CoverResult.State state = this.toState(error);
                    CoverResult.Real result = new CoverResult.Real(this, state, error);
                    this.onCallback(httpCall, result, () -> {
                        CoverTasks.Executor executor = httpv.executor();
                        executor.executeOnComplete(this, onComplete, state, cOnIO);
                        if (!executor.executeOnException(this, onException, error, eOnIO) && !nothrow) {
                            throw new InternalException(error.getMessage(), (Throwable)error);
                        }
                    });
                }

                @Override
                public void onResponse(NewCall call, Response response) {
                    CoverTasks.Executor executor = httpv.executor();
                    CoverResult.Real result = new CoverResult.Real(this, response, executor);
                    this.onCallback(httpCall, result, () -> {
                        executor.executeOnComplete(this, onComplete, CoverResult.State.RESPONSED, cOnIO);
                        executor.executeOnResponse(this, onResponse, result, rOnIO);
                    });
                }
            });
            return httpCall;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onCallback(OkGiveCall httpCall, CoverResult result, Runnable runnable) {
            OkGiveCall okGiveCall = httpCall;
            synchronized (okGiveCall) {
                this.removeTagTask();
                if (httpCall.isCanceled() || result.getState() == CoverResult.State.CANCELED) {
                    httpCall.setResult(new CoverResult.Real(this, CoverResult.State.CANCELED));
                    return;
                }
                httpCall.setResult(result);
                runnable.run();
            }
        }

        class PreGiveCall
        implements GiveCall {
            GiveCall call;
            boolean canceled = false;
            CountDownLatch latch = new CountDownLatch(1);

            PreGiveCall() {
            }

            @Override
            public synchronized boolean cancel() {
                this.canceled = null == this.call || this.call.cancel();
                this.latch.countDown();
                return this.canceled;
            }

            @Override
            public boolean isDone() {
                if (null != this.call) {
                    return this.call.isDone();
                }
                return this.canceled;
            }

            @Override
            public boolean isCanceled() {
                return this.canceled;
            }

            void setCall(GiveCall call) {
                this.call = call;
                this.latch.countDown();
            }

            @Override
            public CoverResult getResult() {
                if (!Async.this.timeoutAwait(this.latch)) {
                    this.cancel();
                    return Async.this.timeoutResult();
                }
                if (this.canceled || null == this.call) {
                    return new CoverResult.Real(Async.this, CoverResult.State.CANCELED);
                }
                return this.call.getResult();
            }
        }

        class OkGiveCall
        implements GiveCall {
            NewCall call;
            CoverResult result;
            CountDownLatch latch = new CountDownLatch(1);

            OkGiveCall(NewCall call) {
                this.call = call;
            }

            @Override
            public synchronized boolean cancel() {
                if (null == this.result) {
                    this.call.cancel();
                    return true;
                }
                return false;
            }

            @Override
            public boolean isDone() {
                return null != this.result;
            }

            @Override
            public boolean isCanceled() {
                return this.call.isCanceled();
            }

            @Override
            public CoverResult getResult() {
                if (null == this.result && !Async.this.timeoutAwait(this.latch)) {
                    this.cancel();
                    return Async.this.timeoutResult();
                }
                return this.result;
            }

            void setResult(CoverResult result) {
                this.result = result;
                this.latch.countDown();
            }
        }
    }

    public static class Sync
    extends CoverHttp<Sync> {
        public Sync(Httpv client, String url) {
            super(client, url);
        }

        public CoverResult get() {
            return this.request("GET");
        }

        public CoverResult head() {
            return this.request("HEAD");
        }

        public CoverResult post() {
            return this.request("POST");
        }

        public CoverResult put() {
            return this.request("PUT");
        }

        public CoverResult patch() {
            return this.request("PATCH");
        }

        public CoverResult delete() {
            return this.request("DELETE");
        }

        public CoverResult request(String method) {
            if (null == method || method.isEmpty()) {
                throw new IllegalArgumentException("Request method method cannot be empty!");
            }
            CoverResult.Real result = new CoverResult.Real(this, this.httpv.executor());
            SyncHttpCall httpCall = new SyncHttpCall();
            this.registeTagTask(httpCall);
            CountDownLatch latch = new CountDownLatch(1);
            this.httpv.preprocess(this, () -> {
                SyncHttpCall syncHttpCall = httpCall;
                synchronized (syncHttpCall) {
                    if (httpCall.canceled) {
                        result.exception(CoverResult.State.CANCELED, null);
                        latch.countDown();
                        return;
                    }
                    httpCall.call = this.prepareCall(method);
                }
                try {
                    result.response(httpCall.call.execute());
                    httpCall.done = true;
                }
                catch (IOException e) {
                    result.exception(this.toState(e), e);
                }
                finally {
                    latch.countDown();
                }
            }, this.skipPreproc, this.skipSerialPreproc);
            boolean timeout = false;
            if (null == result.getState()) {
                timeout = !this.timeoutAwait(latch);
            }
            this.removeTagTask();
            if (timeout) {
                httpCall.cancel();
                return this.timeoutResult();
            }
            IOException e = result.getError();
            CoverResult.State state = result.getState();
            if (null != e && state != CoverResult.State.CANCELED && !this.nothrow) {
                throw new InternalException("Abnormal execution", (Throwable)e);
            }
            return result;
        }

        static class SyncHttpCall
        implements Cancelable {
            NewCall call;
            boolean done = false;
            boolean canceled = false;

            SyncHttpCall() {
            }

            @Override
            public synchronized boolean cancel() {
                if (this.done) {
                    return false;
                }
                if (null != this.call) {
                    this.call.cancel();
                }
                this.canceled = true;
                return true;
            }
        }
    }
}

