/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.plugin.httpv;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.List;
import org.miaixz.bus.core.io.ByteString;
import org.miaixz.bus.core.io.buffer.Buffer;
import org.miaixz.bus.core.lang.MediaType;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.http.Callback;
import org.miaixz.bus.http.Response;
import org.miaixz.bus.http.bodys.ResponseBody;
import org.miaixz.bus.http.plugin.httpv.CoverArray;
import org.miaixz.bus.http.plugin.httpv.CoverHttp;
import org.miaixz.bus.http.plugin.httpv.CoverResult;
import org.miaixz.bus.http.plugin.httpv.CoverTasks;
import org.miaixz.bus.http.plugin.httpv.CoverWapper;
import org.miaixz.bus.http.plugin.httpv.Downloads;
import org.miaixz.bus.http.plugin.httpv.Progress;
import org.miaixz.bus.http.plugin.httpv.ProgressStream;

public class ResultBody
implements CoverResult.Body {
    private final Response response;
    protected CoverTasks.Executor executor;
    protected Charset charset;
    private boolean onIO = false;
    private Callback<Progress> onProcess;
    private long stepBytes = 0L;
    private double stepRate = -1.0;
    private boolean rangeIgnored = false;
    private CoverHttp<?> coverHttp;
    private boolean cached = false;
    private byte[] data;

    public ResultBody(CoverHttp<?> coverHttp, Response response, CoverTasks.Executor executor) {
        this.executor = executor;
        this.charset = coverHttp.charset(response);
        this.coverHttp = coverHttp;
        this.response = response;
    }

    @Override
    public CoverWapper toWapper() {
        if (null == this.executor) {
            throw new IllegalStateException("Task executor is null!");
        }
        return this.executor.doMsgConvert(c -> c.toMapper(this.toByteStream(), this.charset));
    }

    @Override
    public CoverArray toArray() {
        if (null == this.executor) {
            throw new IllegalStateException("Task executor is null!");
        }
        return this.executor.doMsgConvert(c -> c.toArray(this.toByteStream(), this.charset));
    }

    @Override
    public <T> T toBean(Class<T> type) {
        if (null == this.executor) {
            throw new IllegalStateException("Task executor is null!");
        }
        return (T)this.executor.doMsgConvert(c -> c.toBean(type, this.toByteStream(), this.charset));
    }

    @Override
    public <T> List<T> toList(Class<T> type) {
        if (null == this.executor) {
            throw new IllegalStateException("Task executor is null!");
        }
        return this.executor.doMsgConvert(c -> c.toList(type, this.toByteStream(), this.charset));
    }

    @Override
    public MediaType getType() {
        ResponseBody body = this.response.body();
        if (null != body) {
            return body.contentType();
        }
        return null;
    }

    @Override
    public long getLength() {
        ResponseBody body = this.response.body();
        if (null != body) {
            return body.contentLength();
        }
        return 0L;
    }

    @Override
    public CoverResult.Body nextOnIO() {
        this.onIO = true;
        return this;
    }

    @Override
    public CoverResult.Body setOnProcess(Callback<Progress> onProcess) {
        if (null == this.executor) {
            throw new IllegalStateException("Task executor is null!");
        }
        if (this.cached) {
            throw new IllegalStateException("After the cache is turned on, you cannot set a download progress callback!");
        }
        this.onProcess = onProcess;
        return this;
    }

    @Override
    public CoverResult.Body stepBytes(long stepBytes) {
        this.stepBytes = stepBytes;
        return this;
    }

    @Override
    public CoverResult.Body stepRate(double stepRate) {
        this.stepRate = stepRate;
        return this;
    }

    @Override
    public CoverResult.Body setRangeIgnored() {
        this.rangeIgnored = true;
        return this;
    }

    @Override
    public InputStream toByteStream() {
        ResponseBody body;
        InputStream input = this.cached ? new ByteArrayInputStream(this.cacheBytes()) : (null != (body = this.response.body()) ? body.byteStream() : new ByteArrayInputStream(new byte[0]));
        if (null != this.onProcess) {
            long rangeStart = this.getRangeStart();
            long totalBytes = this.getLength();
            if (!this.rangeIgnored) {
                totalBytes += rangeStart;
            }
            if (this.stepRate > 0.0 && this.stepRate <= 1.0) {
                this.stepBytes = (long)((double)totalBytes * this.stepRate);
            }
            if (this.stepBytes <= 0L) {
                this.stepBytes = 8192L;
            }
            return new ProgressStream(input, this.onProcess, totalBytes, this.stepBytes, this.rangeIgnored ? 0L : rangeStart, this.executor.getExecutor(this.onIO));
        }
        return input;
    }

    @Override
    public byte[] toBytes() {
        if (this.cached) {
            return this.cacheBytes();
        }
        return this.bodyToBytes();
    }

    @Override
    public Reader toCharStream() {
        if (this.cached || null != this.onProcess) {
            return new InputStreamReader(this.toByteStream());
        }
        ResponseBody body = this.response.body();
        if (null != body) {
            return body.charStream();
        }
        return new CharArrayReader(new char[0]);
    }

    @Override
    public String toString() {
        if (this.cached || null != this.onProcess) {
            return new String(this.toBytes(), this.charset);
        }
        try {
            ResponseBody body = this.response.body();
            if (null != body) {
                return new String(body.bytes(), this.charset);
            }
        }
        catch (IOException e) {
            throw new InternalException("Error in converting the body of the message!", (Throwable)e);
        }
        return null;
    }

    @Override
    public ByteString toByteString() {
        return ByteString.of((byte[])this.toBytes());
    }

    @Override
    public Downloads toFile(String filePath) {
        return this.toFile(new File(filePath));
    }

    @Override
    public Downloads toFile(File file) {
        if (null == this.executor) {
            throw new IllegalStateException("Task executor is null!");
        }
        if (!file.exists()) {
            try {
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                file.createNewFile();
            }
            catch (IOException e) {
                this.response.close();
                throw new InternalException("Cannot create file [" + file.getAbsolutePath() + "]", (Throwable)e);
            }
        }
        return this.executor.download(this.coverHttp, file, this.toByteStream(), this.getRangeStart());
    }

    @Override
    public Downloads toFolder(String dirPath) {
        String fileName = this.resolveFileName();
        String filePath = this.resolveFilePath(dirPath, fileName);
        int index = 0;
        File file = new File(filePath);
        while (file.exists()) {
            String indexFileName = this.indexFileName(fileName, index++);
            filePath = this.resolveFilePath(dirPath, indexFileName);
            file = new File(filePath);
        }
        return this.toFile(file);
    }

    @Override
    public Downloads toFolder(File dir) {
        if (dir.exists() && !dir.isDirectory()) {
            this.response.close();
            throw new InternalException("File download failed\uff1a[" + dir.getAbsolutePath() + "] Already exists and is not a directory !");
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return this.toFolder(dir.getAbsolutePath());
    }

    @Override
    public CoverResult.Body cache() {
        if (null != this.onProcess) {
            throw new IllegalStateException("Cannot set a download progress callback after enabling cache!");
        }
        this.cached = true;
        return this;
    }

    @Override
    public CoverResult.Body close() {
        this.response.close();
        this.data = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] cacheBytes() {
        Response response = this.response;
        synchronized (response) {
            if (null == this.data) {
                this.data = this.bodyToBytes();
            }
        }
        return this.data;
    }

    private byte[] bodyToBytes() {
        if (null != this.onProcess) {
            try {
                byte[] byArray;
                Buffer buffer = new Buffer();
                try {
                    byArray = buffer.readFrom(this.toByteStream()).readByteArray();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            buffer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new InternalException("Error in converting byte array of message body!", (Throwable)e);
                    }
                }
                buffer.close();
                return byArray;
            }
            finally {
                this.response.close();
            }
        }
        ResponseBody body = this.response.body();
        if (null != body) {
            try {
                return body.bytes();
            }
            catch (IOException e) {
                throw new InternalException("Error in converting byte array of message body!", (Throwable)e);
            }
        }
        return new byte[0];
    }

    private long getRangeStart() {
        int index;
        long rangeStart = 0L;
        if (this.response.code() != 206) {
            return rangeStart;
        }
        String range = this.response.header("Content-Range");
        if (null != range && range.startsWith("bytes") && (index = range.indexOf(45)) > 5) {
            String start = range.substring(5, index).trim();
            try {
                rangeStart = Long.parseLong(start);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rangeStart;
    }

    private String resolveFilePath(String dirPath, String fileName) {
        if (dirPath.endsWith("\\") || dirPath.endsWith("/")) {
            return dirPath + fileName;
        }
        return dirPath + File.separator + fileName;
    }

    private String indexFileName(String fileName, int index) {
        int i = fileName.lastIndexOf(46);
        if (i < 0) {
            return fileName + "(" + index + ")";
        }
        String ext = fileName.substring(i);
        if (i > 0) {
            String name = fileName.substring(0, i);
            return name + "(" + index + ")" + ext;
        }
        return "(" + index + ")" + ext;
    }

    private String resolveFileName() {
        String fileName = this.response.header("Content-Disposition");
        if (null == fileName || fileName.length() < 1) {
            fileName = this.response.request().url().encodedPath();
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        } else {
            try {
                fileName = URLDecoder.decode(fileName.substring(fileName.indexOf("filename=") + 9), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalException("Failed to decode file name", (Throwable)e);
            }
            fileName = fileName.replaceAll("\"", "");
        }
        return fileName;
    }
}

