/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.plugin.httpz;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.http.Callback;
import org.miaixz.bus.http.NewCall;
import org.miaixz.bus.http.Response;
import org.miaixz.bus.logger.Logger;

public abstract class FileCallback
implements Callback {
    private final String fileAbsolutePath;

    public FileCallback() {
        this.fileAbsolutePath = null;
    }

    public FileCallback(String fileAbsolutePath) {
        this.fileAbsolutePath = fileAbsolutePath;
    }

    @Override
    public void onResponse(NewCall call, Response response, String id) {
        block13: {
            try {
                if (this.fileAbsolutePath != null && !this.fileAbsolutePath.isEmpty()) {
                    File file = new File(this.fileAbsolutePath);
                    try (FileOutputStream fos = new FileOutputStream(file);
                         ByteArrayInputStream bis = new ByteArrayInputStream(response.body().bytes());){
                        IoKit.copy((InputStream)bis, (OutputStream)fos);
                        this.onSuccess(call, file, id);
                        break block13;
                    }
                }
                this.onSuccess(call, response.body().byteStream(), id);
            }
            catch (IOException e) {
                Logger.error((String)e.getMessage(), (Object[])new Object[]{e});
            }
        }
    }

    public void onSuccess(NewCall call, File file, String id) {
    }

    public void onSuccess(NewCall call, InputStream fileStream, String id) {
    }
}

