/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.plugin.httpz;

import java.io.IOException;
import org.miaixz.bus.core.io.buffer.Buffer;
import org.miaixz.bus.core.io.source.AssignSource;
import org.miaixz.bus.core.io.source.BufferSource;
import org.miaixz.bus.core.io.source.Source;
import org.miaixz.bus.core.lang.MediaType;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.http.Response;
import org.miaixz.bus.http.bodys.ResponseBody;
import org.miaixz.bus.http.metric.Interceptor;
import org.miaixz.bus.http.metric.NewChain;
import org.miaixz.bus.http.plugin.httpz.ProgressListener;

public abstract class FileInterceptor
implements Interceptor,
ProgressListener {
    @Override
    public Response intercept(NewChain chain) throws IOException {
        Response rsp = chain.proceed(chain.request());
        return rsp.newBuilder().body(new DownloadFileProgressResponseBody(rsp.body(), this)).build();
    }

    @Override
    public abstract void updateProgress(long var1, long var3, boolean var5);

    public static class DownloadFileProgressResponseBody
    extends ResponseBody {
        private final ResponseBody body;
        private final ProgressListener progressListener;
        private BufferSource bufferSource;

        public DownloadFileProgressResponseBody(ResponseBody body, ProgressListener progressListener) {
            this.body = body;
            this.progressListener = progressListener;
        }

        @Override
        public MediaType contentType() {
            return this.body.contentType();
        }

        @Override
        public long contentLength() {
            return this.body.contentLength();
        }

        @Override
        public BufferSource source() {
            if (null == this.bufferSource) {
                this.bufferSource = IoKit.buffer((Source)this.source((Source)this.body.source()));
            }
            return this.bufferSource;
        }

        private Source source(Source source) {
            return new AssignSource(source){
                long downloadLenth;
                {
                    super(delegate);
                    this.downloadLenth = 0L;
                }

                public long read(Buffer sink, long byteCount) throws IOException {
                    boolean isFinish;
                    long bytesRead = super.read(sink, byteCount);
                    boolean bl = isFinish = bytesRead == -1L;
                    if (!isFinish) {
                        this.downloadLenth += bytesRead;
                    }
                    progressListener.updateProgress(this.downloadLenth, body.contentLength(), isFinish);
                    return bytesRead;
                }
            };
        }
    }
}

