/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.plugin.httpz;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.core.io.sink.BufferSink;
import org.miaixz.bus.core.io.source.Source;
import org.miaixz.bus.core.lang.MediaType;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.http.Callback;
import org.miaixz.bus.http.Headers;
import org.miaixz.bus.http.Httpd;
import org.miaixz.bus.http.Request;
import org.miaixz.bus.http.bodys.MultipartBody;
import org.miaixz.bus.http.bodys.RequestBody;
import org.miaixz.bus.http.plugin.httpz.MultipartFile;
import org.miaixz.bus.http.plugin.httpz.RequestCall;

public abstract class HttpRequest {
    protected String id;
    protected String url;
    protected String body;
    protected Map<String, String> params;
    protected Map<String, String> encodedParams;
    protected Map<String, String> headers;
    protected MultipartBody multipartBody;
    protected List<MultipartFile> list;
    protected Request.Builder builder = new Request.Builder();

    protected HttpRequest(String url, Object tag, Map<String, String> params, Map<String, String> headers, List<MultipartFile> list, String body, MultipartBody multipartBody, String id) {
        this(url, tag, params, null, headers, list, body, multipartBody, id);
    }

    protected HttpRequest(String url, Object tag, Map<String, String> params, Map<String, String> encodedParams, Map<String, String> headers, List<MultipartFile> list, String body, MultipartBody multipartBody, String id) {
        this.url = url;
        this.params = params;
        this.encodedParams = encodedParams;
        this.headers = headers;
        this.list = list;
        this.body = body;
        this.multipartBody = multipartBody;
        this.id = id;
        if (null == url) {
            throw new IllegalArgumentException("url can not be null.");
        }
        this.builder.url(url).tag(tag);
        this.headers();
    }

    public static RequestBody createRequestBody(final MediaType contentType, final InputStream is) {
        if (null == is) {
            throw new NullPointerException("is == null");
        }
        return new RequestBody(){

            @Override
            public MediaType contentType() {
                return contentType;
            }

            @Override
            public long contentLength() {
                try {
                    return is.available();
                }
                catch (IOException e) {
                    return 0L;
                }
            }

            @Override
            public void writeTo(BufferSink sink) throws IOException {
                Source source = null;
                try {
                    source = IoKit.source((InputStream)is);
                    sink.writeAll(source);
                }
                finally {
                    IoKit.close((Closeable)source);
                }
            }
        };
    }

    protected abstract RequestBody buildRequestBody();

    protected abstract Request buildRequest(RequestBody var1);

    public RequestCall build(Httpd httpd) {
        return new RequestCall(this, httpd);
    }

    public Request createRequest(Callback callback) {
        return this.buildRequest(this.buildRequestBody());
    }

    protected void headers() {
        Headers.Builder headerBuilder = new Headers.Builder();
        if (null == this.headers || this.headers.isEmpty()) {
            return;
        }
        for (String key : this.headers.keySet()) {
            headerBuilder.add(key, this.headers.get(key));
        }
        this.builder.headers(headerBuilder.build());
    }

    public String getId() {
        return this.id;
    }
}

