/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.plugin.httpz;

import java.util.Date;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.miaixz.bus.core.xyz.DateKit;

public class HttpzState {
    private static final int MAX_ERROR_MSG_COUNT = 100;
    protected static AtomicInteger reqTotalCount = new AtomicInteger(0);
    protected static AtomicInteger reqFailureCount = new AtomicInteger(0);
    protected static AtomicInteger reqExceptionCount = new AtomicInteger(0);
    protected static Date startTime = new Date();
    protected static Date lastAccessTime;
    protected static LinkedBlockingDeque<String> errorMsgs;
    private static volatile boolean isStop;

    public static void stopStat() {
        isStop = true;
    }

    public static int getReqTotalCount() {
        return reqTotalCount.get();
    }

    public static int getReqFailureCount() {
        return reqFailureCount.get();
    }

    public static int getReqExceptionCount() {
        return reqExceptionCount.get();
    }

    public static Date getStartTime() {
        return startTime;
    }

    public static Date getLastAccessTime() {
        return lastAccessTime;
    }

    public static LinkedBlockingDeque<String> getErrorMsgs() {
        return errorMsgs;
    }

    protected static void onReqFailure(String url, Exception e) {
        if (isStop) {
            return;
        }
        lastAccessTime = new Date();
        reqTotalCount.incrementAndGet();
        reqFailureCount.incrementAndGet();
        if (null != e) {
            reqExceptionCount.incrementAndGet();
            if (errorMsgs.size() >= 100) {
                errorMsgs.removeFirst();
            }
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(DateKit.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss")).append("\t").append(url).append("\t").append(e.getClass().getName()).append("\t").append(e.getMessage());
            errorMsgs.add(errorMsg.toString());
        }
    }

    protected static void onReqSuccess() {
        if (isStop) {
            return;
        }
        lastAccessTime = new Date();
        reqTotalCount.incrementAndGet();
    }

    static {
        errorMsgs = new LinkedBlockingDeque(100);
        isStop = false;
    }
}

