/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.plugin.httpz;

import java.util.List;
import java.util.Map;
import org.miaixz.bus.core.lang.MediaType;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.http.Headers;
import org.miaixz.bus.http.Request;
import org.miaixz.bus.http.bodys.FormBody;
import org.miaixz.bus.http.bodys.MultipartBody;
import org.miaixz.bus.http.bodys.RequestBody;
import org.miaixz.bus.http.plugin.httpz.HttpRequest;
import org.miaixz.bus.http.plugin.httpz.MultipartFile;

public class PostRequest
extends HttpRequest {
    public PostRequest(String url, Object tag, Map<String, String> params, Map<String, String> headers, List<MultipartFile> list, String body, MultipartBody multipartBody, String id) {
        super(url, tag, params, headers, list, body, multipartBody, id);
    }

    public PostRequest(String url, Object tag, Map<String, String> params, Map<String, String> encoded, Map<String, String> headers, List<MultipartFile> list, String body, MultipartBody multipartBody, String id) {
        super(url, tag, params, encoded, headers, list, body, multipartBody, id);
    }

    @Override
    protected RequestBody buildRequestBody() {
        if (null != this.multipartBody) {
            return this.multipartBody;
        }
        if (null != this.list && !this.list.isEmpty()) {
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MediaType.MULTIPART_FORM_DATA_TYPE);
            this.addParam(builder);
            this.list.forEach(file -> {
                RequestBody fileBody = null != file.file ? RequestBody.create(MediaType.APPLICATION_OCTET_STREAM_TYPE, file.file) : (null != file.in ? PostRequest.createRequestBody(MediaType.APPLICATION_OCTET_STREAM_TYPE, file.in) : RequestBody.create(MediaType.valueOf((String)((String)ObjectKit.defaultIfNull((Object)FileKit.getMimeType((String)file.name), (Object)"application/octet-stream"))), file.content));
                builder.addFormDataPart(file.part, file.name, fileBody);
            });
            if (null != this.body && !this.body.isEmpty()) {
                builder.addPart(RequestBody.create(MediaType.MULTIPART_FORM_DATA_TYPE, this.body));
            }
            return builder.build();
        }
        if (null != this.body && !this.body.isEmpty()) {
            MediaType contentType = this.headers.containsKey("Content-Type") ? MediaType.valueOf((String)((String)this.headers.get("Content-Type"))) : MediaType.TEXT_PLAIN_TYPE;
            return RequestBody.create(contentType, this.body);
        }
        FormBody.Builder builder = new FormBody.Builder();
        this.addParam(builder);
        return builder.build();
    }

    @Override
    protected Request buildRequest(RequestBody requestBody) {
        return this.builder.post(requestBody).build();
    }

    private void addParam(FormBody.Builder builder) {
        if (null != this.params) {
            this.params.forEach(builder::add);
        }
        if (null != this.encodedParams) {
            this.encodedParams.forEach(builder::addEncoded);
        }
    }

    private void addParam(MultipartBody.Builder builder) {
        if (null != this.params && !this.params.isEmpty()) {
            this.params.forEach((k, v) -> builder.addPart(Headers.of("Content-Disposition", "form-data; name=\"" + k + "\""), RequestBody.create(null, v)));
        }
    }
}

