/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.http.plugin.soap;

import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.Name;
import jakarta.xml.soap.SOAPBodyElement;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPHeaderElement;
import jakarta.xml.soap.SOAPMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.net.Protocol;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.XmlKit;
import org.miaixz.bus.http.Httpz;
import org.miaixz.bus.http.Response;
import org.miaixz.bus.http.SoapX;
import org.miaixz.bus.http.plugin.httpz.PostBuilder;

public class SoapBuilder {
    private final Protocol protocol;
    private final String namespaceURI;
    private final Map<String, String> headers = new HashMap<String, String>();
    private String url;
    private SOAPMessage message;
    private MessageFactory factory;
    private SOAPBodyElement methodEle;
    private Charset charset = org.miaixz.bus.core.lang.Charset.UTF_8;

    public SoapBuilder(String url) {
        this(url, Protocol.SOAP_1_2);
    }

    public SoapBuilder(String url, Protocol protocol) {
        this(url, protocol, null);
    }

    public SoapBuilder(String url, Protocol protocol, String namespaceURI) {
        this.url = url;
        this.namespaceURI = namespaceURI;
        this.protocol = protocol;
        this.init(protocol);
    }

    public static SoapBuilder of(String url) {
        return new SoapBuilder(url);
    }

    public static SoapBuilder of(String url, Protocol protocol) {
        return new SoapBuilder(url, protocol);
    }

    public static SoapBuilder of(String url, Protocol protocol, String namespaceURI) {
        return new SoapBuilder(url, protocol, namespaceURI);
    }

    private static SOAPElement setParam(SOAPElement ele, String name, Object value, String prefix) {
        SOAPElement childEle;
        try {
            childEle = StringKit.isNotBlank((CharSequence)prefix) ? ele.addChildElement(name, prefix) : ele.addChildElement(name);
        }
        catch (SOAPException e) {
            throw new InternalException((Throwable)e);
        }
        if (null != value) {
            if (value instanceof SOAPElement) {
                try {
                    ele.addChildElement((SOAPElement)value);
                }
                catch (SOAPException e) {
                    throw new InternalException((Throwable)e);
                }
            } else if (value instanceof Map) {
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    SoapBuilder.setParam(childEle, StringKit.toStringOrNull(entry.getKey()), entry.getValue(), prefix);
                }
            } else {
                childEle.setValue(value.toString());
            }
        }
        return childEle;
    }

    public SoapBuilder init(Protocol protocol) {
        try {
            this.factory = MessageFactory.newInstance((String)protocol.name);
            this.message = this.factory.createMessage();
        }
        catch (SOAPException e) {
            throw new InternalException((Throwable)e);
        }
        return this;
    }

    public SoapBuilder reset() {
        try {
            this.message = this.factory.createMessage();
        }
        catch (SOAPException e) {
            throw new InternalException((Throwable)e);
        }
        this.methodEle = null;
        return this;
    }

    public SoapBuilder charset(Charset charset) {
        if (null != charset) {
            this.charset = charset;
            try {
                this.message.setProperty("jakarta.xml.soap.character-set-encoding", (Object)charset.name());
                this.message.setProperty("jakarta.xml.soap.write-xml-declaration", (Object)"true");
            }
            catch (SOAPException sOAPException) {
                // empty catch block
            }
        }
        return this;
    }

    public SoapBuilder setUrl(String url) {
        this.url = url;
        return this;
    }

    public SoapBuilder header(String name, String value, boolean isOverride) {
        if (null != name && null != value) {
            String values = this.headers.get(name.trim());
            if (isOverride || StringKit.isEmpty((CharSequence)values)) {
                this.headers.put(name.trim(), value);
            }
        }
        return this;
    }

    public Map<String, String> headers() {
        this.headers.put("Content-Type", this.getXmlContentType());
        return Collections.unmodifiableMap(this.headers);
    }

    public SoapBuilder clearHeaders() {
        this.headers.clear();
        return this;
    }

    public SOAPHeaderElement addSOAPHeader(QName name, String actorURI, String roleUri, Boolean mustUnderstand, Boolean relay) {
        SOAPHeaderElement ele = this.addSOAPHeader(name);
        try {
            if (StringKit.isNotBlank((CharSequence)roleUri)) {
                ele.setRole(roleUri);
            }
            if (null != relay) {
                ele.setRelay(relay.booleanValue());
            }
        }
        catch (SOAPException e) {
            throw new InternalException((Throwable)e);
        }
        if (StringKit.isNotBlank((CharSequence)actorURI)) {
            ele.setActor(actorURI);
        }
        if (null != mustUnderstand) {
            ele.setMustUnderstand(mustUnderstand.booleanValue());
        }
        return ele;
    }

    public SOAPHeaderElement addSOAPHeader(String localName) {
        return this.addSOAPHeader(new QName(localName));
    }

    public SOAPHeaderElement addSOAPHeader(String localName, String value) {
        SOAPHeaderElement soapHeaderElement = this.addSOAPHeader(localName);
        soapHeaderElement.setTextContent(value);
        return soapHeaderElement;
    }

    public SOAPHeaderElement addSOAPHeader(QName name) {
        SOAPHeaderElement ele;
        try {
            ele = this.message.getSOAPHeader().addHeaderElement(name);
        }
        catch (SOAPException e) {
            throw new InternalException((Throwable)e);
        }
        return ele;
    }

    public SoapBuilder setMethod(Name name, Map<String, Object> params, boolean useMethodPrefix) {
        return this.setMethod(new QName(name.getURI(), name.getLocalName(), name.getPrefix()), params, useMethodPrefix);
    }

    public SoapBuilder setMethod(QName name, Map<String, Object> params, boolean useMethodPrefix) {
        this.setMethod(name);
        String prefix = useMethodPrefix ? name.getPrefix() : null;
        SOAPBodyElement methodEle = this.methodEle;
        for (Map.Entry entry : MapKit.wrap(params)) {
            SoapBuilder.setParam((SOAPElement)methodEle, (String)entry.getKey(), entry.getValue(), prefix);
        }
        return this;
    }

    public SoapBuilder setMethod(String methodName) {
        return this.setMethod(methodName, (String)ObjectKit.defaultIfNull((Object)this.namespaceURI, (Object)""));
    }

    public SoapBuilder setMethod(String methodName, String namespaceURI) {
        List methodNameList = StringKit.split((CharSequence)methodName, (CharSequence)":");
        QName qName = 2 == methodNameList.size() ? new QName(namespaceURI, (String)methodNameList.get(1), (String)methodNameList.get(0)) : new QName(namespaceURI, methodName);
        return this.setMethod(qName);
    }

    public SoapBuilder setMethod(QName name) {
        try {
            this.methodEle = this.message.getSOAPBody().addBodyElement(name);
        }
        catch (SOAPException e) {
            throw new InternalException((Throwable)e);
        }
        return this;
    }

    public SoapBuilder setParam(String name, Object value) {
        return this.setParam(name, value, true);
    }

    public SoapBuilder setParam(String name, Object value, boolean useMethodPrefix) {
        SoapBuilder.setParam((SOAPElement)this.methodEle, name, value, useMethodPrefix ? this.methodEle.getPrefix() : null);
        return this;
    }

    public SoapBuilder setParams(Map<String, Object> params) {
        return this.setParams(params, true);
    }

    public SoapBuilder setParams(Map<String, Object> params, boolean useMethodPrefix) {
        for (Map.Entry entry : MapKit.wrap(params)) {
            this.setParam((String)entry.getKey(), entry.getValue(), useMethodPrefix);
        }
        return this;
    }

    public SOAPBodyElement getMethodEle() {
        return this.methodEle;
    }

    public SOAPMessage getMessage() {
        return this.message;
    }

    public String getString(boolean pretty) {
        return SoapX.toString(this.message, pretty, this.charset);
    }

    public SoapBuilder write(OutputStream out) {
        try {
            this.message.writeTo(out);
        }
        catch (SOAPException | IOException e) {
            throw new InternalException(e);
        }
        return this;
    }

    public SOAPMessage sendForMessage() {
        SOAPMessage sOAPMessage;
        Response res = this.sendForResponse();
        MimeHeaders headers = new MimeHeaders();
        for (Map.Entry<String, List<String>> entry : res.headers().toMultimap().entrySet()) {
            if (!StringKit.isNotEmpty((CharSequence)entry.getKey())) continue;
            headers.setHeader(entry.getKey(), (String)CollKit.get((Collection)entry.getValue(), (int)0));
        }
        try {
            sOAPMessage = this.factory.createMessage(headers, res.body().byteStream());
        }
        catch (SOAPException | IOException e) {
            try {
                throw new InternalException(e);
            }
            catch (Throwable throwable) {
                IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{res});
                throw throwable;
            }
        }
        IoKit.closeQuietly((AutoCloseable[])new AutoCloseable[]{res});
        return sOAPMessage;
    }

    public String send() {
        return this.send(false);
    }

    public String send(boolean pretty) {
        String body;
        try {
            body = this.sendForResponse().body().string();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return pretty ? XmlKit.format((String)body) : body;
    }

    public Response sendForResponse() {
        try {
            return ((PostBuilder)((PostBuilder)((PostBuilder)Httpz.post().url(this.url)).addHeader(this.headers)).addParam(this.getString(false))).build().execute();
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
    }

    private String getXmlContentType() {
        switch (this.protocol) {
            case SOAP_1_1: {
                return "text/xml;charset=" + this.charset.toString();
            }
            case SOAP_1_2: {
                return "application/soap+xml;charset=" + this.charset.toString();
            }
        }
        throw new InternalException("Unsupported protocol: {}", new Object[]{this.protocol});
    }
}

