/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.limiter;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.core.lang.reflect.JdkProxy;

public class Builder {
    private static final Map<Method, String> MAP = new ConcurrentHashMap<Method, String>();
    private static final Object LOCK = new Object();

    public static Class<?> getUserClass(Class<?> clazz) {
        if (JdkProxy.isCglibProxyClass(clazz)) {
            Class<?> superclass = clazz.getSuperclass();
            return Builder.getUserClass(superclass);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String resolveMethodName(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("Null method");
        }
        String methodName = MAP.get(method);
        if (methodName == null) {
            Object object = LOCK;
            synchronized (object) {
                methodName = MAP.get(method);
                if (methodName == null) {
                    StringBuilder sb = new StringBuilder();
                    String className = method.getDeclaringClass().getName();
                    String name = method.getName();
                    Class<?>[] params = method.getParameterTypes();
                    sb.append(className).append(":").append(name);
                    sb.append("(");
                    int paramPos = 0;
                    for (Class<?> clazz : params) {
                        sb.append(clazz.getCanonicalName());
                        if (++paramPos >= params.length) continue;
                        sb.append(",");
                    }
                    sb.append(")");
                    methodName = sb.toString();
                    MAP.put(method, methodName);
                }
            }
        }
        return methodName;
    }
}

