/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.limiter;

import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import java.util.List;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.limiter.magic.annotation.Downgrade;
import org.miaixz.bus.limiter.magic.annotation.Hotspot;
import org.miaixz.bus.limiter.magic.annotation.Limiting;
import org.miaixz.bus.limiter.metric.ResourceManager;
import org.miaixz.bus.logger.Logger;

public class Registry {
    public static void register(Downgrade downgrade, String resourceKey) {
        if (!FlowRuleManager.hasConfig((String)resourceKey)) {
            FlowRule rule = new FlowRule();
            rule.setResource(resourceKey);
            rule.setGrade(downgrade.grade().getGrade());
            rule.setCount((double)downgrade.count());
            rule.setLimitApp("default");
            FlowRuleManager.loadRules((List)ListKit.of((Object[])new FlowRule[]{rule}));
            Logger.info((String)"Add Fallback Rule [{}]", (Object[])new Object[]{resourceKey});
        }
    }

    public static void register(Hotspot hotspot, String resourceKey) {
        if (!ParamFlowRuleManager.hasRules((String)resourceKey)) {
            ParamFlowRule rule = new ParamFlowRule();
            rule.setResource(resourceKey);
            rule.setGrade(hotspot.grade().getGrade());
            rule.setCount((double)hotspot.count());
            rule.setDurationInSec((long)hotspot.duration());
            rule.setParamIdx(Integer.valueOf(0));
            ParamFlowRuleManager.loadRules((List)ListKit.of((Object[])new ParamFlowRule[]{rule}));
            Logger.info((String)"Add Hot Rule [{}]", (Object[])new Object[]{rule.getResource()});
        }
    }

    public static void register(Limiting limiting, String resourceKey) {
        if (!ResourceManager.contain(resourceKey)) {
            ResourceManager.add(resourceKey);
            Logger.info((String)"Add Request Limit [{}]", (Object[])new Object[]{resourceKey});
        }
    }
}

