/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.limiter;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphO;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import java.lang.reflect.Method;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.crypto.Builder;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.limiter.Holder;
import org.miaixz.bus.limiter.magic.StrategyMode;
import org.miaixz.bus.limiter.metric.StrategyManager;
import org.miaixz.bus.logger.Logger;

public class Sentinel {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object process(Object bean, Method method, Object[] args, String name, StrategyMode strategyMode) {
        switch (strategyMode) {
            case FALLBACK: {
                if (SphO.entry((String)name)) {
                    try {
                        Object object = MethodKit.invoke((Object)bean, (Method)method, (Object[])args);
                        return object;
                    }
                    finally {
                        SphO.exit();
                    }
                }
                if (!Holder.load().isLogger()) return StrategyManager.get(strategyMode).process(bean, method, args);
                Logger.info((String)"Trigger fallback strategy for [{}], args: [{}]", (Object[])new Object[]{name, JsonKit.toJsonString((Object)args)});
                return StrategyManager.get(strategyMode).process(bean, method, args);
            }
            case HOT_METHOD: {
                Object object;
                String convertParam = Builder.md5Hex((String)JsonKit.toJsonString((Object)args));
                Entry entry = null;
                try {
                    entry = SphU.entry((String)name, (EntryType)EntryType.IN, (int)1, (Object[])new Object[]{convertParam});
                    object = MethodKit.invoke((Object)bean, (Method)method, (Object[])args);
                    if (entry == null) return object;
                }
                catch (BlockException e) {
                    Object object2;
                    try {
                        if (Holder.load().isLogger()) {
                            Logger.info((String)" Trigger hotspot strategy for [{}], args: [{}]", (Object[])new Object[]{name, JsonKit.toJsonString((Object)args)});
                        }
                        object2 = StrategyManager.get(strategyMode).process(bean, method, args);
                        if (entry == null) return object2;
                    }
                    catch (Throwable throwable) {
                        if (entry == null) throw throwable;
                        entry.exit(1, new Object[]{convertParam});
                        throw throwable;
                    }
                    entry.exit(1, new Object[]{convertParam});
                    return object2;
                }
                entry.exit(1, new Object[]{convertParam});
                return object;
            }
            case REQUEST_LIMIT: {
                if (!Holder.load().isLogger()) return StrategyManager.get(strategyMode).process(bean, method, args);
                Logger.info((String)"Trigger requestLimit strategy for [{}], args: [{}]", (Object[])new Object[]{name, JsonKit.toJsonString((Object)args)});
                return StrategyManager.get(strategyMode).process(bean, method, args);
            }
        }
        throw new InternalException("Strategy error!");
    }
}

