/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.limiter.metric;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.miaixz.bus.core.data.id.ID;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.ThreadKit;
import org.miaixz.bus.limiter.Builder;
import org.miaixz.bus.limiter.Provider;
import org.miaixz.bus.limiter.Supplier;
import org.miaixz.bus.limiter.magic.StrategyMode;
import org.miaixz.bus.limiter.magic.annotation.Limiting;
import org.miaixz.bus.limiter.metric.MethodManager;
import org.miaixz.bus.limiter.metric.ResourceManager;

public class RequestProvider
implements Provider {
    private final ExecutorService cleaner = ThreadKit.newFixedExecutor((int)1, (int)5, (String)"L-", (boolean)false);
    private final Map<Serializable, ResourceManager> map = new ConcurrentHashMap<Serializable, ResourceManager>();
    private Supplier supplier = new Supplier(this){

        @Override
        public Serializable get() {
            return ID.objectId();
        }
    };

    public void setMarkSupplier(Supplier supplier) {
        this.supplier = supplier;
    }

    @Override
    public StrategyMode get() {
        return StrategyMode.REQUEST_LIMIT;
    }

    @Override
    public Object process(Object bean, Method method, Object[] args) {
        Limiting limiting;
        String name;
        Serializable mark = this.supplier.get();
        ResourceManager resourceManager = this.map.get(mark);
        if (Objects.isNull(resourceManager)) {
            resourceManager = new ResourceManager();
            this.map.put(mark, resourceManager);
        }
        if (!resourceManager.entry(name = Builder.resolveMethodName(method), limiting = (Limiting)MethodManager.getAnnoInfo(name).getRight())) {
            return this.supplier.intercept(bean, method, args);
        }
        return MethodKit.invoke((Object)bean, (Method)method, (Object[])args);
    }

    private void clears() {
        this.cleaner.submit(this::clear);
    }

    private void clear() {
        int count = 0;
        for (Serializable mark : this.map.keySet()) {
            ++count;
            ResourceManager resourceManager = this.map.get(mark);
            if (Objects.isNull(resourceManager)) continue;
            if (resourceManager.isClear()) {
                this.map.remove(mark);
            }
            if (count <= 9) continue;
            return;
        }
    }
}

