/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.limiter.metric;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.limiter.Provider;
import org.miaixz.bus.limiter.magic.StrategyMode;

public class FallbackProvider
implements Provider {
    private final Map<String, Method> map = new ConcurrentHashMap<String, Method>();

    @Override
    public StrategyMode get() {
        return StrategyMode.FALLBACK;
    }

    @Override
    public Object process(Object bean, Method method, Object[] args) {
        Method fallbackMethod;
        String fallbackMethodName = StringKit.format((CharSequence)"{}Fallback", (Object[])new Object[]{method.getName()});
        if (this.map.containsKey(fallbackMethodName)) {
            fallbackMethod = this.map.get(fallbackMethodName);
        } else {
            fallbackMethod = MethodKit.getMethod(bean.getClass(), (String)fallbackMethodName, (Class[])method.getParameterTypes());
            this.map.put(fallbackMethodName, fallbackMethod);
        }
        if (ObjectKit.isNull((Object)fallbackMethod)) {
            throw new RuntimeException(StringKit.format((CharSequence)"Can't find fallback method [{}] in bean [{}]", (Object[])new Object[]{fallbackMethodName, bean.getClass().getName()}));
        }
        return MethodKit.invoke((Object)bean, (Method)fallbackMethod, (Object[])args);
    }
}

