/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.limiter.metric;

import java.lang.reflect.Method;
import org.miaixz.bus.core.cache.provider.TimedCache;
import org.miaixz.bus.core.xyz.CacheKit;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.json.JsonKit;
import org.miaixz.bus.limiter.Builder;
import org.miaixz.bus.limiter.Holder;
import org.miaixz.bus.limiter.Provider;
import org.miaixz.bus.limiter.magic.StrategyMode;

public class MethodProvider
implements Provider {
    private final TimedCache<String, Object> cache = CacheKit.newTimedCache((long)(1000L * (long)Holder.load().getSeconds()));

    public MethodProvider() {
        this.cache.schedulePrune(1000L);
    }

    @Override
    public StrategyMode get() {
        return StrategyMode.HOT_METHOD;
    }

    @Override
    public Object process(Object bean, Method method, Object[] args) {
        String hotKey = StringKit.format((CharSequence)"{}-{}", (Object[])new Object[]{Builder.resolveMethodName(method), org.miaixz.bus.crypto.Builder.md5Hex((String)JsonKit.toJsonString((Object)args))});
        if (this.cache.containsKey((Object)hotKey)) {
            return this.cache.get((Object)hotKey, false);
        }
        Object result = MethodKit.invoke((Object)bean, (Method)method, (Object[])args);
        this.cache.put((Object)hotKey, result);
        return result;
    }
}

