/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.limiter.metric;

import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.limiter.magic.annotation.Limiting;

public class ResourceManager {
    private static final Set<String> PROTECTED_METHODS = new HashSet<String>();
    private final Map<String, Protection> map = new ConcurrentHashMap<String, Protection>();

    public static boolean contain(String resourceKey) {
        return PROTECTED_METHODS.contains(resourceKey);
    }

    public static void add(String resourceKey) {
        PROTECTED_METHODS.add(resourceKey);
    }

    public boolean entry(String resourceKey, Limiting limiting) throws IllegalStateException {
        Protection protection = this.map.get(resourceKey);
        if (Objects.isNull(protection)) {
            protection = new Protection(limiting);
            this.map.put(resourceKey, protection);
        }
        if (protection.isExpire()) {
            protection.reset();
        }
        if (!protection.isAllow()) {
            return false;
        }
        --protection.allowCount;
        return true;
    }

    public boolean isClear() {
        this.map.keySet().forEach(key -> {
            Protection protection = this.map.get(key);
            if (Objects.nonNull(protection) && protection.isExpire()) {
                this.map.remove(key);
            }
        });
        return this.map.size() == 0;
    }

    static class Protection {
        Limiting limiting;
        LocalDateTime targetTime;
        int allowCount;

        public Protection(Limiting limiting) {
            this.limiting = limiting;
            this.reset();
        }

        public boolean isExpire() {
            return this.targetTime.compareTo(LocalDateTime.now()) < 0;
        }

        public void reset() {
            this.allowCount = this.limiting.count();
            this.targetTime = LocalDateTime.now().plusSeconds(this.limiting.duration());
        }

        public boolean isAllow() {
            return this.allowCount > 0;
        }
    }
}

