/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.limiter.proxy;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.limiter.Builder;
import org.miaixz.bus.limiter.Registry;
import org.miaixz.bus.limiter.Sentinel;
import org.miaixz.bus.limiter.magic.StrategyMode;
import org.miaixz.bus.limiter.magic.annotation.Downgrade;
import org.miaixz.bus.limiter.magic.annotation.Hotspot;
import org.miaixz.bus.limiter.magic.annotation.Limiting;
import org.miaixz.bus.limiter.metric.MethodManager;
import org.miaixz.bus.limiter.proxy.ByteBuddyProxy;

public class ByteBuddyHandler
implements InvocationHandler {
    private final ByteBuddyProxy byteBuddyProxy;
    private Map<String, Method> methodCache = new HashMap<String, Method>();

    public ByteBuddyHandler(ByteBuddyProxy byteBuddyProxy) {
        this.byteBuddyProxy = byteBuddyProxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method realMethod;
        String name = Builder.resolveMethodName(method);
        if (this.methodCache.containsKey(name)) {
            realMethod = this.methodCache.get(name);
        } else {
            realMethod = MethodKit.getMethod(this.byteBuddyProxy.bean.getClass(), (String)method.getName(), (Class[])method.getParameterTypes());
            this.methodCache.put(name, realMethod);
        }
        if (MethodManager.contain(name)) {
            StrategyMode strategyMode = (StrategyMode)((Object)MethodManager.getAnnoInfo(name).getLeft());
            Annotation anno = (Annotation)MethodManager.getAnnoInfo(name).getRight();
            if (anno instanceof Downgrade) {
                Registry.register((Downgrade)anno, name);
            } else if (anno instanceof Hotspot) {
                Registry.register((Hotspot)anno, name);
            } else if (anno instanceof Limiting) {
                Registry.register((Limiting)anno, name);
            } else {
                throw new RuntimeException("annotation type error");
            }
            return Sentinel.process(this.byteBuddyProxy.bean, realMethod, args, name, strategyMode);
        }
        return MethodKit.invoke((Object)this.byteBuddyProxy.bean, (Method)realMethod, (Object[])args);
    }
}

