/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.decorators.SoftCache;
import org.apache.ibatis.cache.impl.PerpetualCache;
import org.miaixz.bus.core.lang.exception.MapperException;
import org.miaixz.bus.mapper.support.GenId;
import org.miaixz.bus.mapper.support.MetaObject;

public class Builder {
    public static final Cache CLASS_CACHE = new SoftCache((Cache)new PerpetualCache("MAPPER_CLASS_CACHE"));
    public static final Map<Class<? extends GenId>, GenId> CACHE = new ConcurrentHashMap<Class<? extends GenId>, GenId>();
    public static final ReentrantLock LOCK = new ReentrantLock();
    private static final Pattern GET_PATTERN = Pattern.compile("^get[A-Z].*");
    private static final Pattern IS_PATTERN = Pattern.compile("^is[A-Z].*");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void genId(Object target, String property, Class<? extends GenId> genClass, String table, String column) throws MapperException {
        try {
            GenId genId;
            if (CACHE.containsKey(genClass)) {
                genId = CACHE.get(genClass);
            } else {
                LOCK.lock();
                try {
                    if (!CACHE.containsKey(genClass)) {
                        CACHE.put(genClass, genClass.newInstance());
                    }
                    genId = CACHE.get(genClass);
                }
                finally {
                    LOCK.unlock();
                }
            }
            org.apache.ibatis.reflection.MetaObject metaObject = MetaObject.forObject(target);
            if (metaObject.getValue(property) == null) {
                Object id = genId.genId(table, column);
                metaObject.setValue(property, id);
            }
        }
        catch (Exception e) {
            throw new MapperException("\u751f\u6210 ID \u5931\u8d25!", (Throwable)e);
        }
    }
}

