/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.additional.upsert;

import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;
import org.miaixz.bus.mapper.builder.EntityBuilder;
import org.miaixz.bus.mapper.builder.MapperBuilder;
import org.miaixz.bus.mapper.builder.MapperTemplate;
import org.miaixz.bus.mapper.builder.SqlBuilder;
import org.miaixz.bus.mapper.entity.EntityColumn;

public class UpsertProvider
extends MapperTemplate {
    public UpsertProvider(Class<?> mapperClass, MapperBuilder mapperBuilder) {
        super(mapperClass, mapperBuilder);
    }

    public String upsert(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append(this.tableName(entityClass));
        Set<EntityColumn> columns = EntityBuilder.getColumns(entityClass);
        String primaryKeyColumn = null;
        EntityColumn logicDeleteColumn = SqlBuilder.getLogicDeleteColumn(entityClass);
        sql.append("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">");
        for (EntityColumn column : columns) {
            if (column.isId()) {
                primaryKeyColumn = column.getColumn();
            }
            if (!column.isInsertable()) continue;
            sql.append(column.getColumn() + ",");
        }
        sql.append("</trim>");
        sql.append(" VALUES ");
        sql.append("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">");
        for (EntityColumn column : columns) {
            if (column.getGenIdClass() == null) continue;
            sql.append("<bind name=\"").append(column.getColumn()).append("GenIdBind\" value=\"@org.miaixz.bus.mapper.Builder@genId(");
            sql.append("record").append(", '").append(column.getProperty()).append("'");
            sql.append(", @").append(column.getGenIdClass().getCanonicalName()).append("@class");
            sql.append(", '").append(this.tableName(entityClass)).append("'");
            sql.append(", '").append(column.getColumn()).append("')");
            sql.append("\"/>");
        }
        for (EntityColumn column : columns) {
            if (!column.isInsertable()) continue;
            if (logicDeleteColumn != null && logicDeleteColumn == column) {
                sql.append(SqlBuilder.getLogicDeletedValue(column, false)).append(",");
                continue;
            }
            sql.append(column.getColumnHolder() + ",");
        }
        sql.append("</trim>");
        sql.append(" ON CONFLICT (" + primaryKeyColumn + ") DO UPDATE ");
        sql.append(SqlBuilder.updateSetColumns(entityClass, null, true, this.isNotEmpty()));
        return sql.toString();
    }
}

