/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.additional.select;

import java.util.Objects;
import org.apache.ibatis.mapping.MappedStatement;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.mapper.builder.EntityBuilder;
import org.miaixz.bus.mapper.builder.MapperBuilder;
import org.miaixz.bus.mapper.builder.MapperTemplate;
import org.miaixz.bus.mapper.builder.SqlBuilder;
import org.miaixz.bus.mapper.entity.EntityColumn;
import org.miaixz.bus.mapper.entity.EntityTable;

public class SelectPropertyProvider
extends MapperTemplate {
    public SelectPropertyProvider(Class<?> mapperClass, MapperBuilder mapperBuilder) {
        super(mapperClass, mapperBuilder);
    }

    public static String getColumnByProperty(Class<?> entityClass, String property) {
        EntityTable entityTable = EntityBuilder.getEntityTable(entityClass);
        EntityColumn entityColumn = entityTable.getPropertyMap().get(property);
        return entityColumn.getColumn();
    }

    public static boolean existsWhereCondition(Object value, boolean notEmpty) {
        boolean appendWhereCondition = true;
        if (Objects.isNull(value)) {
            Logger.warn((String)"value is null! this will case no conditions after where keyword", (Object[])new Object[0]);
        } else if (String.class.equals(value.getClass()) && notEmpty && StringKit.isEmpty((CharSequence)value.toString())) {
            appendWhereCondition = false;
        }
        return appendWhereCondition;
    }

    public String selectOneByProperty(MappedStatement ms) {
        String propertyHelper = SelectPropertyProvider.class.getName();
        Class<?> entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlBuilder.selectAllColumns(entityClass));
        sql.append(SqlBuilder.fromTable(entityClass, this.tableName(entityClass)));
        sql.append("<where>\n");
        sql.append("<if test=\"@");
        sql.append(propertyHelper);
        sql.append("@existsWhereCondition(value, ");
        sql.append(this.isNotEmpty());
        sql.append(")");
        sql.append("\">\n");
        String entityClassName = entityClass.getName();
        String ognl = "${@" + propertyHelper + "@getColumnByProperty(@java.lang.Class@forName(\"" + entityClassName + "\"), @org.miaixz.bus.mapper.support.Reflector@fnToFieldName(fn))}";
        sql.append(ognl + " = #{value}\n");
        sql.append("</if>\n");
        sql.append(SqlBuilder.whereLogicDelete(entityClass, false));
        sql.append("</where>");
        return sql.toString();
    }

    public String selectByProperty(MappedStatement ms) {
        String propertyHelper = SelectPropertyProvider.class.getName();
        Class<?> entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlBuilder.selectAllColumns(entityClass));
        sql.append(SqlBuilder.fromTable(entityClass, this.tableName(entityClass)));
        sql.append("<where>\n");
        sql.append("<if test=\"@");
        sql.append(propertyHelper);
        sql.append("@existsWhereCondition(value, ");
        sql.append(this.isNotEmpty());
        sql.append(")");
        sql.append("\">\n");
        String entityClassName = entityClass.getName();
        String ognl = "${@" + propertyHelper + "@getColumnByProperty(@java.lang.Class@forName(\"" + entityClassName + "\"), @org.miaixz.bus.mapper.support.Reflector@fnToFieldName(fn))}";
        sql.append(ognl + " = #{value}\n");
        sql.append("</if>\n");
        sql.append(SqlBuilder.whereLogicDelete(entityClass, false));
        sql.append("</where>");
        return sql.toString();
    }

    public String selectInByProperty(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlBuilder.selectAllColumns(entityClass));
        sql.append(SqlBuilder.fromTable(entityClass, this.tableName(entityClass)));
        sql.append("<where>\n");
        String entityClassName = entityClass.getName();
        String propertyHelper = SelectPropertyProvider.class.getName();
        String sqlSegment = "${@" + propertyHelper + "@getColumnByProperty(@java.lang.Class@forName(\"" + entityClassName + "\"),@org.miaixz.bus.mapper.support.Reflector@fnToFieldName(fn))} in<foreach open=\"(\" close=\")\" separator=\",\" collection=\"values\" item=\"obj\">\n#{obj}\n</foreach>\n";
        sql.append(sqlSegment);
        sql.append(SqlBuilder.whereLogicDelete(entityClass, false));
        sql.append("</where>");
        return sql.toString();
    }

    public String selectBetweenByProperty(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlBuilder.selectAllColumns(entityClass));
        sql.append(SqlBuilder.fromTable(entityClass, this.tableName(entityClass)));
        sql.append("<where>\n");
        String entityClassName = entityClass.getName();
        String propertyHelper = SelectPropertyProvider.class.getName();
        String sqlSegment = "${@" + propertyHelper + "@getColumnByProperty(@java.lang.Class@forName(\"" + entityClassName + "\"),@org.miaixz.bus.mapper.support.Reflector@fnToFieldName(fn))} between #{begin} and #{end}";
        sql.append(sqlSegment);
        sql.append(SqlBuilder.whereLogicDelete(entityClass, false));
        sql.append("</where>");
        return sql.toString();
    }

    public String existsWithProperty(MappedStatement ms) {
        String propertyHelper = SelectPropertyProvider.class.getName();
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlBuilder.selectCountExists(entityClass));
        sql.append(SqlBuilder.fromTable(entityClass, this.tableName(entityClass)));
        sql.append("<where>\n");
        sql.append("<if test=\"@");
        sql.append(propertyHelper);
        sql.append("@existsWhereCondition(value, ");
        sql.append(this.isNotEmpty());
        sql.append(")");
        sql.append("\">\n");
        String entityClassName = entityClass.getName();
        String ognl = "${@" + propertyHelper + "@getColumnByProperty(@java.lang.Class@forName(\"" + entityClassName + "\"), @org.miaixz.bus.mapper.support.Reflector@fnToFieldName(fn))}";
        sql.append(ognl + " = #{value}\n");
        sql.append("</if>\n");
        sql.append(SqlBuilder.whereLogicDelete(entityClass, false));
        sql.append("</where>");
        return sql.toString();
    }

    public String selectCountByProperty(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        String propertyHelper = SelectPropertyProvider.class.getName();
        StringBuilder sql = new StringBuilder();
        sql.append(SqlBuilder.selectCount(entityClass));
        sql.append(SqlBuilder.fromTable(entityClass, this.tableName(entityClass)));
        sql.append("<where>\n");
        sql.append("<if test=\"@");
        sql.append(propertyHelper);
        sql.append("@existsWhereCondition(value, ");
        sql.append(this.isNotEmpty());
        sql.append(")");
        sql.append("\">\n");
        String entityClassName = entityClass.getName();
        String ognl = "${@" + propertyHelper + "@getColumnByProperty(@java.lang.Class@forName(\"" + entityClassName + "\"), @org.miaixz.bus.mapper.support.Reflector@fnToFieldName(fn))}";
        sql.append(ognl + " = #{value}\n");
        sql.append("</if>\n");
        sql.append(SqlBuilder.whereLogicDelete(entityClass, false));
        sql.append("</where>");
        return sql.toString();
    }
}

