/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.additional.update.force;

import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;
import org.miaixz.bus.core.lang.exception.VersionException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.mapper.annotation.Version;
import org.miaixz.bus.mapper.builder.EntityBuilder;
import org.miaixz.bus.mapper.builder.MapperBuilder;
import org.miaixz.bus.mapper.builder.MapperTemplate;
import org.miaixz.bus.mapper.builder.SqlBuilder;
import org.miaixz.bus.mapper.entity.EntityColumn;

public class UpdateByPrimaryKeySelectiveForceProvider
extends MapperTemplate {
    public static final String FORCE_UPDATE_PROPERTIES = "forceUpdateProperties";

    public UpdateByPrimaryKeySelectiveForceProvider(Class<?> mapperClass, MapperBuilder mapperBuilder) {
        super(mapperClass, mapperBuilder);
    }

    public String updateByPrimaryKeySelectiveForce(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlBuilder.updateTable(entityClass, this.tableName(entityClass), "record"));
        sql.append(this.updateSetColumnsForce(entityClass, "record", true, this.isNotEmpty()));
        sql.append(SqlBuilder.wherePKColumns(entityClass, "record", true));
        return sql.toString();
    }

    public String updateSetColumnsForce(Class<?> entityClass, String entityName, boolean notNull, boolean notEmpty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<set>");
        Set<EntityColumn> columnSet = EntityBuilder.getColumns(entityClass);
        EntityColumn versionColumn = null;
        for (EntityColumn column : columnSet) {
            if (column.getEntityField().isAnnotationPresent(Version.class)) {
                if (versionColumn != null) {
                    throw new VersionException(entityClass.getName() + " \u4e2d\u5305\u542b\u591a\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5\uff0c\u4e00\u4e2a\u7c7b\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5!");
                }
                versionColumn = column;
            }
            if (!column.isId() && column.isUpdatable()) {
                if (column == versionColumn) {
                    Version version = versionColumn.getEntityField().getAnnotation(Version.class);
                    String versionClass = version.nextVersion().getName();
                    sql.append(column.getColumn()).append(" = ${@org.miaixz.bus.mapper.Version@nextVersion(").append("@").append(versionClass).append("@class, ");
                    if (StringKit.isNotEmpty((CharSequence)entityName)) {
                        sql.append(entityName).append('.');
                    }
                    sql.append(column.getProperty()).append(")},");
                    continue;
                }
                if (notNull) {
                    sql.append(this.getIfNotNull(entityName, column, column.getColumnEqualsHolder(entityName) + ",", notEmpty));
                    continue;
                }
                sql.append(column.getColumnEqualsHolder(entityName)).append(",");
                continue;
            }
            if (!column.isId() || !column.isUpdatable()) continue;
            sql.append(column.getColumn()).append(" = ").append(column.getColumn()).append(",");
        }
        sql.append("</set>");
        return sql.toString();
    }

    public String getIfNotNull(String entityName, EntityColumn column, String contents, boolean empty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<choose>");
        sql.append("<when test=\"");
        if (StringKit.isNotEmpty((CharSequence)entityName)) {
            sql.append(entityName).append(".");
        }
        sql.append(column.getProperty()).append(" != null");
        if (empty && column.getJavaType().equals(String.class)) {
            sql.append(" and ");
            if (StringKit.isNotEmpty((CharSequence)entityName)) {
                sql.append(entityName).append(".");
            }
            sql.append(column.getProperty()).append(" != '' ");
        }
        sql.append("\">");
        sql.append(contents);
        sql.append("</when>");
        sql.append("<when test=\"");
        sql.append(FORCE_UPDATE_PROPERTIES).append(" != null and ").append(FORCE_UPDATE_PROPERTIES).append(".contains('");
        sql.append(column.getProperty());
        sql.append("')\">");
        sql.append(contents);
        sql.append("</when>");
        sql.append("<otherwise></otherwise>");
        sql.append("</choose>");
        return sql.toString();
    }
}

