/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.builder;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.scripting.defaults.RawSqlSource;
import org.apache.ibatis.session.Configuration;
import org.miaixz.bus.core.lang.exception.MapperException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.mapper.annotation.RegisterMapper;
import org.miaixz.bus.mapper.builder.EntityBuilder;
import org.miaixz.bus.mapper.builder.MapperTemplate;
import org.miaixz.bus.mapper.builder.resolve.EntityResolve;
import org.miaixz.bus.mapper.entity.EntityTable;
import org.miaixz.bus.mapper.entity.Property;
import org.miaixz.bus.mapper.provider.EmptyProvider;
import org.miaixz.bus.mapper.support.Reflector;

public class MapperBuilder {
    private List<Class<?>> registerClass = new ArrayList();
    private Map<Class<?>, Collection<MapperTemplate>> registerMapper = new ConcurrentHashMap();
    private Property property = new Property();

    public MapperBuilder() {
    }

    public MapperBuilder(Properties properties) {
        this();
        this.setProperties(properties);
    }

    private Collection<MapperTemplate> fromMapperClasses(Class<?> mapperClass) {
        Method[] methods;
        ConcurrentHashMap<Class, MapperTemplate> templateMap = new ConcurrentHashMap<Class, MapperTemplate>();
        for (Method method : methods = mapperClass.getDeclaredMethods()) {
            MapperTemplate mapperTemplate;
            Class templateClass = null;
            if (method.isAnnotationPresent(SelectProvider.class)) {
                provider = method.getAnnotation(SelectProvider.class);
                templateClass = provider.type();
            } else if (method.isAnnotationPresent(InsertProvider.class)) {
                provider = method.getAnnotation(InsertProvider.class);
                templateClass = provider.type();
            } else if (method.isAnnotationPresent(DeleteProvider.class)) {
                provider = method.getAnnotation(DeleteProvider.class);
                templateClass = provider.type();
            } else if (method.isAnnotationPresent(UpdateProvider.class)) {
                provider = method.getAnnotation(UpdateProvider.class);
                templateClass = provider.type();
            }
            if (templateClass == null || !MapperTemplate.class.isAssignableFrom(templateClass)) {
                templateClass = EmptyProvider.class;
            }
            try {
                mapperTemplate = templateMap.getOrDefault(templateClass, (MapperTemplate)templateClass.getConstructor(Class.class, MapperBuilder.class).newInstance(mapperClass, this));
                templateMap.put(templateClass, mapperTemplate);
            }
            catch (Exception e) {
                Logger.error((String)("\u5b9e\u4f8b\u5316MapperTemplate\u5bf9\u8c61\u5931\u8d25:" + String.valueOf(e)), (Object[])new Object[]{e});
                throw new MapperException("\u5b9e\u4f8b\u5316MapperTemplate\u5bf9\u8c61\u5931\u8d25:" + e.getMessage());
            }
            try {
                mapperTemplate.addMethodMap(method.getName(), templateClass.getMethod(method.getName(), MappedStatement.class));
            }
            catch (NoSuchMethodException e) {
                Logger.error((String)(templateClass.getName() + "\u4e2d\u7f3a\u5c11" + method.getName() + "\u65b9\u6cd5!"), (Object[])new Object[]{e});
                throw new MapperException(templateClass.getName() + "\u4e2d\u7f3a\u5c11" + method.getName() + "\u65b9\u6cd5!");
            }
        }
        return templateMap.values();
    }

    public void registerMapper(Class<?> mapperClass) {
        Class<?>[] interfaces;
        if (!this.registerMapper.containsKey(mapperClass)) {
            this.registerClass.add(mapperClass);
            this.registerMapper.put(mapperClass, this.fromMapperClasses(mapperClass));
        }
        if ((interfaces = mapperClass.getInterfaces()) != null && interfaces.length > 0) {
            for (Class<?> anInterface : interfaces) {
                this.registerMapper(anInterface);
            }
        }
    }

    public void registerMapper(String mapperClass) {
        try {
            this.registerMapper(Class.forName(mapperClass));
        }
        catch (ClassNotFoundException e) {
            Logger.error((String)("\u6ce8\u518c\u901a\u7528Mapper[" + mapperClass + "]\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u8be5\u901a\u7528Mapper!"), (Object[])new Object[]{e});
            throw new MapperException("\u6ce8\u518c\u901a\u7528Mapper[" + mapperClass + "]\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u8be5\u901a\u7528Mapper!");
        }
    }

    public MapperTemplate isMapperMethod(String msId) {
        MapperTemplate mapperTemplate = this.getMapperTemplateByMsId(msId);
        if (mapperTemplate == null) {
            try {
                Class<?> mapperClass = Reflector.getMapperClass(msId);
                if (mapperClass.isInterface() && this.hasRegisterMapper(mapperClass)) {
                    mapperTemplate = this.getMapperTemplateByMsId(msId);
                }
            }
            catch (Exception e) {
                Logger.warn((String)("\u7279\u6b8a\u60c5\u51b5: " + String.valueOf(e)), (Object[])new Object[0]);
            }
        }
        return mapperTemplate;
    }

    public MapperTemplate getMapperTemplateByMsId(String msId) {
        for (Map.Entry<Class<?>, Collection<MapperTemplate>> entry : this.registerMapper.entrySet()) {
            for (MapperTemplate t : entry.getValue()) {
                if (!t.supportMethod(msId)) continue;
                return t;
            }
        }
        return null;
    }

    public boolean isExtendCommonMapper(Class<?> mapperInterface) {
        for (Class<?> mapperClass : this.registerClass) {
            if (!mapperClass.isAssignableFrom(mapperInterface)) continue;
            return true;
        }
        return this.hasRegisterMapper(mapperInterface);
    }

    private boolean hasRegisterMapper(Class<?> mapperInterface) {
        Class<?>[] interfaces = mapperInterface.getInterfaces();
        boolean hasRegisterMapper = false;
        if (interfaces != null && interfaces.length > 0) {
            for (Class<?> anInterface : interfaces) {
                if (anInterface.isAnnotationPresent(RegisterMapper.class)) {
                    hasRegisterMapper = true;
                    if (this.registerMapper.containsKey(anInterface)) continue;
                    this.registerMapper(anInterface);
                    continue;
                }
                if (!this.hasRegisterMapper(anInterface)) continue;
                hasRegisterMapper = true;
            }
        }
        return hasRegisterMapper;
    }

    public void processConfiguration(Configuration configuration) {
        this.processConfiguration(configuration, null);
    }

    public void processConfiguration(Configuration configuration, Class<?> mapperInterface) {
        String prefix = mapperInterface != null ? mapperInterface.getName() : "";
        for (Object object : new ArrayList(configuration.getMappedStatements())) {
            MappedStatement ms;
            if (!(object instanceof MappedStatement) || !(ms = (MappedStatement)object).getId().startsWith(prefix)) continue;
            this.processMappedStatement(ms);
        }
    }

    public void processMappedStatement(MappedStatement ms) {
        MapperTemplate mapperTemplate = this.isMapperMethod(ms.getId());
        if (mapperTemplate != null && ms.getSqlSource() instanceof ProviderSqlSource) {
            this.setSqlSource(ms, mapperTemplate);
        }
        if (ms.getSqlSource() instanceof RawSqlSource && ms.getSqlCommandType() == SqlCommandType.SELECT && ms.getResultMaps() != null && !ms.getResultMaps().isEmpty()) {
            this.setRawSqlSourceMapper(ms);
        }
    }

    public Property getConfig() {
        return this.property;
    }

    public void setConfig(Property property) {
        this.property = property;
        if (property.getResolveClass() != null) {
            try {
                EntityBuilder.setResolve(property.getResolveClass().newInstance());
            }
            catch (Exception e) {
                Logger.error((String)("\u521b\u5efa " + property.getResolveClass().getName() + " \u5b9e\u4f8b\u5931\u8d25\uff0c\u8bf7\u4fdd\u8bc1\u8be5\u7c7b\u6709\u9ed8\u8ba4\u7684\u6784\u9020\u65b9\u6cd5!"), (Object[])new Object[]{e});
                throw new MapperException("\u521b\u5efa " + property.getResolveClass().getName() + " \u5b9e\u4f8b\u5931\u8d25\uff0c\u8bf7\u4fdd\u8bc1\u8be5\u7c7b\u6709\u9ed8\u8ba4\u7684\u6784\u9020\u65b9\u6cd5!", (Throwable)e);
            }
        }
        if (property.getMappers() != null && property.getMappers().size() > 0) {
            for (Class mapperClass : property.getMappers()) {
                this.registerMapper(mapperClass);
            }
        }
    }

    public void setProperties(Properties properties) {
        String mapper;
        String resolveClass;
        this.property.setProperties(properties);
        if (properties != null && StringKit.isNotEmpty((CharSequence)(resolveClass = properties.getProperty("resolveClass")))) {
            try {
                EntityBuilder.setResolve((EntityResolve)Class.forName(resolveClass).newInstance());
            }
            catch (Exception e) {
                Logger.error((String)("\u521b\u5efa " + resolveClass + " \u5b9e\u4f8b\u5931\u8d25!"), (Object[])new Object[]{e});
                throw new MapperException("\u521b\u5efa " + resolveClass + " \u5b9e\u4f8b\u5931\u8d25!", (Throwable)e);
            }
        }
        if (properties != null && StringKit.isNotEmpty((CharSequence)(mapper = properties.getProperty("mappers")))) {
            String[] mappers;
            for (String mapperClass : mappers = mapper.split(",")) {
                if (mapperClass.length() <= 0) continue;
                this.registerMapper(mapperClass);
            }
        }
    }

    public void setSqlSource(MappedStatement ms, MapperTemplate mapperTemplate) {
        try {
            if (mapperTemplate != null) {
                mapperTemplate.setSqlSource(ms);
            }
        }
        catch (Exception e) {
            throw new MapperException((Throwable)e);
        }
    }

    public void setRawSqlSourceMapper(MappedStatement ms) {
        EntityTable entityTable = EntityBuilder.getEntityTableOrNull(((ResultMap)ms.getResultMaps().get(0)).getType());
        if (entityTable != null) {
            ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
            ResultMap resultMap = entityTable.getResultMap(ms.getConfiguration());
            if (resultMap != null) {
                resultMaps.add(resultMap);
                MetaObject metaObject = org.miaixz.bus.mapper.support.MetaObject.forObject(ms);
                metaObject.setValue("resultMaps", Collections.unmodifiableList(resultMaps));
            }
        }
    }
}

