/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.additional.aggregation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.mapper.additional.aggregation.AggregateType;

public class AggregateCondition
implements Serializable {
    private static final long serialVersionUID = -1L;
    private String aggregateProperty;
    private String aggregateAliasName;
    private List<String> groupByProperties = new ArrayList<String>();
    private AggregateType aggregateType;

    public AggregateCondition() {
        this(null, AggregateType.COUNT, null);
    }

    public AggregateCondition(String aggregateProperty) {
        this(aggregateProperty, AggregateType.COUNT, null);
    }

    public AggregateCondition(String aggregateProperty, String[] groupByProperties) {
        this(aggregateProperty, AggregateType.COUNT, groupByProperties);
    }

    public AggregateCondition(String aggregateProperty, AggregateType aggregateType) {
        this(aggregateProperty, aggregateType, null);
    }

    public AggregateCondition(String aggregateProperty, AggregateType aggregateType, String[] groupByProperties) {
        this.aggregateType(aggregateType);
        if (StringKit.isNotEmpty((CharSequence)aggregateProperty)) {
            this.aggregateBy(aggregateProperty);
        }
        this.groupBy(groupByProperties);
    }

    public static AggregateCondition builder() {
        return new AggregateCondition();
    }

    public AggregateCondition groupBy(String ... groupByProperties) {
        if (groupByProperties != null && groupByProperties.length > 0) {
            this.groupByProperties.addAll(Arrays.asList(groupByProperties));
        }
        return this;
    }

    public AggregateCondition aggregateBy(String aggregateProperty) {
        Assert.notEmpty((CharSequence)aggregateProperty, (String)"aggregateProperty must have length; it must not be null or empty", (Object[])new Object[0]);
        this.aggregateProperty = aggregateProperty;
        return this;
    }

    public AggregateCondition aliasName(String aggregateAliasName) {
        this.aggregateAliasName = aggregateAliasName;
        return this;
    }

    public AggregateCondition aggregateType(AggregateType aggregateType) {
        Assert.notNull((Object)((Object)aggregateType), (String)"aggregateType is required; it must not be null", (Object[])new Object[0]);
        this.aggregateType = aggregateType;
        return this;
    }

    public String getAggregateProperty() {
        return this.aggregateProperty;
    }

    public String getAggregateAliasName() {
        return this.aggregateAliasName;
    }

    public List<String> getGroupByProperties() {
        return this.groupByProperties;
    }

    public AggregateType getAggregateType() {
        return this.aggregateType;
    }
}

