/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.builder.resolve;

import jakarta.persistence.Column;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.UnknownTypeHandler;
import org.miaixz.bus.core.lang.EnumMap;
import org.miaixz.bus.core.lang.annotation.Order;
import org.miaixz.bus.core.lang.exception.MapperException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.logger.Logger;
import org.miaixz.bus.mapper.ORDER;
import org.miaixz.bus.mapper.Registry;
import org.miaixz.bus.mapper.annotation.ColumnType;
import org.miaixz.bus.mapper.annotation.KeySql;
import org.miaixz.bus.mapper.annotation.NameStyle;
import org.miaixz.bus.mapper.builder.FieldBuilder;
import org.miaixz.bus.mapper.builder.resolve.EntityResolve;
import org.miaixz.bus.mapper.entity.EntityColumn;
import org.miaixz.bus.mapper.entity.EntityField;
import org.miaixz.bus.mapper.entity.EntityTable;
import org.miaixz.bus.mapper.entity.Property;
import org.miaixz.bus.mapper.support.GenId;
import org.miaixz.bus.mapper.support.GenSql;
import org.miaixz.bus.mapper.support.SimpleType;
import org.miaixz.bus.mapper.support.SqlWords;

public class DefaultEntityResolve
implements EntityResolve {
    public static String convertByStyle(String text, EnumMap.Naming naming) {
        switch (naming) {
            case CAMEL: {
                return DefaultEntityResolve.camelToUnderline(text);
            }
            case UPPER_CASE: {
                return text.toUpperCase();
            }
            case LOWER_CASE: {
                return text.toLowerCase();
            }
            case CAMEL_UNDERLINE_LOWER_CASE: {
                return DefaultEntityResolve.camelToUnderline(text).toLowerCase();
            }
            case CAMEL_UNDERLINE_UPPER_CASE: {
                return DefaultEntityResolve.camelToUnderline(text).toUpperCase();
            }
        }
        return text;
    }

    public static String camelToUnderline(String text) {
        char[] chars = text.toCharArray();
        int size = chars.length;
        StringBuilder sb = new StringBuilder(size * 3 / 2 + 1);
        for (int i = 0; i < size; ++i) {
            char c = chars[i];
            if (DefaultEntityResolve.isUppercaseAlpha(c)) {
                sb.append('_').append(DefaultEntityResolve.toLowerAscii(c));
                continue;
            }
            sb.append(c);
        }
        return sb.charAt(0) == '_' ? sb.substring(1) : sb.toString();
    }

    public static boolean isUppercaseAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isLowercaseAlpha(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static char toUpperAscii(char c) {
        if (DefaultEntityResolve.isLowercaseAlpha(c)) {
            c = (char)(c - 32);
        }
        return c;
    }

    public static char toLowerAscii(char c) {
        if (DefaultEntityResolve.isUppercaseAlpha(c)) {
            c = (char)(c + 32);
        }
        return c;
    }

    @Override
    public EntityTable resolveEntity(Class<?> entityClass, Property property) {
        Table table;
        EnumMap.Naming naming = property.getStyle();
        if (entityClass.isAnnotationPresent(NameStyle.class)) {
            NameStyle nameStyle = entityClass.getAnnotation(NameStyle.class);
            naming = nameStyle.value();
        }
        EntityTable entityTable = null;
        if (entityClass.isAnnotationPresent(Table.class) && !"".equals((table = entityClass.getAnnotation(Table.class)).name())) {
            entityTable = new EntityTable(entityClass);
            entityTable.setTable(table);
        }
        if (entityTable == null) {
            entityTable = new EntityTable(entityClass);
            String tableName = DefaultEntityResolve.convertByStyle(entityClass.getSimpleName(), naming);
            if (StringKit.isNotEmpty((CharSequence)property.getWrapKeyword()) && SqlWords.containsWord(tableName)) {
                tableName = MessageFormat.format(property.getWrapKeyword(), tableName);
            }
            entityTable.setName(tableName);
        }
        entityTable.setEntityClassColumns(new LinkedHashSet<EntityColumn>());
        entityTable.setEntityClassPKColumns(new LinkedHashSet<EntityColumn>());
        List<EntityField> fields = property.isEnableMethodAnnotation() ? FieldBuilder.getAll(entityClass) : FieldBuilder.getFields(entityClass);
        for (EntityField field : fields) {
            if (property.isUseSimpleType() && (!property.isUseSimpleType() || !SimpleType.isSimpleType(field.getJavaType())) && !field.isAnnotationPresent(Column.class) && !field.isAnnotationPresent(ColumnType.class) && (!property.isEnumAsSimpleType() || !Enum.class.isAssignableFrom(field.getJavaType()))) continue;
            this.processField(entityTable, field, property, naming);
        }
        if (entityTable.getEntityClassPKColumns().size() == 0) {
            entityTable.setEntityClassPKColumns(entityTable.getEntityClassColumns());
        }
        entityTable.initPropertyMap();
        return entityTable;
    }

    protected void processField(EntityTable entityTable, EntityField field, Property property, EnumMap.Naming naming) {
        if (field.isAnnotationPresent(Transient.class)) {
            return;
        }
        EntityColumn entityColumn = new EntityColumn(entityTable);
        entityColumn.setUseJavaType(property.isUseJavaType());
        entityColumn.setEntityField(field);
        if (field.isAnnotationPresent(Id.class)) {
            entityColumn.setId(true);
        }
        String columnName = null;
        if (field.isAnnotationPresent(Column.class)) {
            Column column = field.getAnnotation(Column.class);
            columnName = column.name();
            entityColumn.setUpdatable(column.updatable());
            entityColumn.setInsertable(column.insertable());
        }
        if (field.isAnnotationPresent(ColumnType.class)) {
            ColumnType columnType = field.getAnnotation(ColumnType.class);
            entityColumn.setBlob(columnType.isBlob());
            if (StringKit.isEmpty((CharSequence)columnName) && StringKit.isNotEmpty((CharSequence)columnType.column())) {
                columnName = columnType.column();
            }
            if (columnType.jdbcType() != JdbcType.UNDEFINED) {
                entityColumn.setJdbcType(columnType.jdbcType());
            }
            if (columnType.typeHandler() != UnknownTypeHandler.class) {
                entityColumn.setTypeHandler(columnType.typeHandler());
            }
        }
        if (StringKit.isEmpty(columnName)) {
            columnName = DefaultEntityResolve.convertByStyle(field.getName(), naming);
        }
        if (StringKit.isNotEmpty((CharSequence)property.getWrapKeyword()) && SqlWords.containsWord(columnName)) {
            columnName = MessageFormat.format(property.getWrapKeyword(), columnName);
        }
        entityColumn.setProperty(field.getName());
        entityColumn.setColumn(columnName);
        entityColumn.setJavaType(field.getJavaType());
        if (field.getJavaType().isPrimitive()) {
            Logger.warn((String)("\u901a\u7528 Mapper \u8b66\u544a\u4fe1\u606f: <[" + String.valueOf(entityColumn) + "]> \u4f7f\u7528\u4e86\u57fa\u672c\u7c7b\u578b\uff0c\u57fa\u672c\u7c7b\u578b\u5728\u52a8\u6001 SQL \u4e2d\u7531\u4e8e\u5b58\u5728\u9ed8\u8ba4\u503c\uff0c\u56e0\u6b64\u4efb\u4f55\u65f6\u5019\u90fd\u4e0d\u7b49\u4e8e null\uff0c\u5efa\u8bae\u4fee\u6539\u57fa\u672c\u7c7b\u578b\u4e3a\u5bf9\u5e94\u7684\u5305\u88c5\u7c7b\u578b!"), (Object[])new Object[0]);
        }
        this.processOrderBy(entityTable, field, entityColumn);
        this.processKeyGenerator(entityTable, field, entityColumn);
        entityTable.getEntityClassColumns().add(entityColumn);
        if (entityColumn.isId()) {
            entityTable.getEntityClassPKColumns().add(entityColumn);
        }
    }

    protected void processOrderBy(EntityTable entityTable, EntityField field, EntityColumn entityColumn) {
        String orderBy = "";
        if (field.isAnnotationPresent(OrderBy.class)) {
            orderBy = field.getAnnotation(OrderBy.class).value();
            if ("".equals(orderBy)) {
                orderBy = "ASC";
            }
            Logger.warn((String)(String.valueOf(OrderBy.class) + " is outdated, use " + String.valueOf(Order.class) + " instead!"), (Object[])new Object[0]);
        }
        if (field.isAnnotationPresent(Order.class)) {
            Order order = field.getAnnotation(Order.class);
            orderBy = "".equals(order.value()) && "".equals(orderBy) ? "ASC" : order.value();
            entityColumn.setOrderPriority(order.priority());
        }
        if (StringKit.isNotEmpty((CharSequence)orderBy)) {
            entityColumn.setOrderBy(orderBy);
        }
    }

    protected void processKeyGenerator(EntityTable entityTable, EntityField field, EntityColumn entityColumn) {
        if (field.isAnnotationPresent(KeySql.class)) {
            this.processKeySql(entityTable, entityColumn, field.getAnnotation(KeySql.class));
        } else if (field.isAnnotationPresent(GeneratedValue.class)) {
            this.processGeneratedValue(entityTable, entityColumn, field.getAnnotation(GeneratedValue.class));
        }
    }

    protected void processGeneratedValue(EntityTable entityTable, EntityColumn entityColumn, GeneratedValue generatedValue) {
        if ("JDBC".equals(generatedValue.generator())) {
            entityColumn.setIdentity(true);
            entityColumn.setGenerator("JDBC");
            entityTable.setKeyProperties(entityColumn.getProperty());
            entityTable.setKeyColumns(entityColumn.getColumn());
        } else if (generatedValue.strategy() == GenerationType.IDENTITY) {
            entityColumn.setIdentity(true);
            if (!"".equals(generatedValue.generator())) {
                Registry registry = Registry.getDatabaseDialect(generatedValue.generator());
                String generator = registry != null ? registry.getIdentityRetrievalStatement() : generatedValue.generator();
                entityColumn.setGenerator(generator);
            }
        } else {
            throw new MapperException(entityColumn.getProperty() + " - \u8be5\u5b57\u6bb5@GeneratedValue\u914d\u7f6e\u53ea\u5141\u8bb8\u4ee5\u4e0b\u51e0\u79cd\u5f62\u5f0f:\n1.useGeneratedKeys\u7684@GeneratedValue(generator=\\\"JDBC\\\")  \n2.\u7c7b\u4f3cmysql\u6570\u636e\u5e93\u7684@GeneratedValue(strategy=GenerationType.IDENTITY[,generator=\"Mysql\"])");
        }
    }

    protected void processKeySql(EntityTable entityTable, EntityColumn entityColumn, KeySql keySql) {
        if (keySql.useGeneratedKeys()) {
            entityColumn.setIdentity(true);
            entityColumn.setGenerator("JDBC");
            entityTable.setKeyProperties(entityColumn.getProperty());
            entityTable.setKeyColumns(entityColumn.getColumn());
        } else if (keySql.dialect() == Registry.DEFAULT) {
            entityColumn.setIdentity(true);
            entityColumn.setOrder(ORDER.AFTER);
        } else if (keySql.dialect() != Registry.NULL) {
            entityColumn.setIdentity(true);
            entityColumn.setOrder(ORDER.AFTER);
            entityColumn.setGenerator(keySql.dialect().getIdentityRetrievalStatement());
        } else if (StringKit.isNotEmpty((CharSequence)keySql.sql())) {
            entityColumn.setIdentity(true);
            entityColumn.setOrder(keySql.order());
            entityColumn.setGenerator(keySql.sql());
        } else if (keySql.genSql() != GenSql.NULL.class) {
            entityColumn.setIdentity(true);
            entityColumn.setOrder(keySql.order());
            try {
                GenSql genSql = keySql.genSql().newInstance();
                entityColumn.setGenerator(genSql.genSql(entityTable, entityColumn));
            }
            catch (Exception e) {
                Logger.error((String)("\u5b9e\u4f8b\u5316 GenSql \u5931\u8d25: " + String.valueOf(e)), (Object[])new Object[]{e});
                throw new MapperException("\u5b9e\u4f8b\u5316 GenSql \u5931\u8d25: " + String.valueOf(e), (Throwable)e);
            }
        } else if (keySql.genId() != GenId.NULL.class) {
            entityColumn.setIdentity(false);
            entityColumn.setGenIdClass(keySql.genId());
        } else {
            throw new MapperException(entityTable.getEntityClass().getName() + " \u7c7b\u4e2d\u7684 @KeySql \u6ce8\u89e3\u914d\u7f6e\u65e0\u6548!");
        }
    }
}

