/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper;

import java.sql.Timestamp;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.miaixz.bus.core.lang.exception.VersionException;

public class Version {
    private static final Map<Class<? extends Version>, Version> CACHE = new ConcurrentHashMap<Class<? extends Version>, Version>();
    private static final ReentrantLock LOCK = new ReentrantLock();

    public static Object nextVersion(Class<? extends Version> nextVersionClass, Object version) throws VersionException {
        try {
            Version nextVersion;
            if (CACHE.containsKey(nextVersionClass)) {
                nextVersion = CACHE.get(nextVersionClass);
            } else {
                LOCK.lock();
                try {
                    if (!CACHE.containsKey(nextVersionClass)) {
                        CACHE.put(nextVersionClass, nextVersionClass.newInstance());
                    }
                    nextVersion = CACHE.get(nextVersionClass);
                }
                finally {
                    LOCK.unlock();
                }
            }
            return nextVersion.nextVersion(version);
        }
        catch (Exception e) {
            throw new VersionException("\u83b7\u53d6\u4e0b\u4e00\u4e2a\u7248\u672c\u53f7\u5931\u8d25!", (Throwable)e);
        }
    }

    public Object nextVersion(Object version) throws VersionException {
        if (version == null) {
            throw new VersionException("\u5f53\u524d\u7248\u672c\u53f7\u4e3a\u7a7a!");
        }
        if (version instanceof Integer) {
            return (Integer)version + 1;
        }
        if (version instanceof Long) {
            return (Long)version + 1L;
        }
        if (version instanceof Timestamp) {
            return new Timestamp(System.currentTimeMillis());
        }
        throw new VersionException("\u9ed8\u8ba4\u7684 NextVersion \u53ea\u652f\u6301 Integer, Long \u548c java.sql.Timestamp \u7c7b\u578b\u7684\u7248\u672c\u53f7\uff0c\u5982\u679c\u6709\u9700\u8981\u8bf7\u81ea\u884c\u6269\u5c55!");
    }
}

