/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.mapper.builder;

import java.util.Set;
import org.miaixz.bus.core.lang.exception.VersionException;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.mapper.annotation.LogicDelete;
import org.miaixz.bus.mapper.annotation.Version;
import org.miaixz.bus.mapper.builder.EntityBuilder;
import org.miaixz.bus.mapper.entity.EntityColumn;
import org.miaixz.bus.mapper.entity.TableNames;

public class SqlBuilder {
    public static String getDynamicTableName(Class<?> entityClass, String tableName) {
        if (TableNames.class.isAssignableFrom(entityClass)) {
            StringBuilder sql = new StringBuilder();
            sql.append("<choose>");
            sql.append("<when test=\"@org.miaixz.bus.mapper.OGNL@isDynamicParameter(_parameter) and dynamicTableName != null and dynamicTableName != ''\">");
            sql.append("${dynamicTableName}\n");
            sql.append("</when>");
            sql.append("<otherwise>");
            sql.append(tableName);
            sql.append("</otherwise>");
            sql.append("</choose>");
            return sql.toString();
        }
        return tableName;
    }

    public static String getDynamicTableName(Class<?> entityClass, String tableName, String parameterName) {
        if (TableNames.class.isAssignableFrom(entityClass)) {
            if (StringKit.isNotEmpty((CharSequence)parameterName)) {
                StringBuilder sql = new StringBuilder();
                sql.append("<choose>");
                sql.append("<when test=\"@org.miaixz.bus.mapper.OGNL@isDynamicParameter(" + parameterName + ") and " + parameterName + ".dynamicTableName != null and " + parameterName + ".dynamicTableName != ''\">");
                sql.append("${" + parameterName + ".dynamicTableName}");
                sql.append("</when>");
                sql.append("<otherwise>");
                sql.append(tableName);
                sql.append("</otherwise>");
                sql.append("</choose>");
                return sql.toString();
            }
            return SqlBuilder.getDynamicTableName(entityClass, tableName);
        }
        return tableName;
    }

    public static String getBindCache(EntityColumn column) {
        StringBuilder sql = new StringBuilder();
        sql.append("<bind name=\"");
        sql.append(column.getProperty()).append("_cache\" ");
        sql.append("value=\"").append(column.getProperty()).append("\"/>");
        return sql.toString();
    }

    public static String getBindValue(EntityColumn column, String value) {
        StringBuilder sql = new StringBuilder();
        sql.append("<bind name=\"");
        sql.append(column.getProperty()).append("_bind\" ");
        sql.append("value='").append(value).append("'/>");
        return sql.toString();
    }

    public static String getIfCacheNotNull(EntityColumn column, String contents) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"").append(column.getProperty()).append("_cache != null\">");
        sql.append(contents);
        sql.append("</if>");
        return sql.toString();
    }

    public static String getIfCacheIsNull(EntityColumn column, String contents) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"").append(column.getProperty()).append("_cache == null\">");
        sql.append(contents);
        sql.append("</if>");
        return sql.toString();
    }

    public static String getIfNotNull(EntityColumn column, String contents, boolean empty) {
        return SqlBuilder.getIfNotNull(null, column, contents, empty);
    }

    public static String getIfIsNull(EntityColumn column, String contents, boolean empty) {
        return SqlBuilder.getIfIsNull(null, column, contents, empty);
    }

    public static String getIfNotNull(String entityName, EntityColumn column, String contents, boolean empty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"");
        if (StringKit.isNotEmpty((CharSequence)entityName)) {
            sql.append(entityName).append(".");
        }
        sql.append(column.getProperty()).append(" != null");
        if (empty && column.getJavaType().equals(String.class)) {
            sql.append(" and ");
            if (StringKit.isNotEmpty((CharSequence)entityName)) {
                sql.append(entityName).append(".");
            }
            sql.append(column.getProperty()).append(" != '' ");
        }
        sql.append("\">");
        sql.append(contents);
        sql.append("</if>");
        return sql.toString();
    }

    public static String getIfIsNull(String entityName, EntityColumn column, String contents, boolean empty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"");
        if (StringKit.isNotEmpty((CharSequence)entityName)) {
            sql.append(entityName).append(".");
        }
        sql.append(column.getProperty()).append(" == null");
        if (empty && column.getJavaType().equals(String.class)) {
            sql.append(" or ");
            if (StringKit.isNotEmpty((CharSequence)entityName)) {
                sql.append(entityName).append(".");
            }
            sql.append(column.getProperty()).append(" == '' ");
        }
        sql.append("\">");
        sql.append(contents);
        sql.append("</if>");
        return sql.toString();
    }

    public static String getAllColumns(Class<?> entityClass) {
        Set<EntityColumn> columnSet = EntityBuilder.getColumns(entityClass);
        StringBuilder sql = new StringBuilder();
        for (EntityColumn entityColumn : columnSet) {
            sql.append(entityColumn.getColumn()).append(",");
        }
        return sql.substring(0, sql.length() - 1);
    }

    public static String selectAllColumns(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(SqlBuilder.getAllColumns(entityClass));
        sql.append(" ");
        return sql.toString();
    }

    public static String selectCount(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        Set<EntityColumn> pkColumns = EntityBuilder.getPKColumns(entityClass);
        if (pkColumns.size() == 1) {
            sql.append("COUNT(").append(pkColumns.iterator().next().getColumn()).append(") ");
        } else {
            sql.append("COUNT(*) ");
        }
        return sql.toString();
    }

    public static String selectCountExists(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT CASE WHEN ");
        Set<EntityColumn> pkColumns = EntityBuilder.getPKColumns(entityClass);
        if (pkColumns.size() == 1) {
            sql.append("COUNT(").append(pkColumns.iterator().next().getColumn()).append(") ");
        } else {
            sql.append("COUNT(*) ");
        }
        sql.append(" > 0 THEN 1 ELSE 0 END AS result ");
        return sql.toString();
    }

    public static String fromTable(Class<?> entityClass, String defaultTableName) {
        StringBuilder sql = new StringBuilder();
        sql.append(" FROM ");
        sql.append(SqlBuilder.getDynamicTableName(entityClass, defaultTableName));
        sql.append(" ");
        return sql.toString();
    }

    public static String updateTable(Class<?> entityClass, String defaultTableName) {
        return SqlBuilder.updateTable(entityClass, defaultTableName, null);
    }

    public static String updateTable(Class<?> entityClass, String defaultTableName, String entityName) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(SqlBuilder.getDynamicTableName(entityClass, defaultTableName, entityName));
        sql.append(" ");
        return sql.toString();
    }

    public static String deleteFromTable(Class<?> entityClass, String defaultTableName) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ");
        sql.append(SqlBuilder.getDynamicTableName(entityClass, defaultTableName));
        sql.append(" ");
        return sql.toString();
    }

    public static String insertIntoTable(Class<?> entityClass, String defaultTableName) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append(SqlBuilder.getDynamicTableName(entityClass, defaultTableName));
        sql.append(" ");
        return sql.toString();
    }

    public static String insertIntoTable(Class<?> entityClass, String defaultTableName, String parameterName) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append(SqlBuilder.getDynamicTableName(entityClass, defaultTableName, parameterName));
        sql.append(" ");
        return sql.toString();
    }

    public static String insertColumns(Class<?> entityClass, boolean skipId, boolean notNull, boolean notEmpty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">");
        Set<EntityColumn> columnSet = EntityBuilder.getColumns(entityClass);
        for (EntityColumn column : columnSet) {
            if (!column.isInsertable() || skipId && column.isId()) continue;
            if (notNull) {
                sql.append(SqlBuilder.getIfNotNull(column, column.getColumn() + ",", notEmpty));
                continue;
            }
            sql.append(column.getColumn() + ",");
        }
        sql.append("</trim>");
        return sql.toString();
    }

    public static String insertValuesColumns(Class<?> entityClass, boolean skipId, boolean notNull, boolean notEmpty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<trim prefix=\"VALUES (\" suffix=\")\" suffixOverrides=\",\">");
        Set<EntityColumn> columnSet = EntityBuilder.getColumns(entityClass);
        for (EntityColumn column : columnSet) {
            if (!column.isInsertable() || skipId && column.isId()) continue;
            if (notNull) {
                sql.append(SqlBuilder.getIfNotNull(column, column.getColumnHolder() + ",", notEmpty));
                continue;
            }
            sql.append(column.getColumnHolder() + ",");
        }
        sql.append("</trim>");
        return sql.toString();
    }

    public static String updateSetColumns(Class<?> entityClass, String entityName, boolean notNull, boolean notEmpty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<set>");
        Set<EntityColumn> columnSet = EntityBuilder.getColumns(entityClass);
        EntityColumn versionColumn = null;
        EntityColumn logicDeleteColumn = null;
        for (EntityColumn column : columnSet) {
            if (column.getEntityField().isAnnotationPresent(Version.class)) {
                if (versionColumn != null) {
                    throw new VersionException(entityClass.getName() + " \u4e2d\u5305\u542b\u591a\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5\uff0c\u4e00\u4e2a\u7c7b\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5!");
                }
                versionColumn = column;
            }
            if (column.getEntityField().isAnnotationPresent(LogicDelete.class)) {
                if (logicDeleteColumn != null) {
                    throw new VersionException(entityClass.getName() + " \u4e2d\u5305\u542b\u591a\u4e2a\u5e26\u6709 @LogicDelete \u6ce8\u89e3\u7684\u5b57\u6bb5\uff0c\u4e00\u4e2a\u7c7b\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u5e26\u6709 @LogicDelete \u6ce8\u89e3\u7684\u5b57\u6bb5!");
                }
                logicDeleteColumn = column;
            }
            if (column.isId() || !column.isUpdatable()) continue;
            if (column == versionColumn) {
                Version version = versionColumn.getEntityField().getAnnotation(Version.class);
                String versionClass = version.nextVersion().getName();
                sql.append("<bind name=\"").append(column.getProperty()).append("Version\" value=\"");
                sql.append("@org.miaixz.bus.mapper.Version@nextVersion(").append("@").append(versionClass).append("@class, ");
                if (StringKit.isNotEmpty((CharSequence)entityName)) {
                    sql.append(entityName).append(".");
                }
                sql.append(column.getProperty()).append(")\"/>");
                sql.append(column.getColumn()).append(" = #{").append(column.getProperty()).append("Version},");
                continue;
            }
            if (column == logicDeleteColumn) {
                sql.append(SqlBuilder.logicDeleteColumnEqualsValue(column, false)).append(",");
                continue;
            }
            if (notNull) {
                sql.append(SqlBuilder.getIfNotNull(entityName, column, column.getColumnEqualsHolder(entityName) + ",", notEmpty));
                continue;
            }
            sql.append(column.getColumnEqualsHolder(entityName) + ",");
        }
        sql.append("</set>");
        return sql.toString();
    }

    public static String updateSetColumnsIgnoreVersion(Class<?> entityClass, String entityName, boolean notNull, boolean notEmpty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<set>");
        Set<EntityColumn> columnSet = EntityBuilder.getColumns(entityClass);
        EntityColumn logicDeleteColumn = null;
        for (EntityColumn column : columnSet) {
            if (column.getEntityField().isAnnotationPresent(LogicDelete.class)) {
                if (logicDeleteColumn != null) {
                    throw new VersionException(entityClass.getName() + " \u4e2d\u5305\u542b\u591a\u4e2a\u5e26\u6709 @LogicDelete \u6ce8\u89e3\u7684\u5b57\u6bb5\uff0c\u4e00\u4e2a\u7c7b\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u5e26\u6709 @LogicDelete \u6ce8\u89e3\u7684\u5b57\u6bb5!");
                }
                logicDeleteColumn = column;
            }
            if (!column.isId() && column.isUpdatable()) {
                if (column.getEntityField().isAnnotationPresent(Version.class)) continue;
                if (column == logicDeleteColumn) {
                    sql.append(SqlBuilder.logicDeleteColumnEqualsValue(column, false)).append(",");
                    continue;
                }
                if (notNull) {
                    sql.append(SqlBuilder.getIfNotNull(entityName, column, column.getColumnEqualsHolder(entityName) + ",", notEmpty));
                    continue;
                }
                sql.append(column.getColumnEqualsHolder(entityName) + ",");
                continue;
            }
            if (!column.isId() || !column.isUpdatable()) continue;
            sql.append(column.getColumn()).append(" = ").append(column.getColumn()).append(",");
        }
        sql.append("</set>");
        return sql.toString();
    }

    public static String notAllNullParameterCheck(String parameterName, Set<EntityColumn> columnSet) {
        StringBuilder sql = new StringBuilder();
        sql.append("<bind name=\"notAllNullParameterCheck\" value=\"@org.miaixz.bus.mapper.OGNL@notAllNullParameterCheck(");
        sql.append(parameterName).append(", '");
        StringBuilder fields = new StringBuilder();
        for (EntityColumn column : columnSet) {
            if (fields.length() > 0) {
                fields.append(",");
            }
            fields.append(column.getProperty());
        }
        sql.append((CharSequence)fields);
        sql.append("')\"/>");
        return sql.toString();
    }

    public static String conditionHasAtLeastOneCriteriaCheck(String parameterName) {
        StringBuilder sql = new StringBuilder();
        sql.append("<bind name=\"conditionHasAtLeastOneCriteriaCheck\" value=\"@org.miaixz.bus.mapper.OGNL@conditionHasAtLeastOneCriteriaCheck(");
        sql.append(parameterName).append(")\"/>");
        return sql.toString();
    }

    public static String wherePKColumns(Class<?> entityClass) {
        return SqlBuilder.wherePKColumns(entityClass, false);
    }

    public static String wherePKColumns(Class<?> entityClass, boolean useVersion) {
        return SqlBuilder.wherePKColumns(entityClass, null, useVersion);
    }

    public static String wherePKColumns(Class<?> entityClass, String entityName, boolean useVersion) {
        StringBuilder sql = new StringBuilder();
        boolean hasLogicDelete = SqlBuilder.hasLogicDeleteColumn(entityClass);
        sql.append("<where>");
        Set<EntityColumn> columnSet = EntityBuilder.getPKColumns(entityClass);
        for (EntityColumn column : columnSet) {
            sql.append(" AND ").append(column.getColumnEqualsHolder(entityName));
        }
        if (useVersion) {
            sql.append(SqlBuilder.whereVersion(entityClass));
        }
        if (hasLogicDelete) {
            sql.append(SqlBuilder.whereLogicDelete(entityClass, false));
        }
        sql.append("</where>");
        return sql.toString();
    }

    public static String whereAllIfColumns(Class<?> entityClass, boolean empty) {
        return SqlBuilder.whereAllIfColumns(entityClass, empty, false);
    }

    public static String whereAllIfColumns(Class<?> entityClass, boolean empty, boolean useVersion) {
        StringBuilder sql = new StringBuilder();
        boolean hasLogicDelete = false;
        sql.append("<where>");
        Set<EntityColumn> columnSet = EntityBuilder.getColumns(entityClass);
        EntityColumn logicDeleteColumn = SqlBuilder.getLogicDeleteColumn(entityClass);
        for (EntityColumn column : columnSet) {
            if (useVersion && column.getEntityField().isAnnotationPresent(Version.class)) continue;
            if (logicDeleteColumn != null && logicDeleteColumn == column) {
                hasLogicDelete = true;
                continue;
            }
            sql.append(SqlBuilder.getIfNotNull(column, " AND " + column.getColumnEqualsHolder(), empty));
        }
        if (useVersion) {
            sql.append(SqlBuilder.whereVersion(entityClass));
        }
        if (hasLogicDelete) {
            sql.append(SqlBuilder.whereLogicDelete(entityClass, false));
        }
        sql.append("</where>");
        return sql.toString();
    }

    public static String whereVersion(Class<?> entityClass) {
        return SqlBuilder.whereVersion(entityClass, null);
    }

    public static String whereVersion(Class<?> entityClass, String entityName) {
        Set<EntityColumn> columnSet = EntityBuilder.getColumns(entityClass);
        boolean hasVersion = false;
        Object result = "";
        for (EntityColumn column : columnSet) {
            if (!column.getEntityField().isAnnotationPresent(Version.class)) continue;
            if (hasVersion) {
                throw new VersionException(entityClass.getName() + " \u4e2d\u5305\u542b\u591a\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5\uff0c\u4e00\u4e2a\u7c7b\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u5e26\u6709 @Version \u6ce8\u89e3\u7684\u5b57\u6bb5!");
            }
            hasVersion = true;
            result = " AND " + column.getColumnEqualsHolder(entityName);
        }
        return result;
    }

    public static String whereLogicDelete(Class<?> entityClass, boolean isDeleted) {
        String value = SqlBuilder.logicDeleteColumnEqualsValue(entityClass, isDeleted);
        return "".equals(value) ? "" : " AND " + value;
    }

    public static String logicDeleteColumnEqualsValue(Class<?> entityClass, boolean isDeleted) {
        EntityColumn logicDeleteColumn = SqlBuilder.getLogicDeleteColumn(entityClass);
        if (logicDeleteColumn != null) {
            return SqlBuilder.logicDeleteColumnEqualsValue(logicDeleteColumn, isDeleted);
        }
        return "";
    }

    public static String logicDeleteColumnEqualsValue(EntityColumn column, boolean isDeleted) {
        Object result = "";
        if (column.getEntityField().isAnnotationPresent(LogicDelete.class)) {
            Integer logicDeletedValue = SqlBuilder.getLogicDeletedValue(column, isDeleted);
            result = logicDeletedValue == null ? column.getColumn() + " is null " : column.getColumn() + " = " + logicDeletedValue;
        }
        return result;
    }

    public static Integer getLogicDeletedValue(EntityColumn column, boolean isDeleted) {
        if (!column.getEntityField().isAnnotationPresent(LogicDelete.class)) {
            throw new VersionException(column.getColumn() + " \u6ca1\u6709 @LogicDelete \u6ce8\u89e3!");
        }
        LogicDelete logicDelete = column.getEntityField().getAnnotation(LogicDelete.class);
        if (isDeleted) {
            return logicDelete.isNullForDeletedValue() ? null : Integer.valueOf(logicDelete.isDeletedValue());
        }
        return logicDelete.isNullForNotDeletedValue() ? null : Integer.valueOf(logicDelete.notDeletedValue());
    }

    public static boolean hasLogicDeleteColumn(Class<?> entityClass) {
        return SqlBuilder.getLogicDeleteColumn(entityClass) != null;
    }

    public static EntityColumn getLogicDeleteColumn(Class<?> entityClass) {
        EntityColumn logicDeleteColumn = null;
        Set<EntityColumn> columnSet = EntityBuilder.getColumns(entityClass);
        boolean hasLogicDelete = false;
        for (EntityColumn column : columnSet) {
            if (!column.getEntityField().isAnnotationPresent(LogicDelete.class)) continue;
            if (hasLogicDelete) {
                throw new VersionException(entityClass.getName() + " \u4e2d\u5305\u542b\u591a\u4e2a\u5e26\u6709 @LogicDelete \u6ce8\u89e3\u7684\u5b57\u6bb5\uff0c\u4e00\u4e2a\u7c7b\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u5e26\u6709 @LogicDelete \u6ce8\u89e3\u7684\u5b57\u6bb5!");
            }
            hasLogicDelete = true;
            logicDeleteColumn = column;
        }
        return logicDeleteColumn;
    }

    public static String orderByDefault(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        String orderByClause = EntityBuilder.getOrderByClause(entityClass);
        if (orderByClause.length() > 0) {
            sql.append(" ORDER BY ");
            sql.append(orderByClause);
        }
        return sql.toString();
    }

    public static String conditionSelectColumns(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<choose>");
        sql.append("<when test=\"@org.miaixz.bus.mapper.OGNL@hasSelectColumns(_parameter)\">");
        sql.append("<foreach collection=\"_parameter.selectColumns\" item=\"selectColumn\" separator=\",\">");
        sql.append("${selectColumn}");
        sql.append("</foreach>");
        sql.append("</when>");
        sql.append("<otherwise>");
        sql.append(SqlBuilder.getAllColumns(entityClass));
        sql.append("</otherwise>");
        sql.append("</choose>");
        return sql.toString();
    }

    public static String conditionCountColumn(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<choose>");
        sql.append("<when test=\"@org.miaixz.bus.mapper.OGNL@hasCountColumn(_parameter)\">");
        sql.append("COUNT(<if test=\"distinct\">distinct </if>${countColumn})");
        sql.append("</when>");
        sql.append("<otherwise>");
        sql.append("COUNT(*)");
        sql.append("</otherwise>");
        sql.append("</choose>");
        return sql.toString();
    }

    public static String conditionOrderBy(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"orderByClause != null\">");
        sql.append("order by ${orderByClause}");
        sql.append("</if>");
        String orderByClause = EntityBuilder.getOrderByClause(entityClass);
        if (orderByClause.length() > 0) {
            sql.append("<if test=\"orderByClause == null\">");
            sql.append("ORDER BY " + orderByClause);
            sql.append("</if>");
        }
        return sql.toString();
    }

    public static String conditionOrderBy(String entityName, Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"").append(entityName).append(".orderByClause != null\">");
        sql.append("order by ${").append(entityName).append(".orderByClause}");
        sql.append("</if>");
        String orderByClause = EntityBuilder.getOrderByClause(entityClass);
        if (orderByClause.length() > 0) {
            sql.append("<if test=\"").append(entityName).append(".orderByClause == null\">");
            sql.append("ORDER BY " + orderByClause);
            sql.append("</if>");
        }
        return sql.toString();
    }

    public static String conditionForUpdate() {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"@org.miaixz.bus.mapper.OGNL@hasForUpdate(_parameter)\">");
        sql.append("FOR UPDATE");
        sql.append("</if>");
        return sql.toString();
    }

    public static String conditionCheck(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<bind name=\"checkConditionEntityClass\" value=\"@org.miaixz.bus.mapper.OGNL@checkConditionEntityClass(_parameter, '");
        sql.append(entityClass.getName());
        sql.append("')\"/>");
        return sql.toString();
    }

    public static String conditionWhereClause() {
        return "<if test=\"_parameter != null\"><where>\n ${@org.miaixz.bus.mapper.OGNL@andNotLogicDelete(_parameter)} <trim prefix=\"(\" prefixOverrides=\"and |or \" suffix=\")\">\n  <foreach collection=\"oredCriteria\" item=\"criteria\">\n    <if test=\"criteria.valid\">\n      ${@org.miaixz.bus.mapper.OGNL@andOr(criteria)}      <trim prefix=\"(\" prefixOverrides=\"and |or \" suffix=\")\">\n        <foreach collection=\"criteria.criteria\" item=\"criterion\">\n          <choose>\n            <when test=\"criterion.noValue\">\n              ${@org.miaixz.bus.mapper.OGNL@andOr(criterion)} ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              ${@org.miaixz.bus.mapper.OGNL@andOr(criterion)} ${criterion.condition} #{criterion.value}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              ${@org.miaixz.bus.mapper.OGNL@andOr(criterion)} ${criterion.condition} #{criterion.value} and #{criterion.secondValue}\n            </when>\n            <when test=\"criterion.listValue\">\n              ${@org.miaixz.bus.mapper.OGNL@andOr(criterion)} ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\" open=\"(\" separator=\",\">\n                #{listItem}\n              </foreach>\n            </when>\n          </choose>\n        </foreach>\n      </trim>\n    </if>\n  </foreach>\n </trim>\n</where></if>";
    }

    public static String updateByConditionWhereClause() {
        return "<where>\n ${@org.miaixz.bus.mapper.OGNL@andNotLogicDelete(condition)} <trim prefix=\"(\" prefixOverrides=\"and |or \" suffix=\")\">\n  <foreach collection=\"condition.oredCriteria\" item=\"criteria\">\n    <if test=\"criteria.valid\">\n      ${@org.miaixz.bus.mapper.OGNL@andOr(criteria)}      <trim prefix=\"(\" prefixOverrides=\"and |or \" suffix=\")\">\n        <foreach collection=\"criteria.criteria\" item=\"criterion\">\n          <choose>\n            <when test=\"criterion.noValue\">\n              ${@org.miaixz.bus.mapper.OGNL@andOr(criterion)} ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              ${@org.miaixz.bus.mapper.OGNL@andOr(criterion)} ${criterion.condition} #{criterion.value}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              ${@org.miaixz.bus.mapper.OGNL@andOr(criterion)} ${criterion.condition} #{criterion.value} and #{criterion.secondValue}\n            </when>\n            <when test=\"criterion.listValue\">\n              ${@org.miaixz.bus.mapper.OGNL@andOr(criterion)} ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\" open=\"(\" separator=\",\">\n                #{listItem}\n              </foreach>\n            </when>\n          </choose>\n        </foreach>\n      </trim>\n    </if>\n  </foreach>\n </trim>\n</where>";
    }
}

